/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.base;

import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.item.ItemName;
import com.ef_prime.rflow.ui.flow.rendering.NodeRendering;
import com.ef_prime.rflow.ui.flow.rendering.NodeShape;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class TunnelNodeModel
extends NodeModel {
    private static final int size = 14;
    private static final Shape circleShape = new Ellipse2D.Double(-7.0, -7.0, 14.0, 14.0);
    private static final Icon icon;
    private int type;
    private static final int IN = 0;
    private static final int OUT = 1;
    public static final TunnelNodeModel inModel;
    public static final TunnelNodeModel outModel;
    public static final Stroke BOLDSTROKE;

    private TunnelNodeModel(int n) {
        this.type = n;
    }

    @Override
    public String getCommandImpl(boolean bl, FlowRunOption flowRunOption) {
        return "";
    }

    @Override
    public String getDefaultTitle() {
        switch (this.type) {
            case 0: {
                return Messages.getString("Flow.in");
            }
            case 1: {
                return Messages.getString("Flow.out");
            }
        }
        return null;
    }

    @Override
    public Shape getShape() {
        return circleShape;
    }

    @Override
    public Icon getSmallIcon() {
        return icon;
    }

    @Override
    public Paint getDrawPaint(boolean bl) {
        if (bl) {
            return PICKED_FILLPAINT;
        }
        return FILLPAINT;
    }

    @Override
    public Stroke getStroke() {
        return BOLDSTROKE;
    }

    @Override
    public Paint getFillPaint(boolean bl, boolean bl2) {
        return TRANSPARENT;
    }

    public boolean isInModel() {
        return this.type == 0;
    }

    public boolean isOutModel() {
        return this.type == 1;
    }

    @Override
    public boolean isInsertionEnabled() {
        return false;
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    @Override
    public boolean isProperty() {
        return false;
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    @Override
    public boolean hasCommand() {
        return false;
    }

    @Override
    public boolean canSetBreakpoint() {
        return false;
    }

    @Override
    public List<ItemName> getResults() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public ItemName getPrimaryResult() {
        return null;
    }

    @Override
    public NodeModel copy() {
        return this;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return this == object && super.equals(object);
    }

    static {
        inModel = new TunnelNodeModel(0);
        outModel = new TunnelNodeModel(1);
        BOLDSTROKE = new BasicStroke(2.5f);
        Shape shape = NodeShape.CIRCLE.getShape();
        Rectangle rectangle = shape.getBounds();
        int n = 2;
        BufferedImage bufferedImage = new BufferedImage(rectangle.width + n * 2, rectangle.height + n * 2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        shape = AffineTransform.getTranslateInstance(-rectangle.x + n, -rectangle.y + n).createTransformedShape(shape);
        graphics2D.setPaint(NodeRendering.FILLPAINT);
        graphics2D.setStroke(new BasicStroke(3.2f));
        graphics2D.draw(shape);
        icon = new ImageIcon(bufferedImage.getScaledInstance(16, 16, 4));
        bufferedImage.flush();
    }
}

