/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.group;

import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.node.group.AppearanceGroup;
import com.ef_prime.rflow.node.group.IconAppearanceGroup;
import com.ef_prime.rflow.node.group.ShapeAppearanceGroup;
import com.ef_prime.rflow.node.group.TypeAppearanceGroup;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.flow.rendering.NodeShape;
import java.util.LinkedHashMap;
import java.util.Map;

public enum DefaultAppearanceGroup {
    INOUT(new TypeAppearanceGroup("io")),
    TRANSFORM(new TypeAppearanceGroup("transform")),
    SUMMARY(new TypeAppearanceGroup("summary")),
    CHART(new TypeAppearanceGroup("chart")),
    MODEL(new TypeAppearanceGroup("model")),
    INPUT(Messages.getString("FunctionGroup.input"), Utility.getPathStr("img/node/input.png")),
    OUTPUT(Messages.getString("FunctionGroup.output"), Utility.getPathStr("img/node/output.png")),
    MODELING(Messages.getString("FunctionGroup.modeling"), Utility.getPathStr("img/node/modeling.png")),
    PREDICTION(Messages.getString("FunctionGroup.predict"), Utility.getPathStr("img/node/prediction.png")),
    RANDOM(Messages.getString("FunctionGroup.random"), Utility.getPathStr("img/node/random.png")),
    STAR(NodeShape.STAR);

    private AppearanceGroup group;
    private static Map<String, AppearanceGroup> defaultGroups;

    private DefaultAppearanceGroup(AppearanceGroup appearanceGroup) {
        this.group = appearanceGroup;
    }

    private DefaultAppearanceGroup(NodeShape nodeShape) {
        this.group = new ShapeAppearanceGroup(nodeShape.getName(), nodeShape);
    }

    private DefaultAppearanceGroup(String string2, String string3) {
        this.group = new IconAppearanceGroup(string2, string3);
    }

    public AppearanceGroup getAppearanceGroup() {
        return this.group;
    }

    public static AppearanceGroup[] getAppearanceGroups() {
        return defaultGroups.values().toArray(new AppearanceGroup[defaultGroups.size()]);
    }

    public static AppearanceGroup getGroup(String string) {
        return defaultGroups.get(string);
    }

    public static DefaultAppearanceGroup valueOf(AppearanceGroup appearanceGroup) {
        for (DefaultAppearanceGroup defaultAppearanceGroup : DefaultAppearanceGroup.values()) {
            if (!defaultAppearanceGroup.getAppearanceGroup().equals(appearanceGroup)) continue;
            return defaultAppearanceGroup;
        }
        return null;
    }

    static {
        defaultGroups = new LinkedHashMap<String, AppearanceGroup>();
        for (DefaultAppearanceGroup defaultAppearanceGroup : DefaultAppearanceGroup.values()) {
            defaultGroups.put(defaultAppearanceGroup.name(), defaultAppearanceGroup.getAppearanceGroup());
        }
    }
}

