/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.group;

import com.ef_prime.rflow.node.group.AppearanceGroup;
import com.ef_prime.rflow.ui.flow.rendering.NodeRendering;
import com.ef_prime.rflow.ui.flow.rendering.NodeShape;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ShapeAppearanceGroup
extends AppearanceGroup {
    private NodeShape nodeShape;
    private Icon smallIcon;

    public ShapeAppearanceGroup(String string, NodeShape nodeShape) {
        super(string);
        this.nodeShape = nodeShape;
        Shape shape = this.getShape();
        Rectangle rectangle = shape.getBounds();
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        shape = AffineTransform.getTranslateInstance(-rectangle.x, -rectangle.y).createTransformedShape(shape);
        graphics2D.setPaint(NodeRendering.FILLPAINT);
        graphics2D.fill(shape);
        this.smallIcon = new ImageIcon(bufferedImage.getScaledInstance(16, 16, 4));
        bufferedImage.flush();
    }

    public NodeShape getNodeShape() {
        return this.nodeShape;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public Icon getSmallIcon() {
        return this.smallIcon;
    }

    @Override
    public Shape getShape() {
        return this.nodeShape.getShape();
    }

    @Override
    public Shape getGlassShape() {
        return NodeShape.getGlassShape();
    }
}

