/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.ui;

import com.ef_prime.rflow.core.base.FileEditFiles;
import com.ef_prime.rflow.core.base.FileEditFilesManager;
import com.ef_prime.rflow.core.base.SessionEntry;
import com.ef_prime.rflow.core.common.xml.XmlContext;
import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.node.ui.OpManager;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.ui.view.ViewPosition;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NewNodeSessionEntry
extends SessionEntry {
    private static final Logger LOGGER = Logger.getLogger(NewNodeSessionEntry.class.getName());
    private String title;
    private String modelClass;
    private String fileID;

    public static NewNodeSessionEntry create(String string, String string2, String string3, Icon icon, ViewPosition viewPosition, boolean bl) {
        return new NewNodeSessionEntry(string, string2, string3, icon, viewPosition, bl);
    }

    public NewNodeSessionEntry() {
    }

    private NewNodeSessionEntry(String string, String string2, String string3, Icon icon, ViewPosition viewPosition, boolean bl) {
        super(viewPosition, bl, icon);
        this.title = string;
        this.modelClass = string2;
        this.fileID = string3;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getType() {
        return "new_node";
    }

    @Override
    public String getFileID() {
        return this.fileID;
    }

    @Override
    public void dispose() {
        FileEditFiles.getInstance().removeBackup(this.fileID);
    }

    public Operation getOperation() {
        try {
            Operation operation = OpManager.getInstance().getInstance(this.modelClass);
            if (operation == null) {
                LOGGER.log(Level.SEVERE, "Failed to restore the new node. class: " + this.modelClass);
                return null;
            }
            operation.load(this.fileID);
            this.fileID = FileEditFilesManager.getFileID(operation);
            return operation;
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to restore the new node.", exception);
            return null;
        }
    }

    @Override
    public void storeToElement(XmlContext xmlContext, Document document, Element element) {
        super.storeToElement(xmlContext, document, element);
        element.setAttribute("title", this.title);
        element.setAttribute("modelClass", this.modelClass);
        element.setAttribute("fileID", this.fileID);
    }

    @Override
    public void loadElement(Element element, XmlContext xmlContext) {
        super.loadElement(element, xmlContext);
        this.title = XmlUtility.getAttribute(element, "title", "");
        this.modelClass = XmlUtility.getAttribute(element, "modelClass", null);
        this.fileID = XmlUtility.getAttribute(element, "fileID", null);
    }
}

