/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.ui;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.RAddonBuilderModel;
import com.ef_prime.rflow.core.app.r.RAddonOp;
import com.ef_prime.rflow.core.app.r.RAggregate;
import com.ef_prime.rflow.core.app.r.RCluster;
import com.ef_prime.rflow.core.app.r.RColumnFilter;
import com.ef_prime.rflow.core.app.r.RCorCov;
import com.ef_prime.rflow.core.app.r.RDirectDataInput;
import com.ef_prime.rflow.core.app.r.REditColumns;
import com.ef_prime.rflow.core.app.r.REvaluate;
import com.ef_prime.rflow.core.app.r.RFormula2;
import com.ef_prime.rflow.core.app.r.RLatticeBWPlot;
import com.ef_prime.rflow.core.app.r.RLatticeHistogram;
import com.ef_prime.rflow.core.app.r.RLatticeXYPlot;
import com.ef_prime.rflow.core.app.r.RManageObjects;
import com.ef_prime.rflow.core.app.r.RMerge2;
import com.ef_prime.rflow.core.app.r.RModeling;
import com.ef_prime.rflow.core.app.r.RPrcomp;
import com.ef_prime.rflow.core.app.r.RPredict;
import com.ef_prime.rflow.core.app.r.RPropertyTable;
import com.ef_prime.rflow.core.app.r.RProportionTest2;
import com.ef_prime.rflow.core.app.r.RQPlot;
import com.ef_prime.rflow.core.app.r.RReadObject;
import com.ef_prime.rflow.core.app.r.RReadTable;
import com.ef_prime.rflow.core.app.r.RReplaceMissingValues;
import com.ef_prime.rflow.core.app.r.RReplaceNames;
import com.ef_prime.rflow.core.app.r.RSampleData;
import com.ef_prime.rflow.core.app.r.RSampling;
import com.ef_prime.rflow.core.app.r.RScript;
import com.ef_prime.rflow.core.app.r.RScriptFile;
import com.ef_prime.rflow.core.app.r.RSelectColumns;
import com.ef_prime.rflow.core.app.r.RSelectRows2;
import com.ef_prime.rflow.core.app.r.RSetColumnTypes;
import com.ef_prime.rflow.core.app.r.RSort;
import com.ef_prime.rflow.core.app.r.RTWilcoxTest;
import com.ef_prime.rflow.core.app.r.RWriteObject;
import com.ef_prime.rflow.core.app.r.RWriteTable;
import com.ef_prime.rflow.core.app.r.RXTabs;
import com.ef_prime.rflow.core.base.UserFolder;
import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.node.ui.OpClass;
import com.ef_prime.rflow.node.ui.OpTreeNode;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.node.ui.RAddonOpData;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.event.ChangeEventSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeNode;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OpManager
implements OpClass {
    private static final Logger LOGGER = Logger.getLogger(OpManager.class.getName());
    private static OpManager instance = new OpManager();
    public static final String R_PREFIX = "R:";
    private Map<String, Object> idToModelMap;
    private List<OpTreeNode> trees = new ArrayList<OpTreeNode>();
    private OpTreeNode defaultNode;
    private OpTreeNode addon;
    private OpTreeNode currentTreeNode;
    private ChangeEventSupport eventSupport = new ChangeEventSupport(this);

    public static OpManager getInstance() {
        return instance;
    }

    private OpManager() {
        this.idToModelMap = new HashMap<String, Object>();
        this.idToModelMap.put("ui:r:read.table", RReadTable.class);
        this.idToModelMap.put("ui:r:write.table", RWriteTable.class);
        this.idToModelMap.put("ui:r:column_filter", RColumnFilter.class);
        this.idToModelMap.put("com.ef_prime.rflow.core.app.advanced.node.RSetColumnTypes", RSetColumnTypes.class);
        this.idToModelMap.put("com.ef_prime.rflow.core.app.advanced.node.RReplaceMissingValues", RReplaceMissingValues.class);
    }

    public void init() {
        if (this.defaultNode != null) {
            return;
        }
        this.addon = OpTreeNode.folder("addon");
        this.defaultNode = this.createDefaultToolbar();
        this.loadTrees();
        this.loadAddons(UserFolder.getCustomUIDir());
        this.setCurrentTreeNode(this.defaultNode);
    }

    private OpTreeNode createDefaultToolbar() {
        OpTreeNode opTreeNode = OpTreeNode.rootFolder(Messages.getString("Message.default"));
        OpTreeNode opTreeNode2 = OpTreeNode.folder("io");
        OpTreeNode opTreeNode3 = OpTreeNode.folder("transform");
        OpTreeNode opTreeNode4 = OpTreeNode.folder("chart");
        OpTreeNode opTreeNode5 = OpTreeNode.folder("summary");
        OpTreeNode opTreeNode6 = OpTreeNode.folder("output");
        OpTreeNode opTreeNode7 = OpTreeNode.folder("model");
        OpTreeNode opTreeNode8 = OpTreeNode.folder("script");
        this.add(opTreeNode2, new RReadTable(), new RSampleData(), new RReadObject(), new RDirectDataInput(), new RPropertyTable());
        this.add(opTreeNode3, new REditColumns(), new RReplaceNames(), new RSetColumnTypes(), new RSelectRows2(), new RSelectColumns(), new RReplaceMissingValues(), new RSort(), new RSampling(), new RAggregate(), new RMerge2(), new RManageObjects());
        this.add(opTreeNode4, new RLatticeHistogram(), new RLatticeBWPlot(), new RLatticeXYPlot(), new RQPlot());
        this.add(opTreeNode5, new RXTabs(), new RCorCov(), new RTWilcoxTest(), new RProportionTest2(), new RPrcomp(), new RCluster());
        this.add(opTreeNode7, new RModeling(), new RPredict(), new REvaluate(), new RFormula2());
        this.add(opTreeNode6, new RWriteTable(), new RWriteObject());
        this.add(opTreeNode8, new RScript(), new RScriptFile());
        opTreeNode.add(opTreeNode2);
        opTreeNode.add(opTreeNode3);
        opTreeNode.add(opTreeNode4);
        opTreeNode.add(opTreeNode5);
        opTreeNode.add(opTreeNode7);
        opTreeNode.add(opTreeNode6);
        opTreeNode.add(opTreeNode8);
        return opTreeNode;
    }

    private void loadTrees() {
        this.trees.clear();
        this.trees.add(this.defaultNode);
        File file = UserFolder.getUserDirFile("toolbar");
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            this.loadToolbar(file2, null);
        }
    }

    public void loadToolbar(File file, File file2) {
        try {
            Iterable<Element> iterable;
            Object object;
            Object object2;
            if (!FilenameUtils.isExtension((String)file.getName(), (String)"xml")) {
                return;
            }
            Document document = XmlUtility.readXml(file);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Element element = XmlUtility.getChild("i18n", document.getDocumentElement());
            if (element != null && (object2 = XmlUtility.getChild((String)(object = Locale.getDefault().getLanguage()), element)) != null) {
                iterable = XmlUtility.getChildren("replace", (Element)object2);
                for (Element element2 : iterable) {
                    String string = element2.getAttribute("from");
                    if (StringUtils.isEmpty((CharSequence)string)) continue;
                    String string2 = element2.getAttribute("to");
                    hashMap.put(string, string2);
                }
            }
            if ((object = XmlUtility.getChild("toolbar", document.getDocumentElement())) == null) {
                throw new IOException("No 'toolbar' element found.");
            }
            object2 = object.getAttribute("name");
            if (StringUtils.isEmpty((CharSequence)(object2 = (String)hashMap.getOrDefault(object2, (String)object2)))) {
                object2 = FilenameUtils.removeExtension((String)file.getName());
            }
            iterable = OpTreeNode.rootFolder((String)object2);
            this.load((OpTreeNode)iterable, (Element)object, (Map<String, String>)hashMap, file2 == null ? null : file2.toPath());
            this.trees.add((OpTreeNode)iterable);
            if (Rflow.isDevel() && ((String)object2).equals("Advanced")) {
                this.setCurrentTreeNode((OpTreeNode)iterable);
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Failed to read: " + file.getPath(), iOException);
        }
    }

    private void load(OpTreeNode opTreeNode, Element element, Map<String, String> map, Path path) {
        List<Element> list = XmlUtility.elements(element);
        block10: for (Element element2 : list) {
            String string = element2.getTagName();
            String string2 = element2.getAttribute("name");
            string2 = map.getOrDefault(string2, string2);
            switch (string) {
                case "folder": {
                    String string3 = element2.getAttribute("id");
                    String string4 = element2.getAttribute("icon");
                    String string5 = element2.getAttribute("smallIcon");
                    OpTreeNode opTreeNode2 = opTreeNode.getChildById(string3);
                    if (opTreeNode2 == null) {
                        if (path != null && (string4.startsWith("plugin:") || string5.startsWith("plugin:"))) {
                            if (StringUtils.isEmpty((CharSequence)string5)) {
                                string5 = string4;
                            }
                            opTreeNode2 = OpTreeNode.folder(string3, string2, this.resolveIcon(string5, true, path), this.resolveIcon(string4, false, path));
                        } else {
                            opTreeNode2 = OpTreeNode.folder(string3, string2, string5, string4);
                        }
                        opTreeNode.add(opTreeNode2);
                    }
                    this.load(opTreeNode2, element2, map, path);
                    break;
                }
                case "node": {
                    if (string2.isEmpty()) {
                        string2 = null;
                    }
                    OpTreeNode opTreeNode3 = OpTreeNode.model(string2, element2.getTextContent());
                    opTreeNode.add(opTreeNode3);
                    break;
                }
                case "default": {
                    for (OpTreeNode opTreeNode4 : this.defaultNode) {
                        opTreeNode.add(opTreeNode4.copy());
                    }
                    continue block10;
                }
            }
        }
    }

    private Icon resolveIcon(String string, boolean bl, Path path) {
        if (string.startsWith("plugin:")) {
            string = string.substring("plugin:".length());
            return new ImageIcon(path.resolve(string).toAbsolutePath().toString());
        }
        return bl ? OpClass.getSmallIcon(string) : OpClass.getIcon(string);
    }

    private void loadAddons(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        String[] stringArray = new String[]{"yml", "yaml"};
        for (File file2 : fileArray) {
            if (!FilenameUtils.isExtension((String)file2.getName(), (String[])stringArray)) continue;
            try (FileInputStream fileInputStream = new FileInputStream(file2);){
                Iterable iterable = new YamlEx().loadAll(fileInputStream);
                if (!iterable.iterator().hasNext()) continue;
                Object t = iterable.iterator().next();
                try {
                    RAddonBuilderModel rAddonBuilderModel = new RAddonBuilderModel(null);
                    rAddonBuilderModel.load(t);
                    RAddonOpData rAddonOpData = rAddonBuilderModel.getModelData(file2.getName());
                    RAddonOp rAddonOp = new RAddonOp(rAddonOpData);
                    this.add(this.addon, rAddonOp);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, "Failed to read document in file: " + file2.getPath(), exception);
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Failed to read: " + file2.getPath(), exception);
            }
        }
    }

    private void add(OpTreeNode opTreeNode, Operation ... operationArray) {
        for (Operation operation : operationArray) {
            operation.loadResource();
            opTreeNode.add(OpTreeNode.model(operation));
            this.idToModelMap.put(operation.getId(), operation);
        }
    }

    public void add(String string, Class<? extends Operation> clazz) {
        this.idToModelMap.put(string, clazz);
    }

    public void add(Operation operation) {
        operation.loadResource();
        this.idToModelMap.put(operation.getId(), operation);
    }

    public void updateAddonModel(Operation operation) {
        OpTreeNode opTreeNode = null;
        Enumeration<TreeNode> enumeration = this.addon.children();
        while (enumeration.hasMoreElements()) {
            OpTreeNode opTreeNode2 = (OpTreeNode)enumeration.nextElement();
            if (!opTreeNode2.isModelValid() || !opTreeNode2.getModel().getId().equals(operation.getId())) continue;
            opTreeNode = opTreeNode2;
            break;
        }
        if (opTreeNode != null) {
            operation.loadResource();
            opTreeNode.setModel(operation);
            this.idToModelMap.put(operation.getId(), operation);
        } else {
            this.add(this.addon, operation);
        }
    }

    public List<OpTreeNode> getTrees() {
        return this.trees;
    }

    public OpTreeNode getDefaultNode() {
        return this.defaultNode;
    }

    public OpTreeNode getAddon() {
        return this.addon;
    }

    public void addToAddon(Operation operation) {
        this.add(this.addon, operation);
    }

    public void removeAddon(OpTreeNode opTreeNode) {
        this.addon.remove(opTreeNode);
        this.idToModelMap.remove(opTreeNode.getModel().getId());
    }

    public void setCurrentTreeNode(OpTreeNode opTreeNode) {
        if (this.currentTreeNode != opTreeNode) {
            this.currentTreeNode = opTreeNode;
            this.eventSupport.dispatchEvent();
        }
    }

    public OpTreeNode getCurrentTreeNode() {
        return this.currentTreeNode;
    }

    public Operation getInstance(String object) {
        if (((String)object).startsWith(R_PREFIX)) {
            object = "com.ef_prime.rflow.core.app.r." + ((String)object).substring(R_PREFIX.length());
        }
        Object object2 = this.idToModelMap.get(object);
        try {
            if (object2 == null) {
                Class<?> clazz = Class.forName((String)object);
                Object object3 = this.idToModelMap.get(object);
                if (object3 instanceof Operation) {
                    return ((Operation)object3).copy();
                }
                Object obj = clazz.newInstance();
                if (!(obj instanceof Operation)) {
                    return null;
                }
                Operation operation = (Operation)obj;
                if (!this.idToModelMap.containsKey(operation.getId())) {
                    this.add(operation);
                    operation = operation.copy();
                }
                return operation;
            }
            if (object2 instanceof Operation) {
                return ((Operation)object2).copy();
            }
            if (object2 instanceof Class) {
                Object t = ((Class)object2).newInstance();
                if (!(t instanceof Operation)) {
                    return null;
                }
                Operation operation = (Operation)t;
                Object object4 = this.idToModelMap.get(operation.getId());
                if (object4 instanceof Operation) {
                    return ((Operation)object4).copy();
                }
                if (object4 == null) {
                    this.add(operation);
                    operation = operation.copy();
                }
                return operation.copy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void addChangeEventHandler(ChangeEventHandler changeEventHandler) {
        this.eventSupport.addEventHandler(changeEventHandler);
    }

    public void removeChangeEventHandler(ChangeEventHandler changeEventHandler) {
        this.eventSupport.removeEventHandler(changeEventHandler);
    }
}

