/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.ui;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.DevelSettings;
import com.ef_prime.rflow.core.base.FileEditBackups;
import com.ef_prime.rflow.core.base.FileEditEvent;
import com.ef_prime.rflow.core.base.FileEditEventHandler;
import com.ef_prime.rflow.core.base.FileEditManager;
import com.ef_prime.rflow.core.base.FileEditSupplier;
import com.ef_prime.rflow.core.base.SessionEntry;
import com.ef_prime.rflow.core.base.SessionEntrySupplier;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.feature.history.FlowNodeTransferable;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.node.OpExecutor;
import com.ef_prime.rflow.core.task.NodeModelTask;
import com.ef_prime.rflow.core.task.TaskQueue;
import com.ef_prime.rflow.node.ui.NewNodeSessionEntry;
import com.ef_prime.rflow.node.ui.OpPage;
import com.ef_prime.rflow.node.ui.OpView;
import com.ef_prime.rflow.node.ui.OpViewFactory;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.node.ui.UINodeModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.base.Preview;
import com.ef_prime.rflow.ui.base.ActiveViewerListener;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.event.ChangeEvent;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.item.Item;
import com.ef_prime.rflow.ui.common.item.ItemName;
import com.ef_prime.rflow.ui.common.view.Page;
import com.ef_prime.rflow.ui.common.view.PagesView;
import com.ef_prime.rflow.ui.common.view.PagesViewEvent;
import com.ef_prime.rflow.ui.common.view.PagesViewEventHandler;
import com.ef_prime.rflow.ui.common.view.ToolbarSupport;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.PreviewRunEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.EmptyBorder;

public class OpPagesView
extends PagesView
implements ActiveViewerListener,
PagesViewEventHandler,
FileEditEventHandler,
ChangeEventHandler,
SessionEntrySupplier {
    private Operation uiModel;
    protected JButton dragToAddButton;
    protected JButton runButton;
    private OpExecutor executor;
    protected Preview pre;
    public static final int RESULT_RUN = -1;
    public static final int RESULT_ADD_AND_RUN = -2;

    public OpPagesView(Operation operation, Item item) {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.uiModel = operation;
        this.uiModel.initialize(false);
        if (item != null) {
            this.uiModel.importTransferable(item);
        }
        this.setPage(this.createPage(this.uiModel));
        this.backButton.setVisible(false);
        this.add((Component)this.createButtons(), "North");
    }

    public Operation getOperation() {
        return this.uiModel;
    }

    private OpPage createPage(Operation operation) {
        this.executor = new OpExecutor(operation);
        ValueMap valueMap = new ValueMap();
        valueMap.putValue(OpExecutor.PROPERTY_EXECUTOR, this.executor);
        boolean bl = !Rflow.develSettings().getValue(DevelSettings.UINODE_WINDOW).equals("left bottom tab") && Rflow.develSettings().getValue(DevelSettings.KEY_SHOW_PREVIEW_INSIDE_TAB) != false;
        OpView opView = OpViewFactory.getInstance().createView(operation, bl, this.isTab(), valueMap);
        this.pre = (Preview)opView.getClientProperty("PROPERTY_PREVIEW");
        this.runButton.setText(Messages.getString("Button.run") + "  ");
        if (this.pre != null) {
            this.pre.addChangeEventHandler(new PreviewChangeEventHandler());
        }
        this.executor.setFocusResult(true);
        opView.startEditing();
        return new OpPage(operation, opView);
    }

    protected boolean isTab() {
        return false;
    }

    @Override
    public String getTitle() {
        return this.uiModel == null ? "" : this.uiModel.getSummary();
    }

    @Override
    public Icon getIcon() {
        Icon icon;
        Icon icon2 = icon = this.uiModel == null ? null : this.uiModel.getSmallIcon();
        if (icon == null) {
            return null;
        }
        String string = "16/add.png";
        int n = 11;
        return Icons.getOverlaidIcon(icon, string, n, -1, 16 - n);
    }

    public void startEditing() {
        Page page = this.getCurrentPage();
        if (page instanceof OpPage) {
            ((OpPage)page).startEditing();
        }
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        this.addPagesViewEventHandler(this);
        Rflow.mainView().addActiveViewerListener(this);
        if (this.uiModel instanceof FileEditSupplier) {
            ((FileEditSupplier)((Object)this.uiModel)).load(this);
            ((FileEditSupplier)((Object)this.uiModel)).addFileEditEventHandler(this);
        }
        FileEditManager.getInstance().load(this.uiModel, this);
        this.uiModel.addChangeEventHandler(this);
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        this.removePagesViewEventHandler(this);
        Rflow.mainView().removeActiveViewerListener(this);
        if (this.uiModel instanceof FileEditSupplier) {
            ((FileEditSupplier)((Object)this.uiModel)).unload(this);
            ((FileEditSupplier)((Object)this.uiModel)).removeFileEditEventHandler(this);
        }
        FileEditManager.getInstance().unload(this.uiModel, this);
        this.uiModel.removeChangeEventHandler(this);
        this.saveSessionEntryToHistory();
    }

    @Override
    protected void next() {
        if (!this.getCurrentPage().hasNextPage() && !this.canAdd()) {
            return;
        }
        super.next();
    }

    protected boolean addEnabled() {
        return true;
    }

    @Override
    public void refreshButtons() {
        super.refreshButtons();
        this.dragToAddButton.setVisible(this.addEnabled() && !this.getCurrentPage().hasNextPage());
        this.runButton.setText(Messages.getString("Button.run") + "  ");
    }

    private boolean canAdd() {
        return Rflow.mainView().getPrimaryFlowViewer() != null;
    }

    @Override
    protected void setPage(Page page) {
        super.setPage(page);
        this.runButton.setVisible(!page.hasNextPage());
    }

    @Override
    protected void addButtons() {
        this.initButtons();
    }

    protected void initButtons() {
        this.backButton = this.createBackButton();
        this.dragToAddButton = new JButton(new DragToAddAction()){

            @Override
            public Point getLocationOnScreen() {
                if (!this.isShowing()) {
                    return new Point();
                }
                return super.getLocationOnScreen();
            }
        };
        DragToAddTransferHandler dragToAddTransferHandler = new DragToAddTransferHandler();
        this.dragToAddButton.setTransferHandler(dragToAddTransferHandler);
        this.dragToAddButton.addMouseMotionListener(dragToAddTransferHandler);
        this.dragToAddButton.setFocusable(false);
        this.cancelButton = this.createCancelButton();
        this.runButton = this.createRunButton();
    }

    @Override
    protected JToolBar createButtons() {
        JComponent jComponent;
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(this.runButton);
        if (this.getOperation().supportsPreview()) {
            jComponent = new JButton(new PreviewRun());
            jToolBar.add(jComponent);
        }
        jComponent = ((OpPage)this.getCurrentPage()).getView();
        ToolbarSupport.configureToolBar(jComponent, jToolBar);
        jToolBar.add(this.dragToAddButton);
        return jToolBar;
    }

    private JButton createRunButton() {
        JButton jButton = new JButton(Messages.getString("Button.run"));
        jButton.setIcon(Icons.getIcon("16/resultset_next.png"));
        jButton.setVisible(false);
        jButton.addActionListener(new RunAction());
        return jButton;
    }

    @Override
    protected JButton createCancelButton() {
        return this.createButton(Messages.getString("Button.close") + "   ", "16/cross.png", "CANCEL");
    }

    protected void cancelNodeDrag(boolean bl) {
        this.showDialog();
    }

    protected void startNodeDrag() {
        this.hideDialog();
    }

    private boolean checkOverwrite() {
        if (!Rflow.develSettings().getValue(DevelSettings.KEY_CONFIRM_R_OBJECT_OVERWRITE).booleanValue()) {
            return true;
        }
        List<ItemName> list = this.uiModel.checkOverwrite();
        if (list == null || list.isEmpty()) {
            return true;
        }
        String string = list.stream().map(itemName -> itemName.getName()).collect(Collectors.joining(", "));
        String string2 = Messages.format("Message.confirm_object_overwrite", string);
        int n = JOptionPane.showConfirmDialog(SwingUtilities.windowForComponent(this), string2, Messages.getString("Error.title.warning"), 0, 2);
        return n == 0;
    }

    @Override
    public SessionEntry getSessionEntry(boolean bl) {
        return NewNodeSessionEntry.create(this.uiModel.getTitle(), this.uiModel.getClass().getName(), FileEditBackups.getFileID(this.uiModel), this.getIcon(), this.getViewPosition(), this.isShowing());
    }

    @Override
    public void activeViewerChanged(FlowViewer flowViewer) {
        UIUtility.invokeLater(new Runnable(){

            @Override
            public void run() {
                OpPagesView.this.refreshButtons();
            }
        });
    }

    @Override
    public void pagesViewDone(PagesViewEvent pagesViewEvent) {
        if (this.uiModel != null) {
            UINodeModel uINodeModel = new UINodeModel(this.uiModel);
            switch (pagesViewEvent.getView().getResult()) {
                default: 
            }
            switch (pagesViewEvent.getView().getResult()) {
                case -2: 
                case -1: {
                    NodeModelTask nodeModelTask = new NodeModelTask(new FlowRunOption(), uINodeModel);
                    TaskQueue.getInstance().addTask(nodeModelTask);
                }
            }
        }
    }

    @Override
    public void fileEditStateChanged(FileEditEvent fileEditEvent) {
        this.updateTab();
    }

    @Override
    public void handleChanged(ChangeEvent changeEvent) {
        this.uiModel.setDirty(true);
    }

    private class PreviewChangeEventHandler
    implements ChangeEventHandler {
        private PreviewChangeEventHandler() {
        }

        @Override
        public void handleChanged(ChangeEvent changeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OpPagesView.this.refreshButtons();
                }
            });
        }
    }

    private class DragToAddAction
    extends LoggableAction {
        public DragToAddAction() {
            this.putValue("Name", Messages.getString("Action.drag_to_add") + "  ");
            this.putValue("SmallIcon", Icons.getIcon("16/add.png"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
        }
    }

    private class DragToAddTransferHandler
    extends TransferHandler
    implements MouseMotionListener {
        private boolean dragging = false;

        private DragToAddTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 3;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            if (OpPagesView.this.uiModel != null) {
                ImageIcon imageIcon = (ImageIcon)OpPagesView.this.uiModel.getIcon();
                this.setDragImage(imageIcon.getImage());
                this.setDragImageOffset(new Point(imageIcon.getIconWidth() / 2, imageIcon.getIconHeight() / 2));
                FlowNode flowNode = new FlowNode(new UINodeModel(OpPagesView.this.uiModel));
                return new FlowNodeTransferable(flowNode);
            }
            return null;
        }

        @Override
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (n == 2) {
                OpPagesView.this.result = 1;
                OpPagesView.this.close();
            } else {
                OpPagesView.this.dragToAddButton.getModel().setRollover(false);
                OpPagesView.this.dragToAddButton.getModel().setArmed(false);
                OpPagesView.this.dragToAddButton.getModel().setPressed(false);
                OpPagesView.this.dragToAddButton.getModel().setSelected(false);
                OpPagesView.this.cancelNodeDrag(n == 1);
            }
            this.dragging = false;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this.dragging) {
                this.exportAsDrag((JComponent)mouseEvent.getComponent(), mouseEvent, 2);
                OpPagesView.this.startNodeDrag();
                this.dragging = true;
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    protected class PreviewRun
    extends LoggableAction {
        public PreviewRun() {
            this.putValue("Name", Messages.getString("Action.preview_run"));
            this.putValue("SmallIcon", Icons.getIcon("16/page_white_magnify.png"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            if (OpPagesView.this.pre != null) {
                OpPagesView.this.pre.refresh();
                OpPagesView.this.pre.toFront();
            } else {
                EventManager.getInstance().dispatchEvent(new PreviewRunEvent(OpPagesView.this.getOperation(), null));
            }
        }
    }

    private class RunAction
    implements ActionListener {
        private RunAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!OpPagesView.this.checkOverwrite()) {
                return;
            }
            if (OpPagesView.this.pre != null) {
                OpPagesView.this.pre.run();
                OpPagesView.this.pre.toFront();
            } else if (OpPagesView.this.executor != null) {
                OpPagesView.this.executor.run();
            }
            OpPagesView.this.refreshButtons();
        }
    }
}

