/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.ui;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.RAddonBuilderModel;
import com.ef_prime.rflow.core.app.r.RAddonOp;
import com.ef_prime.rflow.core.base.UserFolder;
import com.ef_prime.rflow.core.feature.history.FlowNodeTransferable;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.node.ui.OpManager;
import com.ef_prime.rflow.node.ui.OpTreeNode;
import com.ef_prime.rflow.node.ui.OpWizardAction;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.node.ui.UINodeModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.RUIBuilderView;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.item.Item;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.flow.FlowBrowseView;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;

public class OpPopupMenu {
    public static JPopupMenu createPopupMenu(OpTreeNode opTreeNode, Item item, boolean bl) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (OpTreeNode opTreeNode2 : opTreeNode) {
            if (opTreeNode2.isModel()) {
                if (!opTreeNode2.isModelValid()) continue;
                jPopupMenu.add(new OpWizardAction(opTreeNode2.getModel(), item));
                continue;
            }
            JMenu jMenu = new JMenu(opTreeNode2.getName());
            jMenu.setIcon(opTreeNode2.getSmallIcon());
            for (int i = 0; i < opTreeNode2.getChildCount(); ++i) {
                OpPopupMenu.createOpMenu(jMenu, (OpTreeNode)opTreeNode2.getChildAt(i), item, bl);
            }
            if (jMenu.getItemCount() <= 0) continue;
            jPopupMenu.add(jMenu);
        }
        OpPopupMenu.installDragHandler(jPopupMenu, new OpTransferHandler());
        return jPopupMenu;
    }

    public static JMenu createMenu(Item item, boolean bl) {
        JMenu jMenu = new JMenu(Messages.getString("Action.op"));
        OpTreeNode opTreeNode = OpManager.getInstance().getCurrentTreeNode();
        for (OpTreeNode opTreeNode2 : opTreeNode) {
            OpPopupMenu.createOpMenu(jMenu, opTreeNode2, item, bl);
        }
        OpPopupMenu.createOpMenu(jMenu, OpManager.getInstance().getAddon(), item, bl);
        OpPopupMenu.installDragHandler(jMenu.getPopupMenu(), new OpTransferHandler());
        return jMenu;
    }

    public static JMenu createOnFlowMenu(Function<OpTreeNode, Action> function) {
        JMenu jMenu = new JMenu(Messages.getString("Action.new_op"));
        OpTreeNode opTreeNode = OpManager.getInstance().getCurrentTreeNode();
        for (OpTreeNode opTreeNode2 : opTreeNode) {
            OpPopupMenu.createOpMenu(jMenu, opTreeNode2, null, false, function);
        }
        OpPopupMenu.createOpMenu(jMenu, OpManager.getInstance().getAddon(), null, false, function);
        return jMenu;
    }

    private static void createOpMenu(JMenu jMenu, OpTreeNode opTreeNode2, Item item, boolean bl) {
        OpPopupMenu.createOpMenu(jMenu, opTreeNode2, item, bl, opTreeNode -> new OpWizardAction(opTreeNode.getModel(), item));
    }

    private static void createOpMenu(JMenu jMenu, OpTreeNode opTreeNode, Item item, boolean bl, Function<OpTreeNode, Action> function) {
        if (opTreeNode.isModel()) {
            if (opTreeNode.isModelValid() && (!bl || opTreeNode.getModel().canImport(item))) {
                jMenu.add(function.apply(opTreeNode));
            }
        } else {
            JMenu jMenu2 = new JMenu(opTreeNode.getName());
            jMenu2.setIcon(opTreeNode.getSmallIcon());
            for (int i = 0; i < opTreeNode.getChildCount(); ++i) {
                OpPopupMenu.createOpMenu(jMenu2, (OpTreeNode)opTreeNode.getChildAt(i), item, bl, function);
            }
            if (jMenu2.getItemCount() > 0) {
                jMenu.add(jMenu2);
            }
        }
    }

    private static void installDragHandler(JPopupMenu jPopupMenu, OpTransferHandler opTransferHandler) {
        if (jPopupMenu == null) {
            return;
        }
        for (Component component : jPopupMenu.getComponents()) {
            if (component instanceof JMenu) {
                OpPopupMenu.installDragHandler(((JMenu)component).getPopupMenu(), opTransferHandler);
                continue;
            }
            if (!(component instanceof JMenuItem)) continue;
            UIUtility.insertMouseListener(component, opTransferHandler);
            ((JMenuItem)component).setTransferHandler(opTransferHandler);
            ((JMenuItem)component).addMenuDragMouseListener(opTransferHandler);
        }
    }

    private static class OpTransferHandler
    extends TransferHandler
    implements MouseListener,
    MenuDragMouseListener {
        private MouseEvent dndStartEvent;

        private OpTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            Action action;
            Object object;
            if (jComponent instanceof JMenuItem && (object = (action = ((JMenuItem)jComponent).getAction()).getValue("SwingLargeIconKey")) instanceof ImageIcon) {
                ImageIcon imageIcon = (ImageIcon)object;
                this.setDragImage(imageIcon.getImage());
                this.setDragImageOffset(new Point(imageIcon.getIconWidth() / 2, imageIcon.getIconHeight() / 2));
            }
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            Operation operation = this.getOperation(jComponent);
            if (operation == null) {
                return null;
            }
            FlowNode flowNode = new FlowNode(new UINodeModel(operation));
            return new FlowNodeTransferable(flowNode);
        }

        private Operation getOperation(JComponent jComponent) {
            if (!(jComponent instanceof AbstractButton)) {
                return null;
            }
            AbstractButton abstractButton = (AbstractButton)jComponent;
            Action action = abstractButton.getAction();
            if (!(action instanceof OpWizardAction)) {
                return null;
            }
            OpWizardAction opWizardAction = (OpWizardAction)action;
            return opWizardAction.getModelForTransfer();
        }

        @Override
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            Container container;
            if (n == 1 && (container = Rflow.mainView().getActiveView()) instanceof FlowBrowseView) {
                ((FlowBrowseView)container).getPreviewView().startEditing();
            }
            if ((container = SwingUtilities.getUnwrappedParent(jComponent)) instanceof JPopupMenu) {
                JPopupMenu jPopupMenu = this.getRootPopupMenu((JPopupMenu)container);
                jPopupMenu.setVisible(false);
            }
        }

        private JPopupMenu getRootPopupMenu(JPopupMenu jPopupMenu) {
            while (jPopupMenu != null && jPopupMenu.getInvoker() instanceof JMenu && jPopupMenu.getInvoker().getParent() instanceof JPopupMenu) {
                jPopupMenu = (JPopupMenu)jPopupMenu.getInvoker().getParent();
            }
            return jPopupMenu;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (UIUtility.isLeftMouseButton(mouseEvent)) {
                this.dndStartEvent = mouseEvent;
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.dndStartEvent = null;
            if (UIUtility.isRightMouseButton(mouseEvent)) {
                Operation operation = this.getOperation((JComponent)mouseEvent.getSource());
                if (!(operation instanceof RAddonOp)) {
                    return;
                }
                mouseEvent.getComponent().setEnabled(false);
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(new Edit((RAddonOp)operation));
                Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), Rflow.mainFrame());
                jPopupMenu.show(Rflow.mainFrame(), point.x, point.y);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            if (this.dndStartEvent == null) {
                return;
            }
            Point point = this.dndStartEvent.getPoint();
            Point point2 = menuDragMouseEvent.getPoint();
            if (point2.distance(point) < 10.0) {
                return;
            }
            this.exportAsDrag((JComponent)menuDragMouseEvent.getSource(), this.dndStartEvent, 1);
            this.dndStartEvent = null;
        }

        @Override
        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        }

        @Override
        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        @Override
        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        }
    }

    private static class Edit
    extends LoggableAction {
        private RAddonOp model;

        public Edit(RAddonOp rAddonOp) {
            this.putValue("Name", Messages.getStringWithDots("Action.edit"));
            this.model = rAddonOp;
        }

        @Override
        public void action(ActionEvent actionEvent) {
            String string = this.model.getData().getPath();
            File file = UserFolder.getCustomUIDir();
            File file2 = new File(file, string);
            RAddonBuilderModel rAddonBuilderModel = new RAddonBuilderModel(file2);
            try {
                rAddonBuilderModel.load();
                Rflow.mainView().getDefaultFlowPane().openView(new RUIBuilderView(rAddonBuilderModel), ViewOpenType.OPEN_NEW, true);
            }
            catch (IOException iOException) {
                UIUtility.showErrorDialog((Component)Rflow.mainFrame(), Messages.getString("Error.read") + ": " + String.valueOf(new File(file, string)), iOException);
            }
        }
    }
}

