/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.ui;

import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandUtility;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.feature.search.TextSearchResult;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.script.AbstractRCodingTextArea;
import com.ef_prime.rflow.ui.app.r.script.RCodingTextArea;
import com.ef_prime.rflow.ui.app.r.script.RScriptUtility;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.UIColor;
import com.ef_prime.rflow.ui.common.view.LazyLoadView;
import javax.swing.SwingWorker;

public class OpRScriptView
extends LazyLoadView
implements ValueChangeEventHandler {
    private AbstractRCodingTextArea textArea;
    private Operation model;

    public OpRScriptView(ValueMap valueMap, WidgetNode widgetNode) {
        this((Operation)valueMap);
    }

    public OpRScriptView(Operation operation) {
        this.model = operation;
        this.setIcon(Icons.getIcon("16/script.png"));
        this.setIconOnly(true);
        this.setIconToolTip(Messages.getString("Widget.R.script"));
    }

    @Override
    protected void loadContent() {
        this.textArea = new RCodingTextArea();
        this.textArea.setEditable(false);
        this.textArea.setBracketMatchingEnabled(false);
        this.textArea.setBackground(UIColor.UNEDITABLE_BACKGROUND);
        this.textArea.setCodeFoldingEnabled(true);
        this.add(RScriptUtility.createScriptPane(this.textArea));
        this.refresh();
    }

    @Override
    protected void viewShown() {
        super.viewShown();
        if (this.model != null) {
            this.model.removeEventHandler(this);
            this.model.addEventHandler(this);
            this.refresh();
        }
    }

    @Override
    protected void viewHidden() {
        super.viewHidden();
        if (this.model != null) {
            this.model.removeEventHandler(this);
        }
    }

    @Override
    protected String refreshWork() {
        Command command = null;
        try {
            command = this.model.getRCommand(false, false, false, PreviewOption.OFF);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (command == null) {
            return null;
        }
        return CommandUtility.getString(command, false);
    }

    @Override
    protected void refreshWorkDone(Object object) {
        this.textArea.setText(object == null ? "" : (String)object);
        this.textArea.setCaretPosition(0);
    }

    @Override
    public void select(SearchResult searchResult) {
        if (searchResult instanceof TextSearchResult) {
            this.doLoadContent();
            this.doBusyWork(new SelectWorker((TextSearchResult)searchResult));
        }
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        this.refresh();
    }

    private class SelectWorker
    extends SwingWorker<Void, Void> {
        private TextSearchResult r;

        public SelectWorker(TextSearchResult textSearchResult) {
            this.r = textSearchResult;
        }

        @Override
        protected Void doInBackground() throws Exception {
            return null;
        }

        @Override
        protected void done() {
            OpRScriptView.this.textArea.select(this.r.getOffset(), this.r.getOffset() + this.r.getLength());
            OpRScriptView.this.textArea.requestFocusInWindow();
        }
    }
}

