/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.ui;

import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.UIValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.node.ui.Operation;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OpResource {
    public static void main(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray.length <= 2 ? new File("").getAbsolutePath() : stringArray[2];
        OpResource.createResourceTemplate(string2, string, string3);
    }

    private static void createResourceTemplate(String string, String string2, String string3) {
        try {
            OpResource.createResourceTemplate(Class.forName(string), string2, string3);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                ClassPath classPath = ClassPath.from((ClassLoader)Thread.currentThread().getContextClassLoader());
                ImmutableSet immutableSet = classPath.getTopLevelClasses(string);
                for (ClassPath.ClassInfo classInfo : immutableSet) {
                    OpResource.createResourceTemplate(classInfo.load(), string2, string3);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
    }

    private static void createResourceTemplate(Class<?> clazz, String string, String string2) {
        UIValueMap uIValueMap;
        if (!UIValueMap.class.isAssignableFrom(clazz)) {
            return;
        }
        try {
            uIValueMap = (UIValueMap)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            return;
        }
        File file = new File(string2, clazz.getSimpleName() + ".xml");
        if (file.exists()) {
            return;
        }
        Document document = OpResource.createDocument(string, uIValueMap);
        try {
            XmlUtility.writeXml(file, document, 2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static Document createDocument(String string, UIValueMap uIValueMap) {
        Document document = XmlUtility.createDocument();
        Element element = document.createElement("nodedef");
        document.appendChild(element);
        Element element2 = document.createElement("i18n");
        element.appendChild(element2);
        Element element3 = document.createElement(string);
        element2.appendChild(element3);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (uIValueMap instanceof Operation) {
            element3.appendChild(document.createComment("Title"));
            arrayList.add(((Operation)uIValueMap).getTitle());
            OpResource.addReplaceElements(document, element3, arrayList);
        }
        element3.appendChild(document.createComment("Keys"));
        Key<?>[] keyArray = uIValueMap.keys();
        arrayList.clear();
        for (Key<?> key : keyArray) {
            key.localizationValues(arrayList);
        }
        OpResource.addReplaceElements(document, element3, arrayList);
        element3.appendChild(document.createComment("Widgets"));
        WidgetNode widgetNode = uIValueMap.getWidgetNode(ViewOptions.builder().build());
        arrayList.clear();
        widgetNode.localizationValues(arrayList);
        OpResource.addReplaceElements(document, element3, arrayList);
        return document;
    }

    private static void addReplaceElements(Document document, Element element, List<String> list) {
        for (String string : list) {
            if (string == null || string.isEmpty()) continue;
            Element element2 = document.createElement("replace");
            element2.setAttribute("from", string);
            element2.setAttribute("to", "");
            element.appendChild(element2);
        }
    }
}

