/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.ui;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.FileEdit;
import com.ef_prime.rflow.core.base.FileEditSupplier;
import com.ef_prime.rflow.node.base.SubflowNodeView;
import com.ef_prime.rflow.node.ui.OpPage;
import com.ef_prime.rflow.node.ui.OpPagesView;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.ui.base.FileEditUIUtilty;
import com.ef_prime.rflow.ui.common.item.Item;
import com.ef_prime.rflow.ui.common.view.ToolbarSupport;
import com.ef_prime.rflow.ui.common.view.ViewTabbedPane;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;

public class OpTabPagesView
extends OpPagesView {
    public OpTabPagesView(Operation operation, Item item) {
        super(operation, item);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.createButtons(), "North");
    }

    @Override
    protected boolean isTab() {
        return true;
    }

    @Override
    protected void addButtons() {
        this.initButtons();
    }

    @Override
    protected JToolBar createButtons() {
        JComponent jComponent;
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(this.runButton);
        if (this.getOperation().supportsPreview()) {
            jComponent = new JButton(new OpPagesView.PreviewRun());
            jToolBar.add(jComponent);
        }
        jComponent = ((OpPage)this.getCurrentPage()).getView();
        ToolbarSupport.configureToolBar(jComponent, jToolBar);
        jToolBar.add(this.dragToAddButton);
        return jToolBar;
    }

    @Override
    protected void startNodeDrag() {
        this.setTabEnabled(false);
        SubflowNodeView subflowNodeView = Rflow.mainView().getLastActiveFlowView();
        if (subflowNodeView != null) {
            subflowNodeView.toFront();
        }
    }

    @Override
    protected void cancelNodeDrag(boolean bl) {
        this.setTabEnabled(true);
        if (!bl) {
            this.toFront();
        }
    }

    private void setTabEnabled(boolean bl) {
        ViewTabbedPane viewTabbedPane = this.getParentTabbedPane();
        if (viewTabbedPane == null) {
            return;
        }
        int n = viewTabbedPane.getIndexOfView(this.getRootView());
        if (n >= 0 && n < viewTabbedPane.getTabCount()) {
            viewTabbedPane.setEnabledAt(n, bl);
        }
    }

    @Override
    public boolean viewWillClose() {
        if (!this.askSave(false)) {
            return false;
        }
        return super.viewWillClose();
    }

    public boolean askSave(boolean bl) {
        FileEdit fileEdit;
        return this.result == 1 || (fileEdit = this.getFileEdit()) == null || !bl && fileEdit.getProtectCount() != 1 || FileEditUIUtilty.confirmAndSave(fileEdit);
    }

    public FileEdit getFileEdit() {
        FileEditSupplier fileEditSupplier;
        if (this.getOperation() instanceof FileEditSupplier && (fileEditSupplier = (FileEditSupplier)((Object)this.getOperation())) != null) {
            return fileEditSupplier.getFileEdit();
        }
        return null;
    }
}

