/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.ui;

import com.ef_prime.rflow.node.ui.OpClass;
import com.ef_prime.rflow.node.ui.OpManager;
import com.ef_prime.rflow.node.ui.Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang3.StringUtils;

public class OpTreeNode
extends DefaultMutableTreeNode
implements Iterable<OpTreeNode> {
    private static final Logger LOGGER = Logger.getLogger(OpTreeNode.class.getName());
    private String name;
    private String id;
    private Operation model;
    private Icon smallIcon;
    private Icon icon;
    private String modelKey;
    private String smallIconKey;
    private String iconKey;

    public static OpTreeNode folder(String string, String string2, Icon icon, Icon icon2) {
        return new OpTreeNode(string, string2, icon, icon2);
    }

    public static OpTreeNode folder(String string, String string2, String string3, String string4) {
        if (OpClass.isValid(string)) {
            return OpTreeNode.folder(string);
        }
        if (StringUtils.isEmpty((CharSequence)string3)) {
            string3 = string4;
        }
        return new OpTreeNode(string, string2, string3, string4);
    }

    public static OpTreeNode folder(String string) {
        return new OpTreeNode(string, OpClass.getName(string), OpClass.getSmallIcon(string), OpClass.getIcon(string));
    }

    public static OpTreeNode rootFolder(String string) {
        return new OpTreeNode(null, string, (String)null, (String)null);
    }

    public static OpTreeNode model(Operation operation) {
        return new OpTreeNode(operation);
    }

    public static OpTreeNode model(String string, String string2) {
        return new OpTreeNode(string, string2);
    }

    private OpTreeNode(String string, String string2, Icon icon, Icon icon2) {
        this.id = string;
        this.name = string2;
        this.smallIcon = icon;
        this.icon = icon2;
    }

    private OpTreeNode(String string, String string2, String string3, String string4) {
        this.id = string;
        this.name = string2;
        this.smallIconKey = string3;
        this.iconKey = string4;
    }

    private OpTreeNode(Operation operation) {
        this.model = operation;
    }

    private OpTreeNode(String string, String string2) {
        this.name = string;
        this.modelKey = string2;
    }

    private OpTreeNode(OpTreeNode opTreeNode) {
        this.name = opTreeNode.name;
        this.id = opTreeNode.id;
        this.model = opTreeNode.model;
        this.smallIcon = opTreeNode.smallIcon;
        this.icon = opTreeNode.icon;
        this.modelKey = opTreeNode.modelKey;
        this.smallIconKey = opTreeNode.smallIconKey;
        this.iconKey = opTreeNode.iconKey;
        if (opTreeNode.getChildCount() > 0) {
            for (OpTreeNode opTreeNode2 : opTreeNode) {
                this.add(opTreeNode2.copy());
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.model != null) {
            return this.model.getTitle();
        }
        return "";
    }

    public boolean isModel() {
        return this.model != null || this.modelKey != null;
    }

    public boolean isModelValid() {
        return this.getModel() != null;
    }

    public Operation getModel() {
        if (this.model == null && this.modelKey != null) {
            this.model = OpManager.getInstance().getInstance(this.modelKey);
            if (this.model == null) {
                LOGGER.severe("Failed to create node: " + this.modelKey);
            }
        }
        return this.model;
    }

    public void setModel(Operation operation) {
        this.model = operation;
    }

    public Icon getSmallIcon() {
        if (this.isModelValid()) {
            return this.getModel().getSmallIcon();
        }
        if (this.smallIcon == null && this.smallIconKey != null) {
            this.smallIcon = OpClass.getSmallIcon(this.smallIconKey);
        }
        return this.smallIcon;
    }

    public Icon getIcon() {
        if (this.isModelValid()) {
            return this.getModel().getIcon();
        }
        if (this.icon == null && this.iconKey != null) {
            this.icon = OpClass.getIcon(this.iconKey);
        }
        return this.icon;
    }

    @Override
    public OpTreeNode getParent() {
        return (OpTreeNode)super.getParent();
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isModel();
    }

    @Override
    public boolean isLeaf() {
        return this.isModel();
    }

    @Override
    public Object getUserObject() {
        return this.getName();
    }

    public OpTreeNode getChildById(String string) {
        if (this.isLeaf() || StringUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            OpTreeNode opTreeNode = (OpTreeNode)this.getChildAt(i);
            String string2 = opTreeNode.getId();
            if (string2 == null || !string2.equals(string)) continue;
            return opTreeNode;
        }
        return null;
    }

    public OpTreeNode copy() {
        return new OpTreeNode(this);
    }

    @Override
    public Iterator<OpTreeNode> iterator() {
        ArrayList<OpTreeNode> arrayList = new ArrayList<OpTreeNode>();
        for (TreeNode treeNode : Collections.list(this.children())) {
            if (!(treeNode instanceof OpTreeNode)) continue;
            arrayList.add((OpTreeNode)treeNode);
        }
        return arrayList.iterator();
    }
}

