/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.ui;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.base.DevelSettings;
import com.ef_prime.rflow.node.ui.OpPagesView;
import com.ef_prime.rflow.node.ui.OpTabPagesView;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.RActions;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.item.Item;
import com.ef_prime.rflow.ui.common.view.PagesView;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import org.apache.commons.lang3.StringUtils;

public class OpWizardAction
extends LoggableAction {
    private Operation selectedModel;
    private Item item;

    public OpWizardAction(Operation operation, Item item) {
        this.selectedModel = operation.copy();
        this.item = item;
        this.putValue("Name", operation.getTitle());
        this.putValue("SwingLargeIconKey", operation.getIcon());
        String[] stringArray = R.client().getInstalledPackages();
        if (stringArray.length > 0) {
            RPackage[] rPackageArray = RPackage.getRPackages(operation);
            List<String> list = RPackage.getMissingPackages(stringArray, rPackageArray);
            if (!list.isEmpty()) {
                this.putValue("SmallIcon", Icons.getOverlaidIcon(operation.getSmallIcon(), "16/error.png", 10));
                this.putValue("ShortDescription", Messages.getString("Error.missing_r_package") + ": " + StringUtils.join(list, (String)", "));
            } else {
                this.putValue("SmallIcon", operation.getSmallIcon());
            }
        } else {
            this.putValue("SmallIcon", operation.getSmallIcon());
        }
    }

    public Operation getModelForTransfer() {
        if (this.selectedModel == null) {
            return null;
        }
        Operation operation = this.selectedModel.copy();
        operation.initialize(false);
        if (this.item != null) {
            operation.importTransferable(this.item);
        }
        return operation;
    }

    @Override
    public void action(ActionEvent actionEvent) {
        Object object;
        Operation operation = this.selectedModel.copy();
        RPackage[] rPackageArray = RPackage.getRPackages(operation);
        if (rPackageArray != null && !(object = R.client().getMissingPackages(RPackage.toNames(rPackageArray))).isEmpty()) {
            RActions.getInstance().askInstallMissingPackages(rPackageArray);
            return;
        }
        switch (Rflow.develSettings().getValue(DevelSettings.UINODE_WINDOW)) {
            case "dialog": {
                object = new OpPagesView(operation, this.item);
                JDialog jDialog = ((PagesView)object).createDialog(Rflow.mainFrame(), ((OpPagesView)object).getTitle(), false, new Dimension(700, 700));
                if (this.selectedModel != null && this.selectedModel.getSmallIcon() instanceof ImageIcon) {
                    jDialog.setIconImage(((ImageIcon)this.selectedModel.getSmallIcon()).getImage());
                }
                jDialog.setVisible(true);
                break;
            }
            case "left bottom tab": {
                object = new OpTabPagesView(operation, this.item);
                Rflow.mainView().getDefaultConsolePane().openView((View)object, ViewOpenType.OPEN_NEW, true);
                break;
            }
            default: {
                object = new OpTabPagesView(operation, this.item);
                Rflow.mainView().getDefaultFlowPane().openView((View)object, ViewOpenType.OPEN_NEW, true);
            }
        }
        ((OpPagesView)object).startEditing();
    }
}

