/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.ui;

import com.ef_prime.rflow.core.app.base.App;
import com.ef_prime.rflow.core.app.base.Apps;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.console.BasicCommand;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.base.FileEdit;
import com.ef_prime.rflow.core.base.FileEditFiles;
import com.ef_prime.rflow.core.base.FileEditSupport;
import com.ef_prime.rflow.core.base.FileManager;
import com.ef_prime.rflow.core.common.keyvalue.AutoValueLink;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.UIValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.feature.search.KeySearchResult;
import com.ef_prime.rflow.core.feature.search.SearchContext;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.task.Task;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.node.ui.OpClass;
import com.ef_prime.rflow.node.ui.PreviewFunction;
import com.ef_prime.rflow.ui.app.base.Preview;
import com.ef_prime.rflow.ui.common.item.ItemEvent;
import com.ef_prime.rflow.ui.common.item.ItemManager;
import com.ef_prime.rflow.ui.common.item.ItemName;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public abstract class Operation
extends UIValueMap
implements FileEdit {
    private static final Logger LOGGER = Logger.getLogger(Operation.class.getName());
    private String title;
    protected Icon icon;
    protected Icon smallIcon;
    private FileEditSupport fileSupport = new FileEditSupport(this);

    public Operation() {
        this.title = this.getDefaultTitle();
    }

    protected Operation(Operation operation) {
        super(operation);
        this.title = operation.title;
    }

    @Override
    protected void localize(Map<String, String> map) {
        String string = map.get(this.title);
        if (string != null) {
            this.title = string;
        }
    }

    public String getId() {
        return this.getClass().getName();
    }

    public Version getVersion() {
        return Version.ZERO;
    }

    @Override
    public boolean isValidationEnabled() {
        return true;
    }

    public String getTitle() {
        return this.title;
    }

    protected abstract String getDefaultTitle();

    public String getSummary() {
        return this.getTitle();
    }

    public String getDescription() {
        return null;
    }

    public void initialize(boolean bl) {
    }

    public abstract void run(Task var1, boolean var2) throws Exception;

    public void runSavedCommand(Task task, String string) throws Exception {
    }

    public ItemManager getItemManager() {
        return null;
    }

    public ItemEvent getItemEvent() {
        return null;
    }

    public ItemName[] getNewItemNames() {
        return null;
    }

    public ItemName getPrimaryItem() {
        ItemName[] itemNameArray = this.getNewItemNames();
        if (itemNameArray == null) {
            return null;
        }
        return itemNameArray[itemNameArray.length - 1];
    }

    public List<ItemName> checkOverwrite() {
        return null;
    }

    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        return null;
    }

    public String getDisplayRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        return null;
    }

    public final Command getRCommand(boolean bl, boolean bl2, boolean bl3, PreviewOption previewOption) throws Exception {
        String string = this.getRScript(bl, bl3, previewOption);
        if (string == null) {
            return null;
        }
        String string2 = this.getDisplayRScript(bl, bl3, previewOption);
        BasicCommand basicCommand = new BasicCommand(string, false, string2);
        if (bl) {
            return new BasicCommand(new Command[]{new BasicCommand(R.client().getDebugCommand()), basicCommand});
        }
        return basicCommand;
    }

    public Icon getSmallIcon() {
        if (this.smallIcon == null) {
            this.smallIcon = OpClass.getSmallIcon(this.getSmallIconKey());
        }
        return this.smallIcon;
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = OpClass.getIcon(this.getIconKey());
        }
        return this.icon;
    }

    public String getSmallIconKey() {
        if (this.getOpClass() != null) {
            return this.getOpClass();
        }
        return null;
    }

    public String getIconKey() {
        if (this.getOpClass() != null) {
            return this.getOpClass();
        }
        return null;
    }

    public String getOpClass() {
        return null;
    }

    public boolean canImport(Transferable transferable) {
        return false;
    }

    public boolean isSupported(App app) {
        return false;
    }

    public void importTransferable(Transferable transferable) {
        if (!this.canImport(transferable)) {
            return;
        }
        AutoLinkUpdater autoLinkUpdater = new AutoLinkUpdater();
        this.addEventHandler(autoLinkUpdater);
        try {
            this.importValues(transferable);
        }
        finally {
            this.removeEventHandler(autoLinkUpdater);
        }
    }

    protected void importValues(Transferable transferable) {
    }

    public List<SearchResult> search(SearchContext searchContext) {
        ArrayList<SearchResult> arrayList = new ArrayList<SearchResult>();
        WidgetNode widgetNode = this.getWidgetNode(ViewOptions.builder().setWizard(false).setTab(true).build());
        Iterator<WidgetNode> iterator = widgetNode.treeIterator();
        while (iterator.hasNext()) {
            Key<?> key;
            WidgetNode widgetNode2 = iterator.next();
            if (!(widgetNode2 instanceof KeyWidgetNode) || !this.isSearchable(key = ((KeyWidgetNode)widgetNode2).getKey())) continue;
            key.search(arrayList, searchContext, this.getValue(key), this);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(SearchContext searchContext, String string, SearchResult[] searchResultArray, int n) {
        SearchResult searchResult = searchResultArray[n];
        if (!(searchResult instanceof KeySearchResult)) {
            return false;
        }
        KeySearchResult keySearchResult = (KeySearchResult)searchResult;
        ArrayList<SearchResult> arrayList = new ArrayList<SearchResult>();
        for (SearchResult searchResultArray2 : searchResultArray) {
            KeySearchResult keySearchResult2;
            if (!(searchResultArray2 instanceof KeySearchResult) || !(keySearchResult2 = (KeySearchResult)searchResultArray2).getKey().equals(keySearchResult.getKey())) continue;
            arrayList.add(keySearchResult2.getResult());
        }
        ChangedKeyCollector changedKeyCollector = new ChangedKeyCollector(keySearchResult.getKey());
        int n2 = 0;
        this.addEventHandler(changedKeyCollector);
        try {
            n2 = keySearchResult.getKey().replace(searchContext, string, keySearchResult.getResult(), arrayList, this.getValue(keySearchResult.getKey()), this) ? 1 : 0;
        }
        finally {
            this.removeEventHandler(changedKeyCollector);
        }
        Set<Key<?>> set = changedKeyCollector.getChangedKeys();
        if (!set.isEmpty()) {
            for (SearchResult searchResult2 : searchResultArray) {
                KeySearchResult keySearchResult3;
                if (!(searchResult2 instanceof KeySearchResult) || !set.contains((keySearchResult3 = (KeySearchResult)searchResult2).getKey()) || keySearchResult3.getKey().validateSearchResult(searchContext, keySearchResult3.getResult(), this.getValue(keySearchResult3.getKey()))) continue;
                keySearchResult3.setEnabled(false);
            }
        }
        return n2 != 0;
    }

    public void setPreviewOption(PreviewOption previewOption) {
        for (Key<?> key : this.keySet()) {
            if (!key.isAutoValueLink()) continue;
            this.putValueQuietly(key.getAutoValueLinkKey(), Boolean.FALSE);
        }
        for (Key<?> key : this.keySet()) {
            PreviewFunction<?> previewFunction = key.getPreviewFunction();
            if (previewFunction == null) continue;
            this.putValue(key, previewFunction.apply(this.getValue(key), this, previewOption));
        }
        this.setPreviewValues(previewOption);
    }

    protected void setPreviewValues(PreviewOption previewOption) {
    }

    public WidgetNode getPreviewWidgetNode() {
        return null;
    }

    public void configureForFlow() {
    }

    public boolean supportsPreview() {
        WidgetNode widgetNode = this.getPreviewWidgetNode();
        return widgetNode != null && widgetNode.getProperty(Preview.PREVIEW_RUN) != false;
    }

    public void updateVersion(Version version) {
    }

    public boolean isUpgradable() {
        return false;
    }

    public Operation upgrade() {
        return null;
    }

    protected static ItemName fileItemName(File file) {
        return new ItemName(Apps.FILE.getId(), FileManager.fileToString(file));
    }

    @Override
    public Operation copy() {
        Operation operation;
        try {
            operation = (Operation)this.getClass().newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to copy : default constructor is required.");
        }
        operation.copyValues(this);
        operation.title = this.title;
        operation.i18nMap = this.i18nMap;
        return operation;
    }

    public void load(String string) throws IOException {
        Path path = FileEditFiles.getInstance().getBackupFile(string);
        if (path == null) {
            return;
        }
        this.loadFromXml(path.toFile());
        FileEditFiles.getInstance().updateBackupID(string, this);
        this.setDirty(false);
    }

    @Override
    public void unloadFileEdit(boolean bl) {
        FileEdit.super.unloadFileEdit(bl);
        if (this.isDirtyForBackup()) {
            try {
                FileEditFiles.getInstance().backup(this);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Failed to backup flow file.", iOException);
            }
        }
    }

    @Override
    public String getFileEditName() {
        return this.getTitle();
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public void save(Path path) throws IOException {
        this.saveInternal(path);
        this.setDirty(false);
        FileEditFiles.getInstance().removeBackup(this);
    }

    @Override
    public void saveBackup(Path path) throws IOException {
        this.saveInternal(path);
        this.setDirtyForBackup(false);
    }

    private void saveInternal(Path path) throws IOException {
        this.storeToXml(path.toFile(), "uimodel");
    }

    @Override
    public void clearEdit() {
    }

    @Override
    public FileEditSupport getFileEditSupport() {
        return this.fileSupport;
    }

    @Override
    public boolean noSave() {
        return true;
    }

    private static class AutoLinkUpdater
    implements ValueChangeEventHandler {
        private AutoLinkUpdater() {
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            Key<?>[] keyArray;
            ValueMap valueMap = valueChangeEvent.getValueMap();
            for (Key<?> key : keyArray = valueMap.keys()) {
                AutoValueLink autoValueLink = key.getAutoValueLink();
                if (autoValueLink == null || !valueMap.getValue(key.getAutoValueLinkKey()).booleanValue() || !autoValueLink.isLinked(valueChangeEvent.getKey().getId())) continue;
                valueMap.putAutoValue(key);
            }
        }
    }

    private static class ChangedKeyCollector
    implements ValueChangeEventHandler {
        private Key<?> changedKey;
        private Set<Key<?>> keys = new HashSet(2);

        public ChangedKeyCollector(Key<?> key) {
            this.changedKey = key;
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            if (valueChangeEvent.getKey().equals(this.changedKey)) {
                return;
            }
            this.keys.add(valueChangeEvent.getKey());
        }

        public Set<Key<?>> getChangedKeys() {
            return this.keys;
        }
    }
}

