/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.ui;

import com.ef_prime.rflow.core.app.r.RAddonBuilderModel;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RFileKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.ItemImporter;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.node.PreviewOption;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class RAddonOpData {
    private static final Logger LOGGER = Logger.getLogger(RAddonOpData.class.getName());
    private static final int SCRIPT_NONE = 0;
    private static final int SCRIPT_FUNCTION = 1;
    private static final int SCRIPT_FUNCTION_WITH_DEFINITION = 2;
    private static final int SCRIPT_TEMPLATE = 3;
    private static Map<String, Class<? extends Key<?>>> keyClassMap;
    private static final VelocityEngine VELOCITY;
    private RAddonBuilderModel builderModel;
    private String path;
    private String id;
    private Version version;
    private String clas;
    private String title;
    private String summary;
    private List<Key<?>> keys;
    private boolean previewEnabled;
    private String script;
    private String functionDefinition;
    private int scriptType = 0;
    private RPackage[] rPackages;

    public static RAddonOpData function(RAddonBuilderModel rAddonBuilderModel, String string, String string2, String string3, String string4, List<Key<?>> list, RPackage[] rPackageArray, boolean bl) {
        RAddonOpData rAddonOpData = new RAddonOpData();
        rAddonOpData.version = Version.ZERO;
        rAddonOpData.builderModel = rAddonBuilderModel;
        rAddonOpData.path = string;
        rAddonOpData.id = string;
        rAddonOpData.title = string2;
        rAddonOpData.script = string3;
        rAddonOpData.functionDefinition = RAddonOpData.isFunctionDefinition(string4) ? string4 : null;
        rAddonOpData.scriptType = rAddonOpData.functionDefinition == null ? 1 : 2;
        rAddonOpData.keys = list;
        rAddonOpData.rPackages = rPackageArray;
        rAddonOpData.previewEnabled = bl;
        return rAddonOpData;
    }

    private RAddonOpData() {
    }

    public RAddonOpData(String string, Object object) throws IOException {
        this.path = string;
        Map<Object, Object> map = YamlEx.map(object);
        this.applyLangData(map);
        this.id = YamlEx.string(map.get("id"));
        if (this.id == null || this.id.isEmpty()) {
            throw new IOException("'id' is required");
        }
        try {
            this.version = map.containsKey("version") ? Version.parse(map.get("version").toString()) : Version.ZERO;
        }
        catch (Exception exception) {
            throw new IOException("Invalid version: " + String.valueOf(map.get("version")));
        }
        this.clas = YamlEx.string(map.get("class"));
        this.title = YamlEx.string(map.get("title"));
        this.previewEnabled = YamlEx.bool(map.get("preview"), true);
        Map<Object, Object> map2 = YamlEx.map(map.get("keys"));
        this.keys = RAddonOpData.getKeys(map2);
        this.script = YamlEx.string(map.get("function"));
        if (this.script != null) {
            this.functionDefinition = YamlEx.string(map.get("function-definition"));
            this.scriptType = this.functionDefinition == null ? 1 : 2;
        }
        if (this.script == null) {
            this.script = YamlEx.string(map.get("script"));
            if (this.script != null) {
                this.scriptType = 3;
            }
        }
    }

    private void applyLangData(Map<Object, Object> map) throws IOException {
        Map<Object, Object> map2 = YamlEx.map(map.get("i18n"));
        if (map2 == null) {
            return;
        }
        Map<Object, Object> map3 = YamlEx.map(map2.get(Locale.getDefault().getLanguage()));
        if (map3 == null) {
            return;
        }
        this.overwriteMap(map, map3);
    }

    private void overwriteMap(Map<Object, Object> map, Map<Object, Object> map2) {
        Set<Map.Entry<Object, Object>> set = map2.entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            Object object = entry.getKey();
            Object object2 = entry.getValue();
            if (object2 instanceof Map) {
                Object object3 = map.get(object);
                if (!(object3 instanceof Map)) continue;
                this.overwriteMap((Map)object3, (Map)object2);
                continue;
            }
            map.put(object, object2);
        }
    }

    public static List<Key<?>> getKeys(Map<Object, Object> map) {
        ArrayList arrayList = new ArrayList();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            String string = entry.getKey().toString();
            Map<Object, Object> map2 = YamlEx.map(entry.getValue());
            map2.put("id", string);
            Key<?> key = RAddonOpData.toKey(map2);
            if (key == null) continue;
            arrayList.add(key);
        }
        return arrayList;
    }

    private static Key<?> toKey(Map<Object, Object> map) {
        try {
            String string = (String)YamlEx.typeCheck(String.class, map.get("type"));
            Class<Key<?>> clazz = keyClassMap.get(string);
            Constructor<Key<?>> constructor = clazz.getConstructor(Map.class);
            return constructor.newInstance(map);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to read key: " + String.valueOf(map.get("id")), exception);
            return null;
        }
    }

    private static boolean isFunctionDefinition(String string) {
        return string != null && string.startsWith("function");
    }

    public RAddonBuilderModel getBuilderModel() {
        return this.builderModel;
    }

    public String getPath() {
        return this.path;
    }

    public String getId() {
        return this.id;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getClas() {
        return this.clas;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSummary() {
        return this.summary;
    }

    public List<Key<?>> getKeys() {
        return this.keys;
    }

    public String getFunction() {
        return this.script;
    }

    public String getFunctionDefinition() {
        return this.functionDefinition;
    }

    public RPackage[] getRPackages() {
        return this.rPackages;
    }

    public boolean isPreviewEnabled() {
        return this.previewEnabled;
    }

    public String getScript(ValueMap valueMap, PreviewOption previewOption) {
        switch (this.scriptType) {
            case 1: 
            case 2: {
                String string = null;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Key<?> key : this.getKeys()) {
                    String string2 = key.getId();
                    Object obj = valueMap.getValue(key);
                    if (!(obj instanceof String)) continue;
                    String string3 = (String)obj;
                    if (string2.equals("_output")) {
                        string = string3;
                        continue;
                    }
                    if (string3.isEmpty()) continue;
                    if (string2.startsWith("_empty")) {
                        string2 = "";
                    }
                    arrayList.add(string2);
                    arrayList.add(string3);
                }
                if (this.scriptType == 1) {
                    return RUtility.assignFunction(string, this.script, arrayList);
                }
                String string4 = RUtility.args(arrayList);
                if (string != null && !string.isEmpty()) {
                    return string + " <- (" + this.functionDefinition + ")(" + (String)string4 + ")\n";
                }
                return "(" + this.functionDefinition + ")(" + (String)string4 + ")\n";
            }
            case 3: {
                VelocityContext velocityContext = new VelocityContext();
                for (Key<?> key : this.getKeys()) {
                    velocityContext.put(key.getId(), valueMap.getValue(key));
                }
                StringWriter stringWriter = new StringWriter();
                VELOCITY.evaluate((Context)velocityContext, (Writer)stringWriter, this.getTitle(), this.script);
                stringWriter.flush();
                return stringWriter.toString();
            }
        }
        return this.script;
    }

    public void setValues(ValueMap valueMap, Transferable transferable) {
        for (Key<?> key : this.getKeys()) {
            if (!key.isImporter()) continue;
            List<ItemImporter> list = key.getImporters();
            for (ItemImporter itemImporter : list) {
                if (!itemImporter.canImport(transferable)) continue;
                Object object = itemImporter.importItem(transferable);
                valueMap.putValueQuietly(key, object);
            }
        }
    }

    public Object toYaml() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("id", this.id);
        linkedHashMap.put("title", this.title);
        if (this.version != null) {
            linkedHashMap.put("version", this.version.toString());
        }
        if (this.clas != null && !this.clas.isEmpty()) {
            linkedHashMap.put("class", this.clas);
        }
        linkedHashMap.put("preview", this.previewEnabled);
        if (!this.keys.isEmpty()) {
            LinkedHashMap<String, Object> linkedHashMap2 = new LinkedHashMap<String, Object>();
            for (Key<?> key : this.keys) {
                linkedHashMap2.put(key.getId(), key.toYaml());
            }
            linkedHashMap.put("keys", linkedHashMap2);
        }
        switch (this.scriptType) {
            case 0: {
                break;
            }
            case 1: {
                linkedHashMap.put("function", this.script);
                break;
            }
            case 2: {
                linkedHashMap.put("function", this.script);
                if (this.functionDefinition == null || this.functionDefinition.isEmpty()) break;
                linkedHashMap.put("function-definition", this.functionDefinition);
                break;
            }
            case 3: {
                linkedHashMap.put("script", this.script);
            }
        }
        return linkedHashMap;
    }

    static {
        VELOCITY = new VelocityEngine();
        keyClassMap = new HashMap();
        keyClassMap.put("rstring", RStrKey.class);
        keyClassMap.put("rchoice", RChoiceKey.class);
        keyClassMap.put("rtable", RTableKey.class);
        keyClassMap.put("rfile", RFileKey.class);
        VELOCITY.init();
    }
}

