/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.ui;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.console.BasicCommand;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandUtility;
import com.ef_prime.rflow.core.common.keyvalue.ValueError;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.feature.search.SearchContext;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.feature.search.SearchUtility;
import com.ef_prime.rflow.core.feature.search.TextSearchResult;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.task.Task;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.ui.common.event.ChangeEvent;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.item.ItemEvent;
import com.ef_prime.rflow.ui.common.item.ItemManager;
import com.ef_prime.rflow.ui.common.item.ItemName;
import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.apache.commons.lang3.ArrayUtils;

public class UINodeModel
extends NodeModel
implements ChangeEventHandler {
    private Operation model;
    private Rectangle shape;
    private Operation savedModel;

    public UINodeModel() {
    }

    public UINodeModel(Operation operation) {
        this.init(operation);
    }

    private UINodeModel(UINodeModel uINodeModel) {
        super(uINodeModel);
        this.init(uINodeModel.model.copy());
        this.savedModel = uINodeModel.savedModel;
    }

    private void init(Operation operation) {
        this.model = operation;
        Icon icon = this.getIcon();
        if (icon != null) {
            int n = icon.getIconWidth();
            int n2 = icon.getIconHeight();
            this.shape = new Rectangle(-n / 2, -n2 / 2, n, n2);
        }
    }

    public Operation getModel() {
        return this.model;
    }

    @Override
    public void run(Task task) throws Exception {
        Object[] objectArray;
        if (this.isSavedCommandMode()) {
            this.model.runSavedCommand(task, this.getSavedCommand());
        } else {
            this.model.run(task, !task.getOption().isExcludeDebugScript() && this.isBreakpointEnabled());
        }
        ItemEvent itemEvent = this.model.getItemEvent();
        if (itemEvent != null && (objectArray = this.model.getItemManager()) != null) {
            objectArray.dispatchItemEvent(itemEvent);
        }
        if (!ArrayUtils.isEmpty((Object[])(objectArray = this.model.getNewItemNames()))) {
            for (Object object : objectArray) {
                ((ItemName)object).registerAsNewObject();
            }
        } else {
            ItemManager itemManager = this.model.getItemManager();
            if (itemManager != null) {
                itemManager.dispatchItemEvent(new ItemEvent(itemManager, 1, null));
            }
        }
    }

    @Override
    public String getDefaultTitle() {
        String string = this.model.getSummary();
        return string;
    }

    @Override
    public boolean exportDefaultTitle() {
        return true;
    }

    @Override
    public String getCommandImpl(boolean bl, FlowRunOption flowRunOption) {
        return CommandUtility.getString(this.getRCommand(bl, false, false), false);
    }

    @Override
    public Command getCommandObject(FlowRunOption flowRunOption, boolean bl) {
        if (this.isSavedCommandMode()) {
            return super.getCommandObject(flowRunOption, bl);
        }
        return this.getRCommand(!flowRunOption.isExcludeDebugScript(), flowRunOption.dontSplitCommand(), bl);
    }

    private Command getRCommand(boolean bl, boolean bl2, boolean bl3) {
        Command command = null;
        try {
            command = this.model.getRCommand(bl && this.isBreakpointEnabled(), bl2, bl3, PreviewOption.OFF);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (command == null) {
            command = new BasicCommand("");
        }
        return command;
    }

    @Override
    public Icon getSmallIcon() {
        return this.model.getSmallIcon();
    }

    @Override
    public Icon getIcon() {
        return this.model.getIcon();
    }

    @Override
    public Shape getShape() {
        return this.shape == null ? super.getShape() : this.shape;
    }

    @Override
    public SearchResult[] search(SearchContext searchContext) {
        if (searchContext.isScriptSearch()) {
            List<TextSearchResult> list = SearchUtility.searchRScript(searchContext, this.getCommand(false, null));
            if (list.isEmpty()) {
                return null;
            }
            for (TextSearchResult textSearchResult : list) {
                textSearchResult.setCanReplace(false);
            }
            return list.toArray(new SearchResult[list.size()]);
        }
        List<SearchResult> list = this.model.search(searchContext);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.toArray(new SearchResult[list.size()]);
    }

    @Override
    public boolean replace(SearchContext searchContext, String string, SearchResult[] searchResultArray, int n) {
        if (searchContext.isScriptSearch()) {
            return false;
        }
        return this.model.replace(searchContext, string, searchResultArray, n);
    }

    @Override
    public List<ItemName> getResults() {
        Object[] objectArray = this.getModel().getNewItemNames();
        if (objectArray != null) {
            return Lists.newArrayList((Object[])objectArray);
        }
        return (List)Utility.cast(Collections.EMPTY_LIST);
    }

    @Override
    public ItemName getPrimaryResult() {
        return this.getModel().getPrimaryItem();
    }

    @Override
    public ValueError getValueError() {
        return this.getModel().getValidationContext().getErrorOrNull(4);
    }

    @Override
    public void setNodeMode(NodeModel.NodeMode nodeMode) {
        if (this.getNodeMode() != nodeMode) {
            if (nodeMode == NodeModel.NodeMode.UPDATE || nodeMode == NodeModel.NodeMode.PRESERVED) {
                if (this.savedModel != null) {
                    this.model.removeChangeEventHandler(this);
                    this.model = this.savedModel;
                    this.savedModel = null;
                    this.modelChanged = false;
                }
            } else {
                this.savedModel = this.model.copy();
                this.model.addChangeEventHandler(this);
            }
        }
        super.setNodeMode(nodeMode);
    }

    @Override
    public NodeModel copy() {
        return new UINodeModel(this);
    }

    @Override
    public Object toYamlValue(YamlEx yamlEx) {
        Map map = (Map)Utility.cast(super.toYamlValue(yamlEx));
        map.put("ui", YamlEx.yamlValueWithType(this.model));
        return map;
    }

    @Override
    public void loadYamlValue(YamlEx yamlEx, Object object) {
        Map map = (Map)YamlEx.typeCheck(Map.class, object);
        Object v = map.get("ui");
        try {
            this.init((Operation)YamlEx.instanceInYamlValue(yamlEx, v));
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    @Override
    public void handleChanged(ChangeEvent changeEvent) {
        this.modelChanged = true;
        ValueMap valueMap = (ValueMap)changeEvent.getSource();
        valueMap.removeChangeEventHandler(this);
    }

    @Override
    public List<RPackage> getAutoPackageList() {
        ROperation rOperation;
        RPackage[] rPackageArray;
        if (this.model instanceof ROperation && (rPackageArray = (rOperation = (ROperation)this.model).getRPackages()) != null) {
            return Arrays.asList(rPackageArray);
        }
        return Collections.emptyList();
    }
}

