/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.ui;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.DevelSettings;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.feature.search.KeySearchResult;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.core.node.OpExecutor;
import com.ef_prime.rflow.core.node.UINodeExecutor;
import com.ef_prime.rflow.node.ModelCreationFailedException;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.NodeOptionView;
import com.ef_prime.rflow.node.NodePropertyView;
import com.ef_prime.rflow.node.RequestNodeModelNotifyEvent;
import com.ef_prime.rflow.node.ui.OpRScriptView;
import com.ef_prime.rflow.node.ui.OpView;
import com.ef_prime.rflow.node.ui.OpViewFactory;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.node.ui.UINodeModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.base.Preview;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.event.SimpleEvent;
import com.ef_prime.rflow.ui.common.event.SimpleEventHandler;
import com.ef_prime.rflow.ui.common.keyvalue.SplitPaneWidget;
import com.ef_prime.rflow.ui.common.keyvalue.TabPaneWidget;
import com.ef_prime.rflow.ui.common.keyvalue.Widget;
import com.ef_prime.rflow.ui.common.view.ToolbarSupport;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewTabbedPane;
import com.ef_prime.rflow.ui.flow.FlowNodeView;
import com.ef_prime.rflow.ui.node.AbstractNodeModelController;
import com.ef_prime.rflow.ui.view.NodeUpdateView;
import com.ef_prime.rflow.ui.view.PreviewRunEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.w3c.dom.Element;

public class UINodeModelController
extends AbstractNodeModelController {
    @Override
    public String getModelName() {
        return null;
    }

    @Override
    public Class<? extends NodeModel> getModelClass() {
        return UINodeModel.class;
    }

    @Override
    public NodeModel createNewModel() {
        return null;
    }

    @Override
    public FlowNodeView createView(FlowNode flowNode, boolean bl) {
        return new UINodeView(flowNode, bl);
    }

    @Override
    public Properties getOptionProperties(NodeModel nodeModel) {
        return null;
    }

    @Override
    public NodeModel createModel(Properties properties, Element element, String string, ViewLayout[] viewLayoutArray) throws ModelCreationFailedException {
        throw new ModelCreationFailedException();
    }

    private static class UINodeView
    extends NodeOptionView
    implements ValueChangeEventHandler,
    SimpleEventHandler {
        private View scriptView;
        private PreviewRun previewRunAction;
        private Widget widget;
        private Preview preview;

        public UINodeView(FlowNode flowNode, boolean bl) {
            super(flowNode, bl);
        }

        private Operation getModel() {
            return this.getNodeModel().getModel();
        }

        private UINodeModel getNodeModel() {
            return (UINodeModel)this.getNode().getModel();
        }

        @Override
        protected Component createCenterView() {
            Object object;
            UINodeExecutor uINodeExecutor = null;
            this.preview = null;
            if (this.getNode().getModel().isSavedCommandMode()) {
                return new NodeUpdateView(this.getNode());
            }
            boolean bl = !this.isPreview() && Rflow.develSettings().getValue(DevelSettings.KEY_SHOW_PREVIEW_INSIDE_TAB) != false;
            ValueMap valueMap = null;
            if (bl && ((Optional)(object = this.getFlowModel())).isPresent()) {
                uINodeExecutor = new UINodeExecutor(this.getNode(), this.getModel(), ((FlowModel)((Optional)object).get()).getExecutor());
                valueMap = new ValueMap();
                valueMap.putValue(OpExecutor.PROPERTY_EXECUTOR, uINodeExecutor);
            }
            if (((OpView)(object = OpViewFactory.getInstance().createView(this.getModel(), bl, true, valueMap))).getContent() instanceof Widget) {
                this.widget = (Widget)((OpView)object).getContent();
            }
            this.preview = (Preview)((JComponent)object).getClientProperty("PROPERTY_PREVIEW");
            if (this.preview != null) {
                this.preview.setAutoRefresh(false);
                if (this.preview instanceof View) {
                    View[] viewArray;
                    ViewTabbedPane viewTabbedPane = ((View)((Object)this.preview)).getParentTabbedPane();
                    for (View view2 : viewArray = viewTabbedPane.getViews()) {
                        if (!(view2 instanceof OpRScriptView)) continue;
                        view2.toFront();
                        break;
                    }
                }
            }
            if (uINodeExecutor != null) {
                uINodeExecutor.setFocusResult(true);
            }
            return object;
        }

        @Override
        protected Component createCenterTabbedPane(Component component) {
            if (component instanceof OpView) {
                View[] viewArray;
                OpView opView = (OpView)component;
                Component component2 = opView.getContent();
                if (component2 instanceof SplitPaneWidget && (viewArray = ((SplitPaneWidget)component2).getComponentChildren()).size() > 0) {
                    component2 = viewArray.get(0);
                }
                if (component2 instanceof TabPaneWidget) {
                    ((TabPaneWidget)component2).addView(new NodePropertyView(this.getNode()));
                    for (View view2 : viewArray = ((TabPaneWidget)component2).getViews()) {
                        if (!(view2 instanceof OpRScriptView)) continue;
                        this.scriptView = (OpRScriptView)view2;
                        break;
                    }
                    return component;
                }
            } else if (component instanceof NodeUpdateView) {
                NodeUpdateView nodeUpdateView = (NodeUpdateView)component;
                nodeUpdateView.addView(new NodePropertyView(this.getNode()));
                this.scriptView = nodeUpdateView.getScriptView();
                return component;
            }
            return super.createCenterTabbedPane(component);
        }

        @Override
        protected void configureToolBar(JToolBar jToolBar) {
            Serializable serializable;
            jToolBar.add(this.createToolBarButton(new Run()));
            if (this.getModel().supportsPreview()) {
                this.previewRunAction = new PreviewRun();
                this.previewRunAction.setEnabled(!this.getNodeModel().isDisabled());
                serializable = this.createToolBarButton(this.previewRunAction);
                jToolBar.add((Component)serializable);
                ((JComponent)serializable).setVisible(!this.getNodeModel().isSavedCommandMode());
            }
            if (!this.isPreview()) {
                jToolBar.add(this.createToolBarButton(this.viewActions.get("RUN")));
                jToolBar.add(this.createToolBarButton(this.viewActions.get("RUN_CLEAR")));
            }
            if (this.getNodeModel().isRestorable()) {
                jToolBar.add(Box.createHorizontalGlue());
                serializable = new Restore();
                JButton jButton = this.createToolBarButton((Action)((Object)serializable));
                jToolBar.add(jButton);
                jButton.setVisible(!this.getNodeModel().isSavedCommandMode());
            }
            serializable = this.getCenterView();
            ToolbarSupport.configureToolBar((Component)serializable, jToolBar);
        }

        @Override
        public void startEditing() {
            Component component = this.getCenterView();
            if (component instanceof OpView) {
                ((OpView)component).startEditing();
            }
        }

        @Override
        protected void modelChanged() {
        }

        @Override
        protected void modelHasBeenChanged() {
            boolean bl;
            boolean bl2;
            super.modelHasBeenChanged();
            if (this.previewRunAction != null) {
                this.previewRunAction.setEnabled(!this.getNode().getModel().isDisabled());
            }
            if ((bl2 = this.getCenterView() instanceof NodeUpdateView) ^ (bl = this.getNodeModel().isSavedCommandMode())) {
                this.rebuildView();
                if (this.toolBar != null) {
                    this.toolBar.removeAll();
                    this.configureToolBar(this.toolBar);
                }
            }
        }

        @Override
        public void select(SearchResult searchResult) {
            if (searchResult instanceof KeySearchResult) {
                if (this.widget != null) {
                    this.widget.clearSelection();
                    this.widget.select(searchResult);
                }
            } else if (this.scriptView != null) {
                this.scriptView.toFront();
                this.scriptView.select(searchResult);
            }
        }

        @Override
        public void loadView() {
            super.loadView();
            this.getModel().addEventHandler(this);
            EventManager.getInstance().registerEventHandler(RequestNodeModelNotifyEvent.class, this);
        }

        @Override
        public void unloadView() {
            super.unloadView();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.getModel().removeEventHandler(this);
                }
            });
            EventManager.getInstance().removeEventHandler(RequestNodeModelNotifyEvent.class, this);
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            this.fireModelChanged();
        }

        @Override
        public void onEvent(SimpleEvent simpleEvent) {
            Component component;
            if (simpleEvent.getClass().equals(RequestNodeModelNotifyEvent.class) && (component = this.getCenterView()) instanceof OpView) {
                ((OpView)component).updateImmediately();
            }
        }

        private class Run
        extends LoggableAction {
            public Run() {
                this.putValue("Name", Messages.getString("Action.run_node"));
                this.putValue("SmallIcon", Icons.getIcon("16/resultset_next.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (UINodeView.this.preview != null && UINodeView.this.preview.supportsRunResultView()) {
                    UINodeView.this.preview.run();
                    UINodeView.this.preview.toFront();
                } else {
                    UINodeView.this.viewActions.doAction("RUN_SELECTED");
                }
            }
        }

        private class PreviewRun
        extends LoggableAction {
            public PreviewRun() {
                this.putValue("Name", Messages.getString("Action.preview_run"));
                this.putValue("SmallIcon", Icons.getIcon("16/page_white_magnify.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (UINodeView.this.preview != null) {
                    UINodeView.this.preview.refresh();
                    UINodeView.this.preview.toFront();
                } else {
                    EventManager.getInstance().dispatchEvent(new PreviewRunEvent(UINodeView.this.getModel(), UINodeView.this.getNode()));
                }
            }
        }

        private class Restore
        extends LoggableAction {
            public Restore() {
                this.putValue("Name", Messages.getString("View.NodeUpdate.cancel_update"));
                this.putValue("SmallIcon", Icons.getIcon("16/undo.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                int n;
                FlowNode flowNode = UINodeView.this.getNode();
                if (flowNode.getModel().isModelChangedAfterUpgrade() && (n = JOptionPane.showConfirmDialog(SwingUtilities.windowForComponent((Component)actionEvent.getSource()), Messages.getString("View.NodeUpdate.confirm_cancel"), Messages.getString("Message.confirm"), 0, 3)) != 0) {
                    return;
                }
                flowNode.getModel().setNodeMode(NodeModel.NodeMode.UPDATE);
                FlowNode.fireNodeModelChanged(flowNode);
            }
        }
    }
}

