/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.CompoundValueError;
import com.ef_prime.rflow.core.common.keyvalue.ValueError;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.node.OpExecutor;
import com.ef_prime.rflow.core.task.NodeModelTask;
import com.ef_prime.rflow.core.task.Task;
import com.ef_prime.rflow.core.task.TaskEvent;
import com.ef_prime.rflow.core.task.TaskEventHandler;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.base.Preview;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.UIColor;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public abstract class AbstractPreviewView<E>
extends View
implements Preview,
HierarchyListener,
TaskEventHandler {
    private static final Icon PREVIEW_ICON = Icons.getIcon("16/page_white_magnify.png");
    private static final Icon RESULT_ICON = Icons.getIcon("16/resultset_next.png");
    private static final Icon PREVIEW_ERROR_ICON = Icons.getOverlaidIcon(PREVIEW_ICON, "16/cancel.png");
    private static final Icon RESULT_ERROR_ICON = Icons.getOverlaidIcon(RESULT_ICON, "16/cancel.png");
    protected static final String ACTION_REFRESH = "ACTION_REFRESH";
    private Operation model;
    private PreviewOption previewOption = new PreviewOption(100L);
    protected JToggleButton autoRefresh;
    protected JToolBar toolBar;
    protected ErrorPanel errorPanel;
    private WidgetNode node;
    protected OpExecutor executor;
    private Task resultTask;
    private String errorMessage;

    public AbstractPreviewView(Operation operation, WidgetNode widgetNode) {
        this.model = operation;
        this.node = widgetNode;
        boolean bl = this.isPreviewRunEnabled();
        this.setTitle(bl ? Messages.getString("View.preview") : Messages.getString("View.result"));
        this.setIcon(bl ? PREVIEW_ICON : RESULT_ICON);
        this.setIconToolTip(this.getTitle());
        this.getActionMap().put(ACTION_REFRESH, new RefreshAction());
        this.toolBar = this.createToolBar();
        this.configureToolBar();
        this.errorPanel = new ErrorPanel();
        this.errorPanel.setVisible(false);
        this.addHierarchyListener(this);
        this.executor = (OpExecutor)widgetNode.getRoot().getProperty(OpExecutor.PROPERTY_EXECUTOR);
        if (this.executor != null) {
            this.executor.addTaskEventHandler(this);
        }
    }

    public Operation getModel() {
        return this.model;
    }

    public WidgetNode getWidgetNode() {
        return this.node;
    }

    public OpExecutor getModelExecutor() {
        return this.executor;
    }

    protected boolean isPreviewRunEnabled() {
        return this.getWidgetNode().getProperty(Preview.PREVIEW_RUN);
    }

    public void setErrorMessage(String string) {
        if (!Objects.equals(this.errorMessage, string)) {
            this.errorMessage = string;
            if (this.errorMessage == null) {
                this.errorPanel.setVisible(false);
            } else {
                this.errorPanel.setVisible(true);
                this.errorPanel.setText(string);
            }
            this.revalidate();
            this.repaint();
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    protected void setResultTask(final Task task) {
        this.resultTask = task;
        UIUtility.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean bl = AbstractPreviewView.this.resultTask.isPreview();
                if (bl) {
                    AbstractPreviewView.this.setIcon(AbstractPreviewView.this.resultTask.isError() ? PREVIEW_ERROR_ICON : PREVIEW_ICON);
                } else {
                    AbstractPreviewView.this.setIcon(AbstractPreviewView.this.resultTask.isError() ? RESULT_ERROR_ICON : RESULT_ICON);
                }
                Object object = AbstractPreviewView.this.getResultName(task);
                if (StringUtils.isEmpty((CharSequence)object)) {
                    AbstractPreviewView.this.setTitle(bl ? Messages.getString("View.preview") : Messages.getString("View.result"));
                } else {
                    if (bl) {
                        object = (String)object + " (" + Messages.getString("View.preview") + ")";
                    }
                    AbstractPreviewView.this.setTitle((String)object);
                }
                if (AbstractPreviewView.this.resultTask.isError()) {
                    AbstractPreviewView.this.setErrorMessage(AbstractPreviewView.this.resultTask.getError().getDescription());
                    AbstractPreviewView.this.setIconToolTip(AbstractPreviewView.this.getErrorMessage());
                } else {
                    AbstractPreviewView.this.setErrorMessage(null);
                    AbstractPreviewView.this.setIconToolTip(AbstractPreviewView.this.getTitle());
                }
                AbstractPreviewView.this.updateTab();
            }
        });
        this.repaint();
    }

    protected String getResultName(Task task) {
        return null;
    }

    public Task getResultTask() {
        return this.resultTask;
    }

    protected abstract E createRunIdentifier(PreviewOption var1) throws Exception;

    protected abstract void checkIdentifier(E var1) throws Exception;

    protected abstract void run(E var1, PreviewOption var2) throws Exception;

    protected abstract void doApplyLastRun();

    protected JToolBar createToolBar() {
        return new JToolBar();
    }

    protected void configureToolBar() {
        this.toolBar.setFloatable(false);
        this.toolBar.setBorder(null);
        this.autoRefresh = this.createAutoRefreshButton();
        if (this.getWidgetNode().getProperty(Preview.REFRESH_BUTTON).booleanValue()) {
            this.toolBar.add(this.getActionMap().get(ACTION_REFRESH));
        }
        this.toolBar.add(this.autoRefresh);
        this.toolBar.add(new PreviewSettingsPanel());
    }

    protected void prepareUndo() {
    }

    @Override
    public void taskStateChanged(TaskEvent taskEvent) {
        if (taskEvent.isQueued()) {
            if (!taskEvent.getTask().getPreviewOption().isEnabled()) {
                this.prepareUndo();
            }
            this.setRunning(true);
        } else if (taskEvent.isRunning()) {
            this.setRunning(true);
        } else if (taskEvent.isDone()) {
            if (!taskEvent.getTask().isPreview()) {
                this.runTaskFinished((NodeModelTask)taskEvent.getTask());
            }
            taskEvent.getTask().removeTaskEventHandler(this);
            this.setRunning(false);
            this.setResultTask(taskEvent.getTask());
        }
    }

    private void setRunning(boolean bl) {
        RefreshAction refreshAction = (RefreshAction)this.getActionMap().get(ACTION_REFRESH);
        refreshAction.setRunning(bl);
    }

    protected void runTaskFinished(NodeModelTask nodeModelTask) {
    }

    protected void prepareRun() {
        this.setErrorMessage(null);
    }

    @Override
    public void run() {
        this.prepareRun();
        this.executor.run();
    }

    @Override
    public void refresh() {
        if (this.isPreviewRunEnabled()) {
            super.refresh();
        }
    }

    @Override
    protected Object refreshWork() throws Exception {
        this.run(this.getPreviewOption());
        return null;
    }

    public void run(PreviewOption previewOption) {
        block3: {
            this.prepareRun();
            try {
                E e = this.createRunIdentifier(previewOption);
                if (this.getModel().isValidationEnabled() && this.getModel().getValidationContext().isError() && !this.getModel().getValidationContext().containsNoError()) {
                    List<ValueError> list = this.getModel().getValidationContext().getAllErrors(4);
                    CompoundValueError compoundValueError = new CompoundValueError(null, list);
                    throw new Exception(compoundValueError.getMessage(true, true));
                }
                this.checkIdentifier(e);
                this.run(e, previewOption);
            }
            catch (Exception exception) {
                if (this.executor == null) break block3;
                this.executor.error(previewOption, exception);
            }
        }
    }

    @Override
    public void runInPreview() {
        this.run(PreviewOption.OFF);
    }

    @Override
    public void addChangeEventHandler(ChangeEventHandler changeEventHandler) {
        this.getExecutor().addChangeEventHandler(changeEventHandler);
    }

    @Override
    public void removeChangeEventHandler(ChangeEventHandler changeEventHandler) {
        this.getExecutor().removeChangeEventHandler(changeEventHandler);
    }

    protected PreviewOption getPreviewOption() {
        return this.previewOption;
    }

    protected void previewOptionChanged() {
        if (this.autoRefresh != null && this.autoRefresh.isSelected()) {
            this.refresh();
        }
    }

    protected JToggleButton createAutoRefreshButton() {
        boolean bl = this.node == null ? true : this.node.getProperty(AUTO_REFRESH_DEFAULT);
        BoolKey boolKey = (BoolKey)this.node.getProperty(AUTO_REFRESH_KEY);
        if (boolKey != null) {
            bl = Rflow.settings().getValue(boolKey);
        }
        AutoRefreshAction autoRefreshAction = new AutoRefreshAction(boolKey);
        JToggleButton jToggleButton = new JToggleButton(autoRefreshAction);
        jToggleButton.setSelected(bl);
        jToggleButton.setHideActionText(true);
        jToggleButton.setToolTipText((String)autoRefreshAction.getValue("Name"));
        jToggleButton.setFocusPainted(false);
        jToggleButton.addItemListener(autoRefreshAction);
        return jToggleButton;
    }

    @Override
    public void setAutoRefresh(boolean bl) {
        if (this.autoRefresh != null) {
            this.autoRefresh.setSelected(bl);
        }
    }

    protected boolean supportsPreviewNumber() {
        return true;
    }

    protected boolean wasError() {
        Task task = this.executor.getLastTask();
        return task != null && task.isError();
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        Container container = this;
        while (container.getParent() != null) {
            if (!((container = container.getParent()) instanceof Window)) continue;
            this.removeHierarchyListener(this);
            return;
        }
        if (container instanceof JComponent) {
            ((JComponent)container).putClientProperty("PROPERTY_PREVIEW", this);
        }
    }

    @Override
    protected void refreshFailed(Exception exception) {
    }

    protected class RefreshAction
    extends LoggableAction {
        private boolean running;

        public RefreshAction() {
            this.putValue("SmallIcon", Icons.getIcon("16/update.png"));
            this.putValue("ShortDescription", Messages.getString("Action.refresh"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            if (this.running) {
                Rflow.getInstance().getConsole().stopIfBusy();
            } else {
                AbstractPreviewView.this.refresh();
            }
        }

        public void setRunning(boolean bl) {
            if (this.running == bl) {
                return;
            }
            this.running = bl;
            this.putValue("SmallIcon", Icons.getIcon(bl ? "16/stop.png" : "16/update.png"));
            this.putValue("ShortDescription", bl ? Messages.getString("Action.stop") : Messages.getString("Action.refresh"));
        }
    }

    protected class ErrorPanel
    extends JPanel {
        private boolean closed;
        private JScrollPane scrollPane;
        private JTextArea textArea;
        private JButton toggleButton;

        public ErrorPanel() {
            this.setBackground(UIColor.ERROR_BACKGROUND);
            this.textArea = new JTextArea();
            this.textArea.setBackground(UIColor.ERROR_BACKGROUND);
            this.textArea.putClientProperty("substancelaf.colorizationFactor", 1.0);
            this.textArea.setEditable(false);
            this.textArea.setBorder(new EmptyBorder(0, 4, 0, 4));
            this.textArea.setLineWrap(true);
            this.scrollPane = new JScrollPane(this.textArea);
            this.scrollPane.setBorder(null);
            JToolBar jToolBar = new JToolBar(1);
            jToolBar.setFloatable(false);
            this.toggleButton = jToolBar.add(new ToggleAction());
            this.toggleButton.setFocusable(false);
            this.setLayout(new BorderLayout());
            this.add((Component)this.scrollPane, "Center");
            this.add((Component)jToolBar, "East");
            this.refreshClosedState();
        }

        public void setText(String string) {
            string = string.trim();
            this.textArea.setText(string);
            this.textArea.setCaretPosition(0);
            this.toggleButton.setVisible(this.textArea.getLineCount() > 1);
        }

        private void toggleClosed() {
            this.closed = !this.closed;
            this.refreshClosedState();
        }

        private void refreshClosedState() {
            SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.toggleButton, (ComponentState)ComponentState.ENABLED);
            Icon icon = SubstanceImageCreator.getArrowIcon((int)SubstanceSizeUtils.getComponentFontSize((Component)this.toggleButton), (int)(this.closed ? 1 : 5), (SubstanceColorScheme)substanceColorScheme);
            this.toggleButton.setIcon(icon);
            int n = this.textArea.getFontMetrics(this.textArea.getFont()).getHeight() + this.textArea.getInsets().top + this.textArea.getInsets().bottom + this.scrollPane.getInsets().top + this.scrollPane.getInsets().bottom;
            this.setPreferredSize(this.closed ? new Dimension(100, n) : null);
            AbstractPreviewView.this.revalidate();
            AbstractPreviewView.this.repaint();
        }

        private class ToggleAction
        extends AbstractAction {
            private ToggleAction() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ErrorPanel.this.toggleClosed();
            }
        }
    }

    protected class PreviewSettingsPanel
    extends JPanel
    implements FocusListener,
    ActionListener {
        private JFormattedTextField numberField;

        public PreviewSettingsPanel() {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            this.numberField = new JFormattedTextField(numberFormat);
            this.numberField.setValue(AbstractPreviewView.this.getPreviewOption().getNumber());
            this.numberField.addFocusListener(this);
            this.numberField.addActionListener(this);
            this.numberField.setToolTipText(Messages.getString("Message.size"));
            this.setLayout((LayoutManager)new MigLayout("insets 0, fillx"));
            this.add((Component)this.numberField, "hmin 20, growx");
        }

        private void refreshPreviewOption() {
            Long l = (Long)this.numberField.getValue();
            PreviewOption previewOption = new PreviewOption(l);
            if (!AbstractPreviewView.this.previewOption.equals(previewOption)) {
                AbstractPreviewView.this.previewOption = previewOption;
                AbstractPreviewView.this.previewOptionChanged();
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            SwingUtilities.invokeLater(() -> this.refreshPreviewOption());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.refreshPreviewOption();
        }
    }

    protected class AutoRefreshAction
    extends LoggableAction
    implements ItemListener {
        private BoolKey autoRefreshKey;

        public AutoRefreshAction(BoolKey boolKey) {
            this.autoRefreshKey = boolKey;
            this.putValue("Name", Messages.getString("Action.auto_refresh"));
            this.putValue("SmallIcon", Icons.getIcon("16/link.png"));
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl;
            boolean bl2 = bl = itemEvent.getStateChange() == 1;
            if (bl) {
                AbstractPreviewView.this.refresh();
            }
            if (this.autoRefreshKey != null) {
                Rflow.settings().putValue(this.autoRefreshKey, bl);
            }
        }

        @Override
        public void action(ActionEvent actionEvent) {
        }
    }
}

