/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.base;

import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class RowOrderingTable
extends JTable {
    private static final long serialVersionUID = 9049995506734523073L;
    private int[] rowOrder;

    @Override
    public void setModel(TableModel tableModel) {
        this.clearRowOrder();
        tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                switch (tableModelEvent.getType()) {
                    case -1: 
                    case 1: {
                        RowOrderingTable.this.clearRowOrder();
                    }
                }
            }
        });
        super.setModel(tableModel);
    }

    public void setRowOrder(int[] nArray) {
        this.rowOrder = nArray;
        this.repaint();
    }

    public void clearRowOrder() {
        this.setRowOrder(null);
    }

    public int viewToModelRowIndex(int n) {
        return this.rowOrder == null ? n : this.rowOrder[n];
    }

    public int modelToViewRowIndex(int n) {
        if (this.rowOrder == null) {
            return n;
        }
        for (int i = 0; i < this.rowOrder.length; ++i) {
            if (this.rowOrder[i] != n) continue;
            return i;
        }
        throw new IllegalArgumentException("modelIndex not in map: " + n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return super.getValueAt(this.viewToModelRowIndex(n), n2);
    }
}

