/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.file;

import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.core.app.file.TextFile;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.file.FileView;
import com.ef_prime.rflow.ui.app.file.FileViewMap;
import com.ef_prime.rflow.ui.app.file.TextFileDataTableModel;
import com.ef_prime.rflow.ui.common.table.DataTablePanel;
import com.ef_prime.rflow.ui.view.FileExplorer;
import java.awt.BorderLayout;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataTextView
extends FileView
implements ValueChangeEventHandler {
    private static final Logger LOGGER = Logger.getLogger(DataTextView.class.getName());
    private DataTablePanel table;

    public DataTextView(FileExplorer fileExplorer) {
        super(fileExplorer);
        this.setTitle(Messages.getString("File.TextTable.title"));
    }

    public static boolean isViewable(FileInfo fileInfo) {
        return fileInfo.isText();
    }

    public static String[] extensions() {
        return FileViewMap.EXT_ALL_ARRAY;
    }

    @Override
    protected void loadContent() {
        this.setLayout(new BorderLayout());
        this.table = new DataTablePanel(null);
        this.add(this.table);
    }

    private TextFile getTextFile() {
        return TextFile.get(this.getFile());
    }

    @Override
    protected void refreshWorkDone(Object object) {
        TextFile textFile = this.getTextFile();
        if (textFile != null) {
            textFile.removeEventHandler(this);
            textFile.addEventHandler(this);
            try {
                this.table.setModel(new TextFileDataTableModel(textFile));
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Failed to read text file.", iOException);
            }
        }
    }

    @Override
    public void unloadFileView() {
        TextFile textFile = this.getTextFile();
        if (textFile != null) {
            textFile.removeEventHandler(this);
        }
        if (this.table != null) {
            this.table.dispose();
        }
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        super.viewDidBecomeDisplayable();
        TextFile textFile = this.getTextFile();
        if (textFile != null) {
            textFile.putValue(TextFile.TYPE, "Separated Data");
        }
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        this.refresh();
    }
}

