/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.file;

import com.ef_prime.rflow.core.app.file.ExcelConnection;
import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.ui.app.file.FileView;
import com.ef_prime.rflow.ui.app.file.FileViewMap;
import com.ef_prime.rflow.ui.base.UIColor;
import com.ef_prime.rflow.ui.common.component.DataTable;
import com.ef_prime.rflow.ui.common.component.SwitchPanel;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.FileExplorer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class ExcelView
extends FileView {
    private static final Logger LOGGER = Logger.getLogger(ExcelView.class.getName());
    private static final String[] EXTENSIONS = new String[]{"xlsx", "xls"};
    private SwitchPanel switchPanel;
    private DataTable dataTable;
    private boolean sizeAccepted;

    public ExcelView(FileExplorer fileExplorer) {
        super(fileExplorer);
        this.setTitle("Excel");
    }

    public static boolean isViewable(FileInfo fileInfo) {
        return fileInfo.isExtensionAny(EXTENSIONS) || fileInfo.isContainer(FileInfo.EXCEL);
    }

    public static String[] extensions() {
        return FileViewMap.EXT_ALL_ARRAY;
    }

    @Override
    protected void loadContent() {
        this.switchPanel = new SwitchPanel();
        this.dataTable = new DataTable();
        this.dataTable.getTable().setShowGrid(true);
        this.dataTable.getTable().setGridColor(UIColor.TABLE_GRID);
        this.dataTable.getTable().setDefaultRenderer(Object.class, new CellRenderer());
        this.dataTable.getTable().getTableHeader().setDefaultRenderer(new HeaderRenderer());
        this.dataTable.getRowHeaderTable().setModel(new ExcelRowHeaderTableModel());
        this.dataTable.getRowHeaderTable().getTableHeader().setDefaultRenderer(new HeaderRenderer());
        this.setLayout(new BorderLayout());
        this.add(this.switchPanel);
    }

    @Override
    protected ExcelConnection refreshWork() {
        File file = this.getFile();
        if (!this.sizeAccepted) {
            if (file.length() > 0xA00000L) {
                return null;
            }
            this.sizeAccepted = true;
        }
        try {
            return new ExcelConnection(file);
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.WARNING, "Failed to connect with excel file.", throwable);
            return null;
        }
    }

    @Override
    protected void refreshWorkDone(Object object) {
        ExcelConnection excelConnection = (ExcelConnection)object;
        if (excelConnection == null) {
            String string;
            if (!this.sizeAccepted) {
                File file = this.getFile();
                string = String.format("File size is too large (%s)", ExcelView.readableFileSize(file.length()));
            } else {
                string = "Failed to read file";
            }
            this.switchPanel.set(new JLabel(string));
        } else {
            ExcelSheetTableModel excelSheetTableModel = new ExcelSheetTableModel(excelConnection.getSheet());
            this.dataTable.getTable().setModel(excelSheetTableModel);
            ((ExcelRowHeaderTableModel)this.dataTable.getRowHeaderTable().getModel()).fireTableDataChanged();
            this.switchPanel.set(this.dataTable);
            UIUtility.setPreferredWidth(40, this.dataTable.getRowHeader());
            this.dataTable.revalidate();
        }
    }

    private static String readableFileSize(long l) {
        if (l <= 0L) {
            return "0";
        }
        String[] stringArray = new String[]{"B", "KB", "MB", "GB", "TB"};
        int n = (int)(Math.log10(l) / Math.log10(1024.0));
        String string = new DecimalFormat("#,##0.#").format((double)l / Math.pow(1024.0, n));
        return string + " " + stringArray[n];
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!bl) {
                this.setBackground(Color.WHITE);
            }
            return this;
        }
    }

    private class HeaderRenderer
    extends DefaultTableCellRenderer {
        public HeaderRenderer() {
            this.setHorizontalAlignment(0);
        }
    }

    private class ExcelRowHeaderTableModel
    extends AbstractTableModel {
        private ExcelRowHeaderTableModel() {
        }

        @Override
        public int getRowCount() {
            return ExcelView.this.dataTable.getTable().getRowCount();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int n) {
            return " ";
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return n + 1;
        }
    }

    private class ExcelSheetTableModel
    extends AbstractTableModel {
        private Sheet sheet;
        private int columnCount = 1;

        public ExcelSheetTableModel(Sheet sheet) {
            this.sheet = sheet;
        }

        @Override
        public int getRowCount() {
            return this.sheet.getLastRowNum() + 1;
        }

        @Override
        public int getColumnCount() {
            return this.columnCount;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Cell cell;
            Row row = this.sheet.getRow(n);
            if (row == null) {
                return null;
            }
            short s = row.getLastCellNum();
            if (s > this.columnCount) {
                this.columnCount = s;
                this.fireTableStructureChanged();
            }
            if ((cell = row.getCell(n2)) == null) {
                return null;
            }
            int n3 = cell.getCellType();
            if (n3 == 2) {
                n3 = cell.getCachedFormulaResultType();
            }
            switch (n3) {
                case 3: {
                    return null;
                }
                case 1: {
                    return cell.getStringCellValue();
                }
                case 0: {
                    return cell.getNumericCellValue();
                }
                case 4: {
                    return cell.getBooleanCellValue();
                }
                case 2: {
                    return cell.getCellFormula();
                }
                case 5: {
                    return null;
                }
            }
            return null;
        }
    }
}

