/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.file;

import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.core.app.file.FileInfos;
import com.ef_prime.rflow.core.app.file.TextFile;
import com.ef_prime.rflow.ui.app.file.TextFileEditView;
import com.ef_prime.rflow.ui.app.r.RScriptFileEditView;
import com.ef_prime.rflow.ui.view.FileEditView;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.apache.commons.io.FilenameUtils;

public class FileEditViewFactory {
    private static final Logger LOGGER = Logger.getLogger(FileEditViewFactory.class.getName());
    private static final FileEditViewFactory instance = new FileEditViewFactory();
    private Map<String, Class<? extends FileEditView>> extToViews = new HashMap<String, Class<? extends FileEditView>>();
    private Map<String, Icon> extToIcons = new HashMap<String, Icon>();

    private FileEditViewFactory() {
    }

    public static FileEditViewFactory getInstance() {
        return instance;
    }

    public void add(Class<? extends FileEditView> clazz, String ... stringArray) {
        Object object;
        if (stringArray.length == 0) {
            try {
                object = clazz.getMethod("extensions", new Class[0]);
                stringArray = (String[])((Method)object).invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Failed to get extensions from ResourceView.", exception);
                return;
            }
        }
        for (String string : stringArray) {
            this.extToViews.put(string, clazz);
        }
        try {
            object = clazz.getMethod("icon", new Class[0]);
            Icon icon = (Icon)((Method)object).invoke(null, new Object[0]);
            for (String string : stringArray) {
                this.extToIcons.put(string, icon);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to get a icon from ResourceView.", exception);
        }
    }

    public boolean canEdit(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        String string = FilenameUtils.getExtension((String)file.getName());
        Class<? extends FileEditView> clazz = this.extToViews.get(string);
        if (clazz != null) {
            return true;
        }
        FileInfo fileInfo = FileInfos.getInstance().getFileInfo(file);
        return fileInfo.isText();
    }

    public Class<? extends FileEditView> getViewClass(Path path) {
        String string = FilenameUtils.getExtension((String)path.getFileName().toString());
        Class<? extends FileEditView> clazz = this.extToViews.get(string);
        if (clazz == null) {
            FileInfo fileInfo = FileInfos.getInstance().getFileInfo(path.toFile());
            if (fileInfo.isText()) {
                if (fileInfo.isExtension("R")) {
                    return RScriptFileEditView.class;
                }
                return TextFileEditView.class;
            }
            return null;
        }
        return clazz;
    }

    public FileEditView getView(File file) {
        String string = FilenameUtils.getExtension((String)file.getName());
        Class<? extends FileEditView> clazz = this.extToViews.get(string);
        if (clazz == null) {
            FileInfo fileInfo = FileInfos.getInstance().getFileInfo(file);
            if (fileInfo.isText()) {
                TextFile textFile = TextFile.get(file);
                if (fileInfo.isExtension("R")) {
                    return new RScriptFileEditView(textFile);
                }
                return new TextFileEditView(textFile);
            }
            return null;
        }
        try {
            Constructor<? extends FileEditView> constructor = clazz.getConstructor(File.class);
            return constructor.newInstance(file);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to create ResourceView.", exception);
            return null;
        }
    }

    public Icon getIcon(String string) {
        return this.extToIcons.get(string);
    }
}

