/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.file;

import com.ef_prime.rflow.core.base.FileManager;
import com.ef_prime.rflow.ui.app.file.FileViewer;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.item.AbstractItem;
import com.ef_prime.rflow.ui.common.view.View;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class FileTransferable
extends AbstractItem {
    private final List<File> files;
    private final DataFlavor[] flavors;

    public FileTransferable(Collection<File> collection) {
        this.files = Collections.unmodifiableList(new ArrayList<File>(collection));
        this.flavors = new DataFlavor[]{DataFlavor.javaFileListFlavor};
        this.setName(collection.stream().map(file -> file.getName()).collect(Collectors.joining(", ")));
        if (collection.size() > 0) {
            this.setIcon(Icons.getIcon("16/page_white.png"));
        }
    }

    public List<File> getFiles() {
        return this.files;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(dataFlavor)) {
            return this.files;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return DataFlavor.javaFileListFlavor.equals(dataFlavor);
    }

    @Override
    public View createPreviewView() {
        if (this.files.size() != 1) {
            return null;
        }
        File file = this.files.get(0);
        FileManager.getInstance().removeNewItem(file);
        FileViewer fileViewer = new FileViewer();
        fileViewer.setFile(file);
        fileViewer.setPreview(true);
        return fileViewer;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FileTransferable)) {
            return false;
        }
        FileTransferable fileTransferable = (FileTransferable)object;
        return CollectionUtils.isEqualCollection(this.files, fileTransferable.files);
    }
}

