/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.file;

import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.AlphaIcon;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.FileNode;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.SystemUtils;

public class FileUIUtility {
    private static JFileChooser chooser = new JFileChooser();
    private static final int HIDDEN_ICON_CACHE_SIZE = 10;
    private static LinkedHashMap<Icon, Icon> hiddenIconCache = new LinkedHashMap();

    public static Icon getIcon(File file) {
        return chooser.getIcon(file);
    }

    public static Icon getIcon(FileNode fileNode, Icon icon) {
        File file = fileNode.getFile();
        Icon icon2 = fileNode.getIcon();
        if (icon2 == null && file != null) {
            try {
                icon2 = FileUIUtility.getIcon(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (icon2 == null) {
            icon2 = icon;
        }
        if (file != null && fileNode.isHidden()) {
            Icon icon3 = hiddenIconCache.get(icon2);
            if (icon3 == null && icon2 != null) {
                icon3 = new AlphaIcon(icon2, 0.5f);
                hiddenIconCache.put(icon2, icon3);
                while (hiddenIconCache.size() > 10) {
                    Iterator<Map.Entry<Icon, Icon>> iterator = hiddenIconCache.entrySet().iterator();
                    iterator.next();
                    iterator.remove();
                }
            }
            if (icon3 != null) {
                icon2 = icon3;
            }
        }
        if (!fileNode.isFileValid()) {
            if (icon2 != null) {
                icon2 = Icons.getOverlaidIcon(icon2, "16/cross.png");
            }
        } else if (fileNode.isLinkEntry() && icon2 != null) {
            icon2 = Icons.getOverlaidIcon(icon2, "16/link.png", 10);
        }
        return icon2;
    }

    public static void openPath(String string) {
        FileUIUtility.openPath(WorkingDirectory.toAbsolutePath(new File(string)));
    }

    public static void openPath(File file) {
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        if (file == null) {
            return;
        }
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
            try {
                Desktop.getDesktop().open(file);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                ProcessBuilder processBuilder = new ProcessBuilder("explorer", file.getAbsolutePath());
                processBuilder.start();
            } else if (SystemUtils.IS_OS_MAC) {
                ProcessBuilder processBuilder = new ProcessBuilder("open", file.getAbsolutePath());
                processBuilder.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void openFileWithSystemEditor(Window window, File file) {
        block8: {
            try {
                Object object;
                String string;
                int n;
                long l = 0x6400000L;
                if (file.length() > l && (n = JOptionPane.showConfirmDialog(window, string = Messages.format("Message.confirm_open_large_file", object = new DecimalFormat("0.#").format(file.length() / 1024L / 1024L) + "MB"), Messages.getString("Error.title.warning"), 2, 2)) != 0) {
                    return;
                }
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                    try {
                        Desktop.getDesktop().open(file);
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (SystemUtils.IS_OS_WINDOWS) {
                    object = new ProcessBuilder("cmd", "/c", file.getAbsolutePath());
                    ((ProcessBuilder)object).start();
                    break block8;
                }
                if (SystemUtils.IS_OS_MAC) {
                    object = new ProcessBuilder("open", file.getAbsolutePath());
                    ((ProcessBuilder)object).start();
                    break block8;
                }
                throw new IOException();
            }
            catch (IOException iOException) {
                UIUtility.showErrorDialog((Component)window, Messages.getString("Error.file.run_app"), iOException);
            }
        }
    }

    public static void browse(Window window, String string) {
        block7: {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                try {
                    Desktop.getDesktop().browse(new URL(string).toURI());
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                if (SystemUtils.IS_OS_WINDOWS) {
                    ProcessBuilder processBuilder = new ProcessBuilder("start", string);
                    processBuilder.start();
                    break block7;
                }
                if (SystemUtils.IS_OS_MAC) {
                    ProcessBuilder processBuilder = new ProcessBuilder("open", string);
                    processBuilder.start();
                    break block7;
                }
                throw new IOException();
            }
            catch (Exception exception) {
                UIUtility.showErrorDialog((Component)window, "Failed to open URL: " + string, exception);
            }
        }
    }

    public static String getSyntaxStyle(String string) {
        String string2 = "text/plain";
        switch (string) {
            case "actionscript": {
                string2 = "text/actionscript";
                break;
            }
            case "asm": {
                string2 = "text/asm";
                break;
            }
            case "bbcode": {
                string2 = "text/bbcode";
                break;
            }
            case "c": {
                string2 = "text/c";
                break;
            }
            case "clojure": {
                string2 = "text/clojure";
                break;
            }
            case "cpp": {
                string2 = "text/cpp";
                break;
            }
            case "cs": {
                string2 = "text/cs";
                break;
            }
            case "css": {
                string2 = "text/css";
                break;
            }
            case "d": {
                string2 = "text/d";
                break;
            }
            case "dart": {
                string2 = "text/dart";
                break;
            }
            case "delphi": {
                string2 = "text/delphi";
                break;
            }
            case "dockerfile": {
                string2 = "text/dockerfile";
                break;
            }
            case "dtd": {
                string2 = "text/dtd";
                break;
            }
            case "fortran": {
                string2 = "text/fortran";
                break;
            }
            case "groovy": {
                string2 = "text/groovy";
                break;
            }
            case "hosts": {
                string2 = "text/hosts";
                break;
            }
            case "htaccess": {
                string2 = "text/htaccess";
                break;
            }
            case "html": {
                string2 = "text/html";
                break;
            }
            case "java": {
                string2 = "text/java";
                break;
            }
            case "javascript": {
                string2 = "text/javascript";
                break;
            }
            case "jshintrc": {
                string2 = "text/jshintrc";
                break;
            }
            case "json": {
                string2 = "text/json";
                break;
            }
            case "jsp": {
                string2 = "text/jsp";
                break;
            }
            case "latex": {
                string2 = "text/latex";
                break;
            }
            case "less": {
                string2 = "text/less";
                break;
            }
            case "lisp": {
                string2 = "text/lisp";
                break;
            }
            case "lua": {
                string2 = "text/lua";
                break;
            }
            case "makefile": {
                string2 = "text/makefile";
                break;
            }
            case "mxml": {
                string2 = "text/mxml";
                break;
            }
            case "nsis": {
                string2 = "text/nsis";
                break;
            }
            case "perl": {
                string2 = "text/perl";
                break;
            }
            case "php": {
                string2 = "text/php";
                break;
            }
            case "properties": {
                string2 = "text/properties";
                break;
            }
            case "python": {
                string2 = "text/python";
                break;
            }
            case "ruby": {
                string2 = "text/ruby";
                break;
            }
            case "sas": {
                string2 = "text/sas";
                break;
            }
            case "scala": {
                string2 = "text/scala";
                break;
            }
            case "sql": {
                string2 = "text/sql";
                break;
            }
            case "tcl": {
                string2 = "text/tcl";
                break;
            }
            case "typescript": {
                string2 = "text/typescript";
                break;
            }
            case "shellscript": {
                string2 = "text/unix";
                break;
            }
            case "bat": {
                string2 = "text/bat";
                break;
            }
            case "visualbasic": {
                string2 = "text/vb";
                break;
            }
            case "xml": {
                string2 = "text/xml";
                break;
            }
        }
        return string2;
    }
}

