/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.file;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.ui.app.file.DataTextView;
import com.ef_prime.rflow.ui.app.file.ExcelView;
import com.ef_prime.rflow.ui.app.file.FileView;
import com.ef_prime.rflow.ui.app.file.FolderView;
import com.ef_prime.rflow.ui.app.file.HtmlView;
import com.ef_prime.rflow.ui.app.file.ImageView;
import com.ef_prime.rflow.ui.app.file.PlainTextView;
import com.ef_prime.rflow.ui.app.file.PropertyFileView;
import com.ef_prime.rflow.ui.app.file.RScriptFileView;
import com.ef_prime.rflow.ui.app.file.RandomAccessTextView;
import com.ef_prime.rflow.ui.app.file.TextSettingsView;
import com.ef_prime.rflow.ui.app.file.ZipFolderView;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;

public class FileViewMap {
    private static final Logger LOGGER = Logger.getLogger(FileViewMap.class.getName());
    public static String EXT_ALL = "*";
    public static String[] EXT_ALL_ARRAY = new String[]{EXT_ALL};
    private static final FileViewMap instance = new FileViewMap();
    private ListMultimap<String, Class<? extends FileView>> classToViewMap = ArrayListMultimap.create();
    private ListMultimap<String, Class<? extends FileView>> classToViewMapFilter = ArrayListMultimap.create();
    private List<Class<? extends FileView>> folderViews;

    private FileViewMap() {
        this.add(PlainTextView.class, new String[0]);
        this.add(DataTextView.class, new String[0]);
        if (Rflow.isDevel()) {
            this.add(RandomAccessTextView.class, new String[0]);
        }
        this.add(TextSettingsView.class, new String[0]);
        this.add(ZipFolderView.class, new String[0]);
        this.add(ExcelView.class, new String[0]);
        this.add(ImageView.class, new String[0]);
        this.add(RScriptFileView.class, new String[0]);
        this.add(PropertyFileView.class, new String[0]);
        this.add(HtmlView.class, new String[0]);
        this.hideDefaultTextViews("R");
        this.hideAllTextViews("afp", "rflow");
        this.folderViews = Lists.newArrayList((Object[])new Class[]{FolderView.class, PropertyFileView.class});
    }

    public static FileViewMap getInstance() {
        return instance;
    }

    public void add(String string, Class<? extends FileView> clazz) {
        this.classToViewMap.put((Object)string, clazz);
    }

    public void add(Class<? extends FileView> clazz, String ... stringArray) {
        if (stringArray.length == 0) {
            try {
                Method method = clazz.getMethod("extensions", new Class[0]);
                stringArray = (String[])method.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
                return;
            }
        }
        for (String string : stringArray) {
            this.classToViewMap.put((Object)string, clazz);
        }
    }

    public void hideDefaultTextViews(String ... stringArray) {
        this.hide(PlainTextView.class, stringArray);
        this.hide(DataTextView.class, stringArray);
        this.hide(RandomAccessTextView.class, stringArray);
    }

    public void hideAllTextViews(String ... stringArray) {
        this.hide(PlainTextView.class, stringArray);
        this.hide(DataTextView.class, stringArray);
        this.hide(RandomAccessTextView.class, stringArray);
        this.hide(TextSettingsView.class, stringArray);
    }

    public void hide(Class<? extends FileView> clazz, String ... stringArray) {
        for (String string : stringArray) {
            this.classToViewMapFilter.put((Object)string, clazz);
        }
    }

    public List<Class<? extends FileView>> get(FileInfo fileInfo) {
        File file = fileInfo.getFile();
        if (file == null) {
            return new ArrayList<Class<? extends FileView>>(0);
        }
        if (fileInfo.isDirectory()) {
            return this.folderViews;
        }
        String string = FilenameUtils.getExtension((String)file.getName());
        List list = this.classToViewMap.get((Object)string);
        List list2 = this.classToViewMap.get((Object)EXT_ALL);
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.addAll(list);
        linkedHashSet.addAll(list2);
        List list3 = this.classToViewMapFilter.get((Object)string);
        linkedHashSet.removeAll(list3);
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            if (FileViewMap.isViewable(clazz, fileInfo)) continue;
            iterator.remove();
        }
        return new ArrayList<Class<? extends FileView>>(linkedHashSet);
    }

    private static boolean isViewable(Class<? extends FileView> clazz, FileInfo fileInfo) {
        try {
            Method method = clazz.getMethod("isViewable", FileInfo.class);
            return (Boolean)method.invoke(null, fileInfo);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            return false;
        }
    }

    public boolean hasSupportedView(FileInfo fileInfo) {
        List<Class<? extends FileView>> list = this.get(fileInfo);
        list.remove(PropertyFileView.class);
        list.remove(ExcelView.class);
        return !list.isEmpty();
    }
}

