/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.file;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.core.app.file.FileInfos;
import com.ef_prime.rflow.core.app.file.FileViewerSessionEntry;
import com.ef_prime.rflow.core.app.file.TextFile;
import com.ef_prime.rflow.core.base.FileManager;
import com.ef_prime.rflow.core.base.SessionEntry;
import com.ef_prime.rflow.core.base.SessionEntrySupplier;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.node.ui.OpManager;
import com.ef_prime.rflow.node.ui.OpPopupMenu;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.file.DataTextView;
import com.ef_prime.rflow.ui.app.file.FileEditViewFactory;
import com.ef_prime.rflow.ui.app.file.FileTransferable;
import com.ef_prime.rflow.ui.app.file.FileUIUtility;
import com.ef_prime.rflow.ui.app.file.FileView;
import com.ef_prime.rflow.ui.app.file.FileViewMap;
import com.ef_prime.rflow.ui.app.file.ImageView;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.ViewSwitchPanel;
import com.ef_prime.rflow.ui.common.item.ItemEvent;
import com.ef_prime.rflow.ui.common.item.ItemEventHandler;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewTabbedPane;
import com.ef_prime.rflow.ui.view.BasicFileNode;
import com.ef_prime.rflow.ui.view.FileExplorer;
import com.ef_prime.rflow.ui.view.ViewPosition;
import com.google.common.collect.Lists;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FileViewer
extends View
implements ChangeListener,
ItemEventHandler,
SessionEntrySupplier {
    private static final Logger LOGGER = Logger.getLogger(FileViewer.class.getName());
    private BasicFileNode fileNode;
    private File file;
    private FileInfo fileInfo;
    private List<FileView> views;
    private FileViewContainerActions actions = new FileViewContainerActions();
    private boolean actionButton = true;
    private boolean preview;
    private FileExplorer explorer;

    public FileViewer() {
        this.setClosable(true);
        this.actions.installActions(this, false, 1);
    }

    public void setFileNode(BasicFileNode basicFileNode) {
        this.fileNode = basicFileNode;
        this.setFile(basicFileNode.getFile());
    }

    public BasicFileNode getFileNode() {
        return this.fileNode;
    }

    public void setFile(File file) {
        this.file = file;
        this.setIcon(FileUIUtility.getIcon(file));
        this.refresh();
    }

    public void clear() {
        this.setFile(null);
    }

    public void setActionButton(boolean bl) {
        this.actionButton = bl;
    }

    public boolean isActionButton() {
        return this.actionButton;
    }

    public void setPreview(boolean bl) {
        this.preview = bl;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setExplorer(FileExplorer fileExplorer) {
        this.explorer = fileExplorer;
    }

    public FileExplorer getExplorer() {
        return this.explorer;
    }

    @Override
    public String getTitle() {
        return this.file == null ? "" : this.file.getName();
    }

    @Override
    public Object getKey() {
        return this.file == null ? "" : this.file;
    }

    @Override
    protected Object refreshWork() throws Exception {
        if (this.file == null) {
            return new ArrayList(0);
        }
        FileInfo fileInfo = FileInfos.getInstance().getFileInfo(this.file);
        if (fileInfo == this.fileInfo) {
            return null;
        }
        return FileViewMap.getInstance().get(fileInfo);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void refreshWorkDone(Object object) {
        block17: {
            block16: {
                Object object2;
                FileInfo fileInfo = FileInfos.getInstance().getFileInfo(this.file);
                if (fileInfo == this.fileInfo || object == null) {
                    for (FileView fileView : this.views) {
                        fileView.refresh();
                    }
                    this.actions.setRefreshActivated(false);
                    return;
                }
                this.fileInfo = fileInfo;
                this.unloadViews();
                List list = (List)Utility.cast(object);
                this.views = new ArrayList<FileView>(list.size());
                for (Object object4 : list) {
                    if (!(object4 instanceof Class)) continue;
                    try {
                        Class exception = (Class)Utility.cast(object4);
                        this.views.add((FileView)exception.getConstructor(FileExplorer.class).newInstance(this.getExplorer()));
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.SEVERE, "Failed to create FileView: " + String.valueOf(object4), exception);
                    }
                }
                if (this.views.isEmpty()) {
                    object2 = null;
                } else {
                    Object object3;
                    Object object4;
                    object4 = new ViewSwitchPanel();
                    Object var6_11 = null;
                    if (fileInfo.isText() && ((TextFile)(object3 = TextFile.get(this.file))).getType().equals("Separated Data")) {
                        Class<DataTextView> clazz = DataTextView.class;
                    }
                    for (FileView fileView : this.views) {
                        void var6_13;
                        ((ViewSwitchPanel)object4).addView(fileView);
                        if (!fileView.getClass().equals(var6_13)) continue;
                        ((ViewSwitchPanel)object4).setSelectedIndex(((ViewSwitchPanel)object4).getViewCount() - 1);
                    }
                    if (((ViewSwitchPanel)object4).getSelectedIndex() < 0) {
                        ((ViewSwitchPanel)object4).setSelectedIndex(0);
                    }
                    if (this.isActionButton()) {
                        this.actions.update();
                        ((ViewSwitchPanel)object4).addToToolBar(this.actions.get(FileViewContainerActions.UINodeAction.class));
                        object3 = this.actions.get(FileViewContainerActions.EditAction.class);
                        if (object3.isEnabled()) {
                            ((ViewSwitchPanel)object4).addToToolBar((Action)object3, this.preview);
                        }
                        ((ViewSwitchPanel)object4).addToToolBar(this.actions.get(FileViewContainerActions.Refresh.class));
                    }
                    ((ViewSwitchPanel)object4).addChangeListener(this);
                    object2 = object4;
                }
                for (FileView fileView : this.views) {
                    fileView.loadFileView();
                }
                this.removeAll();
                if (object2 != null) {
                    this.add((Component)object2, "Center");
                }
                this.revalidate();
                this.repaint();
                this.actions.setRefreshActivated(false);
                if (this.fileNode == null) break block16;
                for (FileView fileView : this.views) {
                    fileView.setFileNode(this.fileNode);
                }
                break block17;
            }
            if (this.file == null) break block17;
            for (FileView fileView : this.views) {
                fileView.setFile(this.file);
            }
        }
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        super.viewDidBecomeDisplayable();
        FileManager.getInstance().addItemEventHandler(this);
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        FileManager.getInstance().removeItemEventHandler(this);
        this.unloadViews();
        this.saveSessionEntryToHistory();
    }

    private void unloadViews() {
        if (this.views != null) {
            for (FileView fileView : this.views) {
                fileView.unloadFileView();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        ViewSwitchPanel viewSwitchPanel = (ViewSwitchPanel)changeEvent.getSource();
        FileInfo fileInfo = FileInfos.getInstance().getFileInfo(this.file);
        fileInfo.setLastViewSelection(viewSwitchPanel.getSelectedComponent().getClass());
    }

    @Override
    public void itemChanged(ItemEvent itemEvent) {
        switch (itemEvent.getType()) {
            case 0: {
                boolean bl;
                if (!FileManager.stringToFile(itemEvent.getName()).equals(this.file)) break;
                FileInfo fileInfo = FileInfos.getInstance().getFileInfo(this.file);
                boolean bl2 = bl = fileInfo.isText() || fileInfo.isExtensionAny(ImageView.EXTENSIONS);
                if (bl) {
                    long l = -1L;
                    try {
                        l = Files.size(this.file.toPath());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (l >= 0L && l < 0x500000L) {
                        this.refresh();
                        return;
                    }
                }
                this.actions.setRefreshActivated(true);
            }
        }
    }

    @Override
    public SessionEntry getSessionEntry(boolean bl) {
        if (this.file == null) {
            return null;
        }
        return new FileViewerSessionEntry(Rflow.project(), this.file, this.getViewPosition(), this.isShowing(), this.getIcon());
    }

    private class FileViewContainerActions
    extends Actions {
        public FileViewContainerActions() {
            this.put(new UINodeAction());
            this.put(new EditAction());
            this.put(new Refresh());
        }

        public void update() {
            ((UINodeAction)this.get(UINodeAction.class)).update();
            ((EditAction)this.get(EditAction.class)).update();
        }

        public void setRefreshActivated(boolean bl) {
            ((Refresh)this.get(Refresh.class)).setActivatedIcon(bl);
        }

        private class UINodeAction
        extends LoggableAction {
            private JPopupMenu popupMenu;

            public UINodeAction() {
                this.putValue("Name", Messages.getString("Action.op"));
                this.putValue("SmallIcon", Icons.getIcon("16/toolbar_go.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                Component component = (Component)actionEvent.getSource();
                this.popupMenu.show(component, 0, component.getHeight());
            }

            void update() {
                this.popupMenu = null;
                if (FileViewer.this.file != null) {
                    FileTransferable fileTransferable = new FileTransferable(Lists.newArrayList((Object[])new File[]{FileViewer.this.file}));
                    this.popupMenu = OpPopupMenu.createPopupMenu(OpManager.getInstance().getCurrentTreeNode(), fileTransferable, true);
                }
                if (this.popupMenu == null || this.popupMenu.getComponentCount() == 0) {
                    this.popupMenu = null;
                    this.setEnabled(false);
                } else {
                    this.setEnabled(true);
                }
            }
        }

        private class EditAction
        extends LoggableAction {
            public EditAction() {
                this.putValue("Name", Messages.getString("Action.edit"));
                this.putValue("SmallIcon", Icons.getIcon("16/pencil.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                int n = -1;
                ViewTabbedPane viewTabbedPane = FileViewer.this.getParentTabbedPane();
                if (viewTabbedPane == Rflow.mainView().getDefaultFlowPane()) {
                    n = viewTabbedPane.getIndexOfView(FileViewer.this.getRootView());
                }
                Rflow.actions().openFileEditView(WorkingDirectory.toAbsolutePath(FileViewer.this.file).toPath(), null, true, n, ViewPosition.MAIN);
                FileViewer.this.closeTab();
            }

            void update() {
                this.setEnabled(FileEditViewFactory.getInstance().canEdit(FileViewer.this.file));
            }
        }

        private class Refresh
        extends LoggableAction {
            public Refresh() {
                this.putValue("Name", Messages.getString("Action.refresh"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
                this.setActivatedIcon(false);
            }

            @Override
            public void action(ActionEvent actionEvent) {
                FileViewer.this.refresh();
            }

            private void setActivatedIcon(boolean bl) {
                ImageIcon imageIcon = Icons.getIcon("16/update.png");
                this.putValue("SmallIcon", bl ? imageIcon : UIManager.getLookAndFeel().getDisabledIcon(null, imageIcon));
            }
        }
    }
}

