/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.file;

import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.file.FileUIUtility;
import com.ef_prime.rflow.ui.app.file.FileView;
import com.ef_prime.rflow.ui.app.file.FileViewMap;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.view.FileExplorer;
import com.ef_prime.rflow.ui.view.FileNode;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class FolderView
extends FileView {
    private ListView listView;

    public FolderView(FileExplorer fileExplorer) {
        super(fileExplorer);
        this.setTitle(Messages.getString("File.Folder.title"));
        if (fileExplorer != null) {
            this.listView = new TableListView();
        }
    }

    public static boolean isViewable(FileInfo fileInfo) {
        return fileInfo.isDirectory();
    }

    public static String[] extensions() {
        return FileViewMap.EXT_ALL_ARRAY;
    }

    @Override
    protected void loadContent() {
        if (this.listView != null) {
            this.listView.loadContent();
        }
    }

    @Override
    protected Object refreshWork() throws Exception {
        if (this.listView != null) {
            return this.listView.refreshWork();
        }
        return null;
    }

    @Override
    protected void refreshWorkDone(Object object) {
        if (this.listView != null) {
            this.listView.refreshWorkDone(object);
        }
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        if (this.listView != null) {
            this.listView.viewDidBecomeUndisplayable();
        }
    }

    private class TableListView
    implements ListView {
        private JTable table;
        private int rollOverRow = -1;
        private FilesTableModel emptyModel = new FilesTableModel(new ArrayList<FileNode>(0));

        private TableListView() {
        }

        @Override
        public void loadContent() {
            this.table = new JTable(this.emptyModel);
            this.table.setShowGrid(false);
            this.table.setTableHeader(null);
            this.table.setFocusable(false);
            this.table.setCellSelectionEnabled(false);
            this.table.setDefaultRenderer(Object.class, new RObjectRenderer());
            MouseHandler mouseHandler = new MouseHandler();
            this.table.addMouseListener(mouseHandler);
            this.table.addMouseMotionListener(mouseHandler);
            JScrollPane jScrollPane = new JScrollPane(this.table);
            FolderView.this.add((Component)jScrollPane, "Center");
        }

        @Override
        public Object refreshWork() throws Exception {
            if (FolderView.this.getFileNode().areChildrenReady()) {
                return null;
            }
            return FolderView.this.getFileNode().retrieveChildren();
        }

        @Override
        public void refreshWorkDone(Object object) {
            if (FolderView.this.getFileNode().areChildrenReady()) {
                this.table.setModel(new FilesTableModel(FolderView.this.getFileNode().getChildren()));
            } else if (object == null) {
                this.table.setModel(this.emptyModel);
            } else {
                List list = (List)object;
                FolderView.this.getExplorer().refreshed(FolderView.this.getFileNode(), list);
                this.table.setModel(new FilesTableModel(list));
            }
        }

        @Override
        public void viewDidBecomeUndisplayable() {
            this.setRollOvered(-1);
        }

        private FilesTableModel getTableModel() {
            return (FilesTableModel)this.table.getModel();
        }

        public void setRollOvered(int n) {
            if (this.rollOverRow != n) {
                int n2 = this.rollOverRow;
                this.rollOverRow = n;
                this.getTableModel().fireTableRowsUpdated(n2, n2);
                this.getTableModel().fireTableRowsUpdated(this.rollOverRow, this.rollOverRow);
                if (n < 0) {
                    this.table.setCursor(Cursor.getDefaultCursor());
                } else {
                    this.table.setCursor(Cursor.getPredefinedCursor(12));
                }
            }
        }

        public int getRollOverRow() {
            return this.rollOverRow;
        }

        private class FilesTableModel
        extends AbstractTableModel {
            private List<FileNode> files;

            public FilesTableModel(List<FileNode> list) {
                this.files = list;
            }

            @Override
            public String getColumnName(int n) {
                return "";
            }

            @Override
            public int getRowCount() {
                return this.files.size();
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                switch (n2) {
                    case 0: {
                        return this.files.get(n);
                    }
                }
                return null;
            }
        }

        private class RObjectRenderer
        extends DefaultTableCellRenderer {
            private Icon defaultIcon = Icons.getIcon("16/bullet_black.png");

            private RObjectRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (object != null) {
                    Object object2 = object.toString();
                    if (n == TableListView.this.getRollOverRow()) {
                        object2 = "<u><font color=\"blue\">" + (String)object2 + "</font></u>";
                    }
                    this.setText("<html>" + (String)object2 + "</html>");
                    this.setIcon(FileUIUtility.getIcon((FileNode)object, this.defaultIcon));
                }
                return this;
            }
        }

        private class MouseHandler
        extends MouseAdapter {
            private MouseHandler() {
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = TableListView.this.table.rowAtPoint(mouseEvent.getPoint());
                int n2 = TableListView.this.table.columnAtPoint(mouseEvent.getPoint());
                TableListView.this.setRollOvered(n2 == 0 ? n : -1);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                TableListView.this.setRollOvered(-1);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n = TableListView.this.table.rowAtPoint(mouseEvent.getPoint());
                int n2 = TableListView.this.table.columnAtPoint(mouseEvent.getPoint());
                if (n < 0 || n2 != 0) {
                    return;
                }
                if (FolderView.this.getExplorer() != null) {
                    FileNode fileNode = (FileNode)TableListView.this.getTableModel().getValueAt(n, n2);
                    FolderView.this.getExplorer().select(fileNode);
                }
            }
        }
    }

    private static interface ListView {
        public void loadContent();

        public Object refreshWork() throws Exception;

        public void refreshWorkDone(Object var1);

        public void viewDidBecomeUndisplayable();
    }
}

