/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.file;

import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.ui.app.file.FileView;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.FXBrowserView;
import com.ef_prime.rflow.ui.view.FileExplorer;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.SwingUtilities;
import org.w3c.dom.events.MouseEvent;
import org.w3c.dom.html.HTMLAnchorElement;

public class HtmlView
extends FileView {
    public static final String[] EXTENSIONS = new String[]{"html", "htm"};
    private FXBrowserView browserView;

    public HtmlView(FileExplorer fileExplorer) {
        super(fileExplorer);
        this.setTitle("html");
    }

    public static boolean isViewable(FileInfo fileInfo) {
        return true;
    }

    public static String[] extensions() {
        return EXTENSIONS;
    }

    @Override
    protected void loadContent() {
        this.browserView = new LocalBrowserView();
        this.add((Component)this.browserView, "Center");
    }

    @Override
    protected void refreshWorkDone(Object object) {
        if (this.getFile() != null) {
            try {
                URL uRL;
                URL uRL2 = this.getFile().toURI().toURL();
                try {
                    uRL = new URL(this.browserView.getCurrentUrl());
                }
                catch (Exception exception) {
                    uRL = null;
                }
                if (uRL2.equals(uRL)) {
                    this.browserView.reload();
                } else {
                    this.browserView.load(uRL2.toString());
                }
                return;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.browserView.loadContent("<html></html>");
    }

    private static class LocalBrowserView
    extends FXBrowserView {
        private LocalBrowserView() {
        }

        @Override
        protected FXBrowserView newInstance() {
            return new LocalBrowserView();
        }

        @Override
        protected boolean handleLinkClick(MouseEvent mouseEvent) {
            boolean bl = super.handleLinkClick(mouseEvent);
            if (bl || !(mouseEvent.getCurrentTarget() instanceof HTMLAnchorElement)) {
                return bl;
            }
            HTMLAnchorElement hTMLAnchorElement = (HTMLAnchorElement)((Object)mouseEvent.getCurrentTarget());
            String string = hTMLAnchorElement.getHref();
            String string2 = hTMLAnchorElement.getAttribute("href");
            if (string2 != null && string2.startsWith("http")) {
                SwingUtilities.invokeLater(() -> UIUtility.openUrl(string));
                mouseEvent.preventDefault();
                return true;
            }
            return false;
        }
    }
}

