/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.file;

import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.file.FileView;
import com.ef_prime.rflow.ui.view.FileExplorer;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ImageView
extends FileView {
    private static final Logger LOGGER = Logger.getLogger(ImageView.class.getName());
    public static final String[] EXTENSIONS = new String[]{"png", "jpeg", "jpg"};
    private BufferedImage image;
    private JLabel label;

    public ImageView(FileExplorer fileExplorer) {
        super(fileExplorer);
        this.setTitle(Messages.getString("View.Image.title"));
    }

    public static boolean isViewable(FileInfo fileInfo) {
        return true;
    }

    public static String[] extensions() {
        return EXTENSIONS;
    }

    @Override
    protected void loadContent() {
        this.label = new JLabel();
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.label);
        this.add((Component)new JScrollPane(jPanel), "Center");
    }

    @Override
    protected BufferedImage refreshWork() {
        BufferedImage bufferedImage = null;
        try {
            if (this.getFile() != null) {
                bufferedImage = ImageIO.read(this.getFile());
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Failed to read image file.", iOException);
        }
        return bufferedImage;
    }

    @Override
    protected void refreshWorkDone(Object object) {
        this.image = (BufferedImage)object;
        if (this.image == null) {
            this.label.setIcon(null);
        } else {
            this.label.setIcon(new ImageIcon(this.image));
        }
    }
}

