/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.file;

import com.ef_prime.rflow.ui.app.file.RowIndexHeader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class IndexControl {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RowIndexHeader readRowIndexHeader(File file) throws IOException {
        try (DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));){
            Date date;
            byte[] byArray = new byte[32];
            if (dataInputStream.read(byArray) != byArray.length) {
                throw new IOException("short read");
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            int n = byteBuffer.getInt();
            int n2 = byteBuffer.getInt();
            String string = new String(byArray, 8, 14, "US-ASCII");
            try {
                date = new SimpleDateFormat("yyyyMMddHHmmss").parse(string);
            }
            catch (ParseException parseException) {
                throw new IOException(parseException);
            }
            RowIndexHeader rowIndexHeader = new RowIndexHeader(n, n2, date.getTime());
            return rowIndexHeader;
        }
    }

    public static long getPosOfRow(RandomAccessFile randomAccessFile, RowIndexHeader rowIndexHeader, long l) throws IOException {
        long l2 = rowIndexHeader.getPosOfRow(l);
        randomAccessFile.seek(l2);
        long l3 = IndexControl.toUnsingedIntValue(randomAccessFile.readInt());
        return l3;
    }

    private static long toUnsingedIntValue(int n) {
        if (n < 0) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
            byteBuffer.putInt(0);
            byteBuffer.putInt(n);
            byteBuffer.rewind();
            return byteBuffer.getLong();
        }
        return n;
    }
}

