/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.file;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.app.file.TextFile;
import com.ef_prime.rflow.core.app.r.script.RSyntaxDocumentWithIndentChanged;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.file.FileUIUtility;
import com.ef_prime.rflow.ui.app.file.FileView;
import com.ef_prime.rflow.ui.app.file.FileViewMap;
import com.ef_prime.rflow.ui.common.component.CodingSearchBar;
import com.ef_prime.rflow.ui.common.component.CodingTextArea;
import com.ef_prime.rflow.ui.util.FontSupport;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.FileExplorer;
import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class PlainTextView
extends FileView
implements ValueChangeEventHandler {
    private static final Logger LOGGER = Logger.getLogger(PlainTextView.class.getName());
    private PlainTextArea textPane;
    private List<int[]> crlfRanges = new ArrayList<int[]>();
    private boolean limitExceeded;
    private RTextScrollPane scrollPane;
    private SettingsListener settingsListener;

    public PlainTextView(FileExplorer fileExplorer) {
        super(fileExplorer);
        this.setTitle(Messages.getString("File.Text.title"));
    }

    public static boolean isViewable(FileInfo fileInfo) {
        return fileInfo.isText();
    }

    public static String[] extensions() {
        return FileViewMap.EXT_ALL_ARRAY;
    }

    private TextFile getTextFile() {
        return TextFile.get(this.getFile());
    }

    @Override
    protected void loadContent() {
        this.textPane = new PlainTextArea();
        CodingSearchBar codingSearchBar = new CodingSearchBar(this.textPane);
        this.scrollPane = new RTextScrollPane((RTextArea)this.textPane, true);
        this.add((Component)this.scrollPane);
        this.add((Component)codingSearchBar, "South");
        this.settingsListener = new SettingsListener();
        Rflow.settings().addEventHandler(this.settingsListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object refreshWork() {
        File file = this.getFile();
        if (file == null) {
            return null;
        }
        TextFile textFile = this.getTextFile();
        if (textFile != null) {
            textFile.removeEventHandler(this);
            textFile.addEventHandler(this);
        }
        Charset charset = textFile == null ? Charset.defaultCharset() : textFile.getEncoding();
        try {
            char c;
            int n;
            StringBuilder stringBuilder;
            block22: {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(FileUtility.createInputStream(file), charset));
                stringBuilder = new StringBuilder();
                char[] cArray = new char[1024];
                int n2 = 1024;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                boolean bl = false;
                this.crlfRanges.clear();
                while ((n4 = bufferedReader.read(cArray)) > -1) {
                    for (n = 0; n < n4; ++n) {
                        int[] nArray;
                        c = cArray[n];
                        if (c == '\n') {
                            if (bl) {
                                int[] nArray2 = nArray = this.crlfRanges.isEmpty() ? null : this.crlfRanges.get(this.crlfRanges.size() - 1);
                                if (nArray != null && nArray[1] + true == n5) {
                                    nArray[1] = n5;
                                } else {
                                    this.crlfRanges.add(new int[]{n5, n5});
                                }
                            }
                            ++n5;
                            bl = false;
                            continue;
                        }
                        if (c == '\r') {
                            bl = true;
                            continue;
                        }
                        if (c == '\u0000') {
                            nArray = null;
                            return nArray;
                        }
                        bl = false;
                    }
                    stringBuilder.append(cArray, 0, n4);
                    boolean bl2 = this.limitExceeded = ++n3 >= n2;
                    if (!this.limitExceeded) continue;
                }
                if (this.limitExceeded) {
                    break block22;
                } else {
                    String string = stringBuilder.toString();
                    return string;
                }
                finally {
                    bufferedReader.close();
                }
            }
            for (n = stringBuilder.length() - 1; n >= 0 && (c = stringBuilder.charAt(n)) != '\n'; --n) {
            }
            String string = stringBuilder.substring(0, n + 1) + this.getLimitExceededMessage();
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    protected void refreshWorkDone(Object object) {
        File file = this.getFile();
        if (file == null) {
            return;
        }
        if (object == null) {
            object = "";
        }
        int n = this.scrollPane.getVerticalScrollBar().getValue();
        this.textPane.setStopCaretScroll(true);
        this.textPane.setText((String)object);
        this.textPane.setCrlfRanges(this.crlfRanges);
        this.textPane.limit = this.limitExceeded;
        this.scrollPane.getVerticalScrollBar().setValue(n);
        SwingUtilities.invokeLater(() -> this.textPane.setStopCaretScroll(false));
        TextFile textFile = this.getTextFile();
        if (textFile != null) {
            this.textPane.setSyntaxEditingStyle(FileUIUtility.getSyntaxStyle(textFile.getValue(TextFile.SYNTAX)));
        } else {
            this.textPane.setSyntaxEditingStyle("text/plain");
        }
        this.textPane.setWhitespacesVisible(textFile.getValue(TextFile.WHITESPACE), "\n");
    }

    @Override
    public void unloadFileView() {
        TextFile textFile = this.getTextFile();
        if (textFile != null) {
            textFile.removeEventHandler(this);
        }
        if (this.settingsListener != null) {
            Rflow.settings().removeEventHandler(this.settingsListener);
        }
    }

    @Override
    protected void fileChanged() {
        TextFile textFile = this.getTextFile();
        if (textFile != null) {
            textFile.putValue(TextFile.WHITESPACE, Rflow.settings().getValue(Settings.EDITOR_WHITESPACES));
        }
        super.fileChanged();
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        super.viewDidBecomeDisplayable();
        TextFile textFile = this.getTextFile();
        if (textFile != null) {
            textFile.putValue(TextFile.TYPE, "Plain Text");
        }
    }

    private String getLimitExceededMessage() {
        return "(truncated)";
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        TextFile textFile;
        if (TextFile.WHITESPACE.equals(valueChangeEvent.getKey()) && (textFile = this.getTextFile()) != null) {
            Rflow.settings().putValue(Settings.EDITOR_WHITESPACES, this.getTextFile().getValue(TextFile.WHITESPACE));
        }
        this.refresh();
    }

    private class PlainTextArea
    extends CodingTextArea {
        private boolean limit;

        public PlainTextArea() {
            SyntaxScheme syntaxScheme = new SyntaxScheme(true);
            syntaxScheme.setStyle(40, new Style(Color.GRAY));
            this.setSyntaxScheme(syntaxScheme);
            this.setHighlightCurrentLine(false);
            this.setHighlightCurrentLineOnFocus(true);
            this.setLineWrap(false);
            this.setFont(FontSupport.getCodeFont());
            this.setEditable(false);
            this.setUneditableBackgroundColor();
        }

        protected JPopupMenu createPopupMenu() {
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem(this.getActionMap().get("copy-to-clipboard"));
            jMenuItem.setText(Messages.getString("Action.copy"));
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, UIUtility.MENU_KEY_MASK));
            JMenuItem jMenuItem2 = new JMenuItem(this.getActionMap().get("select-all"));
            jMenuItem2.setText(Messages.getString("Action.select_all"));
            jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(65, UIUtility.MENU_KEY_MASK));
            jPopupMenu.add(jMenuItem);
            jPopupMenu.add(jMenuItem2);
            return jPopupMenu;
        }

        protected Document createDefaultModel() {
            return new RSyntaxDocumentWithIndentChanged("text/plain"){
                private TokenImpl messageToken;
                {
                    this.messageToken = new TokenImpl();
                }

                public Token processGetTokenListForLine(int n) {
                    if (PlainTextArea.this.limit && n == this.getDefaultRootElement().getElementCount() - 1) {
                        Element element = this.getDefaultRootElement().getElement(n);
                        int n2 = element.getStartOffset();
                        String string = PlainTextView.this.getLimitExceededMessage();
                        int n3 = element.getEndOffset() - string.length() - 1;
                        if (n3 - n2 < 0) {
                            this.messageToken.set(string.toCharArray(), 0, string.length() - 1, n2, 40);
                            return this.messageToken;
                        }
                        try {
                            this.getText(n2, n3 - n2, this.s);
                        }
                        catch (BadLocationException badLocationException) {
                            LOGGER.log(Level.WARNING, "Failed to retrieve text.", badLocationException);
                            return null;
                        }
                        int n4 = n == 0 ? 0 : this.getLastTokenTypeOnLine(n - 1);
                        this.messageToken.set(string.toCharArray(), 0, string.length() - 1, n3, 40);
                        Token token = this.tokenMaker.getTokenList(this.s, n4, n2);
                        Token token2 = token.getLastPaintableToken();
                        if (token2 == null) {
                            return this.messageToken;
                        }
                        token2.setNextToken((Token)this.messageToken);
                        return token;
                    }
                    return super.processGetTokenListForLine(n);
                }
            };
        }
    }

    private class SettingsListener
    implements ValueChangeEventHandler {
        private SettingsListener() {
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            if ((Settings.CODE_FONT_FAMILY.equals(valueChangeEvent.getKey()) || Settings.CODE_FONT_SIZE.equals(valueChangeEvent.getKey())) && PlainTextView.this.textPane != null) {
                PlainTextView.this.textPane.setFont(FontSupport.getCodeFont());
            }
        }
    }
}

