/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.file;

import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.file.FileView;
import com.ef_prime.rflow.ui.app.file.FileViewMap;
import com.ef_prime.rflow.ui.common.keyvalue.Widget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.view.FileExplorer;
import java.awt.Component;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import org.apache.commons.io.FileUtils;

public class PropertyFileView
extends FileView {
    private FileProperty fileProperty;
    private Widget widget;

    public static boolean isViewable(FileInfo fileInfo) {
        return fileInfo.getContainer() == null;
    }

    public static String[] extensions() {
        return FileViewMap.EXT_ALL_ARRAY;
    }

    public PropertyFileView(FileExplorer fileExplorer) {
        super(fileExplorer);
        this.setTitle(Messages.getString("File.Property.title"));
    }

    @Override
    protected void loadContent() {
        this.fileProperty = new FileProperty();
        this.widget = (Widget)WidgetFactory.getInstance().create(this.fileProperty);
    }

    @Override
    protected void refreshWorkDone(Object object) {
        File file;
        if (this.widget.getParent() == null) {
            this.add((Component)this.widget, "Center");
        }
        if ((file = this.getFile()) == null) {
            this.fileProperty.clear();
        } else {
            this.fileProperty.set(file);
        }
        this.widget.updateWidgetValue();
    }

    private static class FileProperty
    extends ValueMap {
        private static final BoolKey DIRECTORY = ((BoolKey.Builder)BoolKey.builder("dir", "Directory").setHidden(true)).build();
        private static final StrKey NAME = ((StrKey.Builder)StrKey.builder("name", Messages.getString("File.Property.name")).setFixed(true)).build();
        private static final StrKey PATH = ((StrKey.Builder)StrKey.builder("path", Messages.getString("File.Property.path")).setFixed(true)).build();
        private static final StrKey SIZE = ((StrKey.Builder)((StrKey.Builder)StrKey.builder("size", Messages.getString("File.Property.size")).addInvisibleKeyLink(DIRECTORY, true)).setFixed(true)).build();
        private static final StrKey LAST_MODIFIED = ((StrKey.Builder)StrKey.builder("last_modified", Messages.getString("File.Property.last_modified")).setFixed(true)).build();

        public FileProperty() {
            this.registerKeys(NAME, PATH, SIZE, LAST_MODIFIED, DIRECTORY);
        }

        public void clear() {
            this.putValue(DIRECTORY, Boolean.FALSE);
            this.putValue(NAME, "");
            this.putValue(PATH, "");
            this.putValue(SIZE, "");
            this.putValue(LAST_MODIFIED, "");
        }

        public void set(File file) {
            boolean bl = file.isDirectory();
            String string = FileUtils.byteCountToDisplaySize((long)(bl ? 0L : file.length()));
            String string2 = DateFormat.getDateTimeInstance().format(new Date(file.lastModified()));
            this.putValue(DIRECTORY, bl);
            this.putValue(NAME, file.getName());
            this.putValue(PATH, file.getParent());
            this.putValue(SIZE, string);
            this.putValue(LAST_MODIFIED, string2);
        }
    }
}

