/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.file;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.core.app.file.TextFile;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.file.FileView;
import com.ef_prime.rflow.ui.app.r.script.RCodingTextAreaEx;
import com.ef_prime.rflow.ui.app.r.script.RScriptUtility;
import com.ef_prime.rflow.ui.app.r.script.SimpleCodingScrollPane;
import com.ef_prime.rflow.ui.common.component.CodingSearchBar;
import com.ef_prime.rflow.ui.view.FileExplorer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.io.FileUtils;
import org.fife.ui.rsyntaxtextarea.ErrorStrip;
import org.fife.ui.rtextarea.RTextArea;

public class RScriptFileView
extends FileView
implements ValueChangeEventHandler,
DocumentListener {
    private boolean dirty;
    private RCodingTextAreaEx textArea;
    private SimpleCodingScrollPane scrollPane;
    private Charset encoding;
    private List<int[]> crlfRanges = new ArrayList<int[]>();

    public RScriptFileView(FileExplorer fileExplorer) {
        super(fileExplorer);
    }

    public static boolean isViewable(FileInfo fileInfo) {
        return true;
    }

    public static String[] extensions() {
        return new String[]{"R"};
    }

    public void setFileAndEncoding(File file, Charset charset) {
        boolean bl;
        boolean bl2 = bl = !Objects.equals(this.getFile(), file);
        if (!Objects.equals(this.encoding, charset)) {
            this.encoding = charset;
            if (!bl) {
                this.fileChanged();
            }
        }
        if (bl) {
            this.setFile(file);
        }
    }

    private TextFile getTextFile() {
        return TextFile.get(this.getFile());
    }

    public RCodingTextAreaEx getTextArea() {
        if (!this.isContentLoaded()) {
            this.doLoadContent();
        }
        return this.textArea;
    }

    @Override
    protected void loadContent() {
        this.textArea = new RCodingTextAreaEx();
        this.textArea.startAutoCompletionNotifier();
        this.textArea.setCodeFoldingEnabled(true);
        this.textArea.getDocument().addDocumentListener((DocumentListener)this);
        this.textArea.setHighlightCurrentLine(false);
        this.textArea.setHighlightCurrentLineOnFocus(true);
        this.textArea.setEditable(false);
        this.textArea.setUneditableBackgroundColor();
        this.scrollPane = new SimpleCodingScrollPane((RTextArea)this.textArea);
        CodingSearchBar codingSearchBar = new CodingSearchBar(this.textArea);
        ErrorStrip errorStrip = RScriptUtility.createErrorStrip(this.textArea);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)((Object)this.scrollPane), "Center");
        jPanel.add((Component)codingSearchBar, "South");
        jPanel.add((Component)errorStrip, "East");
        this.add(jPanel);
    }

    @Override
    public String getTitle() {
        return Messages.getString("R.Script.title");
    }

    @Override
    protected String refreshWork() {
        Charset charset;
        File file = this.getFile();
        if (file == null) {
            return null;
        }
        TextFile textFile = this.getTextFile();
        if (textFile != null) {
            textFile.removeEventHandler(this);
            textFile.addEventHandler(this);
        }
        if ((charset = this.encoding) == null) {
            charset = textFile == null ? Charset.defaultCharset() : textFile.getEncoding();
        }
        try {
            this.crlfRanges.clear();
            String string = FileUtils.readFileToString((File)file, (String)charset.name());
            int n = 0;
            boolean bl = false;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\n') {
                    if (bl) {
                        int[] nArray;
                        int[] nArray2 = nArray = this.crlfRanges.isEmpty() ? null : this.crlfRanges.get(this.crlfRanges.size() - 1);
                        if (nArray != null && nArray[1] + true == n) {
                            nArray[1] = n;
                        } else {
                            this.crlfRanges.add(new int[]{n, n});
                        }
                    }
                    ++n;
                    bl = false;
                    continue;
                }
                if (c == '\r') {
                    bl = true;
                    continue;
                }
                if (c == '\u0000') {
                    return null;
                }
                bl = false;
            }
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    protected void refreshWorkDone(Object object) {
        if (object == null) {
            object = "";
        }
        int n = this.scrollPane.getVerticalScrollBar().getValue();
        this.textArea.setStopCaretScroll(true);
        this.textArea.setText((String)object);
        this.textArea.setCrlfRanges(this.crlfRanges);
        this.textArea.discardAllEdits();
        this.dirty = false;
        this.scrollPane.getVerticalScrollBar().setValue(n);
        SwingUtilities.invokeLater(() -> this.textArea.setStopCaretScroll(false));
        this.refreshWhitespaceVisibility();
    }

    @Override
    public void unloadFileView() {
        TextFile textFile = this.getTextFile();
        if (textFile != null) {
            textFile.removeEventHandler(this);
        }
    }

    private void refreshWhitespaceVisibility() {
        TextFile textFile = this.getTextFile();
        if (textFile != null) {
            this.textArea.setWhitespacesVisible(textFile.getValue(TextFile.WHITESPACE), textFile.getNewLine());
        }
    }

    @Override
    protected void fileChanged() {
        TextFile textFile = this.getTextFile();
        if (textFile != null) {
            textFile.putValue(TextFile.WHITESPACE, Rflow.settings().getValue(Settings.R_EDITOR_WHITESPACES));
        }
        super.fileChanged();
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        if (TextFile.WHITESPACE.equals(valueChangeEvent.getKey())) {
            this.refreshWhitespaceVisibility();
            TextFile textFile = this.getTextFile();
            if (textFile != null) {
                Rflow.settings().putValue(Settings.R_EDITOR_WHITESPACES, this.getTextFile().getValue(TextFile.WHITESPACE));
            }
        }
        this.refresh();
    }

    private void documentChanged() {
        if (!this.dirty) {
            this.dirty = true;
            this.updateTab();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.documentChanged();
    }
}

