/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.file;

import com.ef_prime.rflow.core.app.file.TextFile;
import com.ef_prime.rflow.core.app.file.TextReader;
import com.ef_prime.rflow.ui.app.file.IndexControl;
import com.ef_prime.rflow.ui.app.file.RowIndexHeader;
import com.ef_prime.rflow.ui.common.component.ShowInvisibleTextRenderer;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class RandomAccessTable
extends JPanel {
    private RATableModel model = new RATableModel();
    private JTable table = new JTable(this.model){

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            TableCellRenderer tableCellRenderer;
            Component component;
            String string = null;
            Point point = mouseEvent.getPoint();
            int n = this.columnAtPoint(point);
            int n2 = this.rowAtPoint(point);
            if (n != -1 && n2 != -1 && (component = this.prepareRenderer(tableCellRenderer = this.getCellRenderer(n2, n), n2, n)) instanceof JComponent) {
                Rectangle rectangle = this.getCellRect(n2, n, false);
                if (rectangle.width >= component.getPreferredSize().width) {
                    return null;
                }
                point.translate(-rectangle.x, -rectangle.y);
                MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 0);
                string = ((JComponent)component).getToolTipText(mouseEvent2);
            }
            if (string == null) {
                string = this.getToolTipText();
            }
            return string;
        }
    };
    private JScrollPane scrollPane;
    private JSlider outputSlider;
    TextFile outputData;
    private RandomAccessFile outputRandFile;
    private long outputFileSize;
    private long outputReqPos = -1L;
    private long outputLastPos = -1L;
    private RandomAccessFile outputIndexFile;
    private RowIndexHeader outputIndexHeader;

    public RandomAccessTable() {
        super(new BorderLayout());
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new ShowInvisibleTextRenderer(true)));
        this.table.setAutoResizeMode(0);
        this.table.setCellSelectionEnabled(true);
        JTableHeader jTableHeader = new JTableHeader(this.table.getColumnModel()){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = null;
                Point point = mouseEvent.getPoint();
                int n = this.columnAtPoint(point);
                if (n != -1) {
                    TableColumn tableColumn = this.table.getColumnModel().getColumn(n);
                    TableCellRenderer tableCellRenderer = this.getDefaultRenderer();
                    Component component = tableCellRenderer.getTableCellRendererComponent(this.table, tableColumn.getHeaderValue(), false, false, 0, n);
                    if (component instanceof JComponent) {
                        Rectangle rectangle = this.getHeaderRect(n);
                        if (rectangle.width >= component.getPreferredSize().width) {
                            return null;
                        }
                        string = tableColumn.getHeaderValue().toString();
                    }
                }
                if (string == null) {
                    string = this.getToolTipText();
                }
                return string;
            }
        };
        this.table.setTableHeader(jTableHeader);
        this.table.getTableHeader().setReorderingAllowed(false);
        UIUtility.setAutoResizeSupport(this.table);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.outputSlider = new JSlider(1);
        this.outputSlider.setMinimum(0);
        this.outputSlider.setInverted(true);
        this.outputSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                RandomAccessTable.this.outputSliderStateChanged(changeEvent);
            }
        });
        this.add(this.scrollPane);
        this.add((Component)this.outputSlider, "East");
        for (MouseWheelListener mouseWheelListener : this.scrollPane.getMouseWheelListeners()) {
            this.scrollPane.removeMouseWheelListener(mouseWheelListener);
        }
        this.addMouseWheelListener(new MouseHandler());
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                try {
                    RandomAccessTable.this.updateTable();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
    }

    public JTable getTable() {
        return this.table;
    }

    public synchronized TextFile getOutputData() {
        return this.outputData;
    }

    public synchronized void clear(boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            this.model.clear();
        }
        if (bl3) {
            try {
                if (this.outputRandFile != null) {
                    this.outputRandFile.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.outputRandFile = null;
            this.outputFileSize = 1L;
            this.outputData = null;
            this.outputReqPos = -1L;
            this.outputLastPos = -1L;
            try {
                if (this.outputIndexFile != null) {
                    this.outputIndexFile.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.outputIndexFile = null;
            this.outputIndexHeader = null;
        }
    }

    public synchronized void clearOutFile() {
        try {
            if (this.outputRandFile != null) {
                this.outputRandFile.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.outputRandFile = null;
    }

    public synchronized void setOutputFile(TextFile textFile) {
        try {
            this.clear(false, false, true);
            this.outputData = textFile;
            this.outputRandFile = new RandomAccessFile(this.outputData.getFile(), "r");
            this.outputFileSize = this.outputRandFile.length();
            if (textFile.isColumnNames()) {
                this.model.setColumns(textFile.getColumnNames());
            } else {
                this.model.setColumns(null);
            }
            if (this.outputSlider.getValue() != 0) {
                this.outputSlider.setValue(0);
            } else {
                this.setOutputPosition(0L);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            if (this.outputRandFile != null) {
                try {
                    this.outputRandFile.close();
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                }
            }
            this.outputRandFile = null;
            this.outputData = null;
            return;
        }
    }

    public void setOutputPosition(long l) {
        try {
            if (this.outputData == null || this.outputRandFile == null || l < 0L) {
                return;
            }
            this.outputFileSize = this.outputRandFile.length();
            if (this.outputData.getFile().getName().endsWith("gz")) {
                this.outputFileSize *= 5L;
            }
            if (l > this.outputFileSize) {
                l = this.outputFileSize;
            }
            if (this.outputReqPos == l) {
                return;
            }
            this.outputReqPos = l;
            if (this.outputIndexFile == null) {
                int n;
                int n2 = n = this.outputFileSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.outputFileSize;
                if (this.outputSlider.getMaximum() != n) {
                    this.outputSlider.setMaximum(n);
                }
            }
            this.seekToLineHead(this.outputRandFile, l, false, false);
            l = this.outputRandFile.getFilePointer();
            if (this.outputLastPos == l) {
                return;
            }
            this.outputLastPos = l;
            this.updateTable();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateTable() throws IOException {
        if (this.outputData != null && this.outputData.getFile().exists() && this.outputLastPos >= 0L) {
            int n = this.scrollPane.getHeight() / this.table.getRowHeight() + 1;
            Vector<List<String>> vector = new Vector<List<String>>(n);
            try (TextReader textReader = this.outputData.reader(this.outputLastPos);){
                for (int i = 0; i < n && textReader.hasNext(); ++i) {
                    vector.add(textReader.nextLine());
                }
            }
            this.model.setData(vector);
        }
    }

    public void setOutputIndexFile(File file, File file2) {
        try {
            if (file2 != null && file2.exists()) {
                RowIndexHeader rowIndexHeader = IndexControl.readRowIndexHeader(file2);
                if (!rowIndexHeader.isIndexVaild(file)) {
                    return;
                }
                this.outputIndexHeader = rowIndexHeader;
                this.outputIndexFile = new RandomAccessFile(file2, "r");
                this.outputSlider.setMaximum((int)rowIndexHeader.getRowNum(file2) - 1);
                this.model.setRownum(true);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            if (this.outputIndexFile != null) {
                try {
                    this.outputIndexFile.close();
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                }
            }
            this.outputIndexHeader = null;
            this.outputIndexFile = null;
        }
    }

    public void connect(TextFile textFile) throws IOException {
        if (!textFile.getFile().exists()) {
            throw new FileNotFoundException();
        }
        this.clear(true, true, true);
        this.setOutputFile(textFile);
        UIUtility.resizeColumns(this.table, 100, 0);
    }

    private void seekToLineHead(RandomAccessFile randomAccessFile, long l, boolean bl, boolean bl2) throws IOException {
        --l;
        if (!bl) {
            if (bl2) {
                block11: while (l >= 0L) {
                    randomAccessFile.seek(l);
                    switch (randomAccessFile.read()) {
                        case 10: 
                        case 13: {
                            break;
                        }
                        default: {
                            break block11;
                        }
                    }
                    --l;
                }
            }
            block12: while (l >= 0L) {
                randomAccessFile.seek(l);
                switch (randomAccessFile.read()) {
                    case -1: 
                    case 10: {
                        break block12;
                    }
                    case 13: {
                        long l2 = randomAccessFile.getFilePointer();
                        if (randomAccessFile.read() == 10) break block12;
                        randomAccessFile.seek(l2);
                        break block12;
                    }
                    default: {
                        --l;
                        continue block12;
                    }
                }
            }
            if (l < 0L) {
                randomAccessFile.seek(0L);
            }
        } else {
            if (bl2) {
                ++l;
            }
            randomAccessFile.seek(l);
            block13: while (true) {
                switch (randomAccessFile.read()) {
                    case -1: 
                    case 10: {
                        break block13;
                    }
                    case 13: {
                        long l3 = randomAccessFile.getFilePointer();
                        if (randomAccessFile.read() == 10) break block13;
                        randomAccessFile.seek(l3);
                        break block13;
                    }
                    default: {
                        continue block13;
                    }
                }
                break;
            }
        }
    }

    private void scroll(int n, boolean bl) throws IOException {
        if (this.outputRandFile == null) {
            return;
        }
        if (this.outputIndexFile == null) {
            long l = this.outputLastPos;
            for (int i = 0; i < n; ++i) {
                this.seekToLineHead(this.outputRandFile, l, !bl, true);
                l = this.outputRandFile.getFilePointer();
            }
            if (this.outputFileSize > Integer.MAX_VALUE) {
                this.outputSlider.setValue((int)((double)l / (double)this.outputFileSize * 2.147483647E9));
                this.setOutputPosition(l);
            } else {
                this.outputSlider.setValue((int)l);
            }
        } else {
            int n2 = this.outputSlider.getValue();
            n2 = bl ? (n2 -= n) : (n2 += n);
            if (n2 <= 0) {
                n2 = 1;
            }
            this.outputSlider.setValue(n2);
        }
    }

    private void outputSliderStateChanged(ChangeEvent changeEvent) {
        long l = this.outputSlider.getValue();
        if (this.outputIndexFile == null) {
            if (this.outputFileSize > Integer.MAX_VALUE) {
                l = (long)((double)l / 2.147483647E9 * (double)this.outputFileSize);
            }
        } else {
            try {
                if (l == 0L && this.outputData.isHeader()) {
                    ++l;
                }
                this.model.setRownumStart(l);
                ++l;
                this.model.setRownum(true);
                l = IndexControl.getPosOfRow(this.outputIndexFile, this.outputIndexHeader, l);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
        }
        this.setOutputPosition(l);
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        jScrollBar.setValue(jScrollBar.getMinimum());
    }

    private class RATableModel
    extends AbstractTableModel {
        private String[] columns = null;
        private Vector<List<String>> data = new Vector();
        private int colCount = 0;
        private boolean rownum = false;
        private long rownumStart = 1L;

        private RATableModel() {
        }

        public void setColumns(String[] stringArray) {
            this.columns = stringArray;
            this.fireTableStructureChanged();
        }

        public void setData(Vector<List<String>> vector) {
            this.data = vector;
            int n = this.getColumnCount();
            this.colCount = 0;
            for (List<String> list : vector) {
                if (this.colCount >= list.size()) continue;
                this.colCount = list.size();
            }
            if (n != this.getColumnCount()) {
                this.fireTableStructureChanged();
            }
            this.fireTableDataChanged();
        }

        public void setRownum(boolean bl) {
            if (this.rownum != bl) {
                this.rownum = bl;
                this.fireTableStructureChanged();
            }
        }

        public void setRownumStart(long l) {
            this.rownumStart = l;
        }

        public void clear() {
            this.data = new Vector();
            this.colCount = 0;
            this.rownum = false;
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int n) {
            if (this.columns == null) {
                return super.getColumnName(n);
            }
            if (this.rownum) {
                if (n == 0) {
                    return "";
                }
                --n;
            }
            if (this.columns == null || n >= this.columns.length) {
                return "";
            }
            return this.columns[n];
        }

        @Override
        public int getColumnCount() {
            int n = this.columns == null ? 0 : this.columns.length;
            return Math.max(n, this.colCount) + (this.rownum ? 1 : 0);
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            List<String> list;
            if (this.rownum) {
                if (n2 == 0) {
                    return this.rownumStart + (long)n;
                }
                --n2;
            }
            if ((list = this.data.get(n)).size() <= n2) {
                return "";
            }
            return list.get(n2);
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            switch (mouseWheelEvent.getScrollType()) {
                case 0: {
                    int n = mouseWheelEvent.getUnitsToScroll();
                    try {
                        RandomAccessTable.this.scroll(Math.abs(n), n < 0);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    break;
                }
            }
        }
    }
}

