/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.file;

import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.core.app.file.FileInfos;
import com.ef_prime.rflow.core.app.file.TextFile;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.ui.app.file.FileView;
import com.ef_prime.rflow.ui.app.file.FileViewMap;
import com.ef_prime.rflow.ui.app.file.RandomAccessTable;
import com.ef_prime.rflow.ui.view.FileExplorer;
import java.io.File;
import javax.swing.SwingUtilities;

public class RandomAccessTextView
extends FileView
implements ValueChangeEventHandler {
    private RandomAccessTable table;

    public RandomAccessTextView(FileExplorer fileExplorer) {
        super(fileExplorer);
        this.setTitle("Random Access");
    }

    public static boolean isViewable(FileInfo fileInfo) {
        return fileInfo.isText() && !fileInfo.isContainer(FileInfo.ZIP) && fileInfo.getFile().length() > 512000L;
    }

    public static String[] extensions() {
        return FileViewMap.EXT_ALL_ARRAY;
    }

    @Override
    protected void loadContent() {
        this.table = new RandomAccessTable();
        this.add(this.table);
    }

    private TextFile getTextFile() {
        return TextFile.get(this.getFile());
    }

    @Override
    protected Object refreshWork() {
        File file = this.getFile();
        if (file == null) {
            return null;
        }
        FileInfos.getInstance().getFileInfo(file);
        return null;
    }

    @Override
    protected void refreshWorkDone(Object object) {
        TextFile textFile = this.getTextFile();
        if (textFile != null) {
            this.table.setOutputFile(textFile);
        }
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        TextFile textFile = this.getTextFile();
        if (textFile != null) {
            textFile.addEventHandler(this);
        }
        super.viewDidBecomeDisplayable();
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        TextFile textFile = this.getTextFile();
        if (textFile != null) {
            textFile.removeEventHandler(this);
        }
        this.table.clear(true, false, true);
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RandomAccessTextView.this.refreshWorkDone(null);
            }
        });
    }
}

