/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.file;

import java.io.File;
import java.nio.ByteBuffer;

public class RowIndexHeader {
    public long dataSize;
    public int type;
    public int size;
    public long lastModified;

    public RowIndexHeader(int n, int n2, long l) {
        this.type = n;
        this.size = n2;
        this.lastModified = l;
    }

    public boolean isIndexVaild(File file) {
        long l = file.length();
        long l2 = file.lastModified();
        if (l != RowIndexHeader.toUnsingedIntValue(this.size)) {
            return false;
        }
        return l2 / 1000L == this.lastModified / 1000L;
    }

    public long getRowNum(File file) {
        long l = file.length();
        return (l - 32L) / 4L;
    }

    public long getPosOfRow(long l) {
        return 32L + (l - 1L) * 4L;
    }

    private static long toUnsingedIntValue(int n) {
        if (n < 0) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
            byteBuffer.putInt(0);
            byteBuffer.putInt(n);
            byteBuffer.rewind();
            return byteBuffer.getLong();
        }
        return n;
    }
}

