/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.file;

import com.ef_prime.rflow.core.app.file.PageTextReader;
import com.ef_prime.rflow.core.app.file.TextFile;
import com.ef_prime.rflow.core.app.file.TextReader;
import com.ef_prime.rflow.ui.common.table.DataTableModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TextFileDataTableModel
extends DataTableModel {
    private static final Logger LOGGER = Logger.getLogger(TextFileDataTableModel.class.getName());
    private TextFile textFile;
    private TextReader reader;
    private PageTextReader pageReader;
    private ArrayList<String[]> wholeData;
    private String[] names;
    private int columnCount;
    private List<String[]> data = new ArrayList<String[]>();
    private boolean hasNext = true;

    public TextFileDataTableModel(TextFile textFile) throws IOException {
        this.textFile = textFile;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IOException {
        long l;
        if (this.textFile.isColumnNames()) {
            this.names = this.textFile.getColumnNames();
        }
        if ((l = this.textFile.getFile().length()) > 0L && l < 512000L) {
            this.setForwardOnly(false);
            this.wholeData = new ArrayList();
            List<String> list = null;
            try {
                this.reader = this.textFile.reader();
                while ((list = this.reader.nextLine()) != null) {
                    this.wholeData.add(list.toArray(new String[list.size()]));
                }
                this.setTotalRow(this.wholeData.size());
                this.wholeData.trimToSize();
            }
            finally {
                this.dispose();
            }
        } else {
            this.setForwardOnly(true);
            if (this.textFile.supportsPageReader()) {
                this.pageReader = this.textFile.pageReader(this.getPageSize(), this.names != null ? this.names.length : 0);
            } else {
                this.reader = this.textFile.reader();
            }
        }
    }

    @Override
    public void dispose() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Failed to close file connection.", iOException);
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public boolean canGoFirst() {
        return true;
    }

    @Override
    public void first() throws Exception {
        if (this.reader != null) {
            this.reader.close();
        }
        this.init();
    }

    @Override
    public void next(int n) throws Exception {
        int n2 = this.columnCount;
        if (this.pageReader != null) {
            this.data = this.pageReader.nextPage();
            this.columnCount = this.pageReader.getColumnCount();
        } else {
            ArrayList<String[]> arrayList = new ArrayList<String[]>(n);
            this.columnCount = this.names != null ? this.names.length : 0;
            for (int i = 0; i < n && this.reader.hasNext(); ++i) {
                List<String> list = this.reader.nextLine();
                this.columnCount = Math.max(this.columnCount, list.size());
                arrayList.add(list.toArray(new String[list.size()]));
            }
            this.hasNext = this.reader.hasNext();
            this.data = arrayList;
        }
        if (this.columnCount != n2) {
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }

    @Override
    public void setRange(int n, int n2) throws Exception {
        ArrayList<String[]> arrayList = new ArrayList<String[]>(n2);
        int n3 = this.columnCount;
        this.columnCount = this.names != null ? this.names.length : 0;
        int n4 = Math.min(n + n2, this.wholeData.size());
        for (int i = n; i < n4; ++i) {
            String[] stringArray = this.wholeData.get(i);
            this.columnCount = Math.max(this.columnCount, stringArray.length);
            arrayList.add(stringArray);
        }
        this.data = arrayList;
        if (this.columnCount != n3) {
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }

    @Override
    public String getColumnName(int n) {
        if (this.names != null) {
            if (this.names.length > n) {
                return this.names[n];
            }
            return "";
        }
        return Integer.toString(n + 1);
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        String[] stringArray = this.data.get(n);
        if (n2 < stringArray.length) {
            return stringArray[n2];
        }
        return null;
    }
}

