/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.file;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.file.FileSessionEntry;
import com.ef_prime.rflow.core.app.file.TextFile;
import com.ef_prime.rflow.core.base.FileEdit;
import com.ef_prime.rflow.core.base.SessionEntry;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.file.FileUIUtility;
import com.ef_prime.rflow.ui.app.r.script.RScriptUtility;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.CodingSearchBar;
import com.ef_prime.rflow.ui.common.component.CodingStatusBar;
import com.ef_prime.rflow.ui.common.component.CodingTextArea;
import com.ef_prime.rflow.ui.common.component.TextComponentContainer;
import com.ef_prime.rflow.ui.common.keyvalue.Widget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.common.view.LazyLoadView;
import com.ef_prime.rflow.ui.common.view.Page;
import com.ef_prime.rflow.ui.common.view.PagesView;
import com.ef_prime.rflow.ui.common.view.PagesViewFactory;
import com.ef_prime.rflow.ui.common.view.ToolbarSupport;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewTabbedPane;
import com.ef_prime.rflow.ui.util.FontSupport;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.FileEditView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.EventListener;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.fife.ui.rsyntaxtextarea.ErrorStrip;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class TextFileEditView
extends FileEditView
implements ValueChangeEventHandler,
ToolbarSupport {
    private Component mainComponent;
    private JTextComponent textComponent;
    private TextFilePropertyView propertyView;
    private boolean skipBackup;
    private boolean skipSizeCheck;
    private boolean forceOpen;
    private SettingsListener settingsListener;

    public TextFileEditView(TextFile textFile) {
        super(textFile);
        this.setIcon(Icons.getOverlaidIcon(FileUIUtility.getIcon(this.getFile()), "16/pencil.png", 10, 7, 6));
    }

    public static FileEdit toFileEdit(Path path) {
        return TextFile.get(path.toFile());
    }

    @Override
    public TextFile getFileEdit() {
        return (TextFile)super.getFileEdit();
    }

    private File getFile() {
        TextFile textFile = this.getFileEdit();
        return textFile == null ? null : textFile.getFile();
    }

    protected Key<Boolean> getWhitespaceKey() {
        return Settings.EDITOR_WHITESPACES;
    }

    @Override
    protected void loadContent() {
        Object object;
        this.mainComponent = this.createEditorComponent();
        if (this.mainComponent instanceof TextComponentContainer) {
            this.textComponent = ((TextComponentContainer)((Object)this.mainComponent)).getTextComponent();
        }
        View view2 = new View();
        view2.setTitle(Messages.getString("Editor.Text.editor"));
        view2.setIconOnly(true);
        view2.setIcon(Icons.getIcon("16/pencil.png"));
        view2.add(this.mainComponent);
        this.propertyView = new TextFilePropertyView();
        ViewTabbedPane viewTabbedPane = new ViewTabbedPane(false);
        viewTabbedPane.openView(view2);
        viewTabbedPane.openView(this.propertyView);
        this.add((Component)viewTabbedPane, "Center");
        if (this.createToolBar()) {
            object = new JToolBar();
            ((JToolBar)object).setFloatable(false);
            this.configureToolbar((JToolBar)object);
            this.add((Component)object, "North");
        }
        if ((object = this.getFileEdit()) != null) {
            ((ValueMap)object).putValue(TextFile.WHITESPACE, Rflow.settings().getValue(this.getWhitespaceKey()));
        }
        this.refresh(false);
    }

    protected boolean createToolBar() {
        return true;
    }

    protected Component createEditorComponent() {
        TextComponentPanel textComponentPanel = new TextComponentPanel();
        CodingTextArea codingTextArea = new CodingTextArea();
        codingTextArea.setLineWrap(false);
        codingTextArea.setFont(FontSupport.getCodeFont());
        textComponentPanel.setTextComponent((JTextComponent)((Object)codingTextArea));
        ErrorStrip errorStrip = RScriptUtility.createErrorStrip(codingTextArea);
        CodingSearchBar codingSearchBar = new CodingSearchBar(codingTextArea);
        CodingStatusBar codingStatusBar = new CodingStatusBar(codingTextArea);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new RTextScrollPane((RTextArea)codingTextArea, true), "Center");
        jPanel.add((Component)codingSearchBar, "South");
        textComponentPanel.add((Component)jPanel, "Center");
        textComponentPanel.add((Component)codingStatusBar, "South");
        textComponentPanel.add((Component)errorStrip, "East");
        this.settingsListener = new SettingsListener();
        Rflow.settings().addEventHandler(this.settingsListener);
        return textComponentPanel;
    }

    @Override
    public void configureToolbar(JToolBar jToolBar) {
        jToolBar.add(UIUtility.createToolbarButton(this.getActionMap().get("FileEditView.SAVE"), false));
        jToolBar.add(UIUtility.createToolbarButton(this.getActionMap().get("FileEditView.SAVE_AS_DROP_DOWN"), true));
        jToolBar.add(UIUtility.createToolbarButton(this.getActionMap().get("FileEditView.REOPEN"), false));
    }

    protected JTextComponent getTextComponent() {
        return this.textComponent;
    }

    protected void refreshSyntax() {
        if (this.getFileEdit() != null && this.textComponent instanceof CodingTextArea) {
            String string = this.getFileEdit().getValue(TextFile.SYNTAX);
            String string2 = FileUIUtility.getSyntaxStyle(string);
            CodingTextArea codingTextArea = (CodingTextArea)((Object)this.textComponent);
            codingTextArea.setSyntaxEditingStyle(string2);
        }
    }

    private void refreshWhitespaceVisibility() {
        if (this.getFileEdit() != null && this.textComponent instanceof CodingTextArea) {
            CodingTextArea codingTextArea = (CodingTextArea)((Object)this.textComponent);
            codingTextArea.setWhitespacesVisible(this.getFileEdit().getValue(TextFile.WHITESPACE), this.getFileEdit().getNewLine());
        }
    }

    protected WidgetNode getPropertyWidgetNode() {
        return new PanelWidgetNode().addKeys(TextFile.NEWLINE, TextFile.SYNTAX, TextFile.WHITESPACE);
    }

    public void refresh(boolean bl) {
        this.skipBackup = bl;
        super.refresh();
    }

    @Override
    protected Object refreshWork() {
        File file = this.getFile();
        if (file == null) {
            return null;
        }
        TextFile textFile = this.getFileEdit();
        if (textFile == null) {
            return null;
        }
        if (!this.skipSizeCheck && file.length() > 0xA00000L) {
            return file.length();
        }
        try {
            Path path = this.getFileEdit().getFile().toPath();
            return this.getFileEdit().load(path, this.forceOpen, this.skipBackup);
        }
        catch (IOException iOException) {
            return iOException;
        }
    }

    protected void changeEncoding(String string) {
        TextFile textFile = this.getFileEdit();
        if (textFile != null) {
            this.setReloadLock(true);
            try {
                textFile.putValue(TextFile.ENCODING, string);
            }
            finally {
                this.setReloadLock(false);
            }
        }
    }

    @Override
    protected void refreshWorkDone(Object object) {
        TextFile textFile = this.getFileEdit();
        File file = this.getFile();
        if (textFile == null || file == null || object == null || object instanceof Exception || object instanceof Long) {
            this.textComponent.setText("");
            this.textComponent.setEditable(false);
            this.mainComponent.setVisible(false);
            if (textFile == null || file == null) {
                return;
            }
            if (object instanceof Long) {
                String string = new DecimalFormat("0.#").format(file.length() / 1024L / 1024L) + "MB";
                String string2 = Messages.format("Message.confirm_open_large_file", string);
                int n = JOptionPane.showConfirmDialog(this, string2, Messages.getString("Error.title.warning"), 2, 2);
                if (n == 0) {
                    this.skipSizeCheck = true;
                    this.refresh(this.skipBackup);
                } else {
                    this.closeTab();
                }
                return;
            }
            if (object instanceof CharacterCodingException) {
                String string = Messages.format("Editor.Text.select_encoding", file.getName(), textFile.getEncoding().displayName());
                String[] stringArray = string.split("\r?\n");
                JPanel jPanel = new JPanel((LayoutManager)new MigLayout(new LC().fill().insets("0")));
                for (String object22 : stringArray) {
                    jPanel.add((Component)new JLabel(object22, 10), new CC().wrap());
                }
                ValueMap valueMap = new ValueMap();
                valueMap.putValue(TextFile.ENCODING, textFile.getValue(TextFile.ENCODING));
                valueMap.putValue(TextFile.DIRTY, textFile.getValue(TextFile.DIRTY));
                Component component = WidgetFactory.getInstance().create(valueMap, new KeyWidgetNode(TextFile.ENCODING));
                jPanel.add(component);
                Object[] objectArray = new Object[]{Messages.getString("Message.open"), Messages.getString("Message.force_open"), Messages.getString("Button.cancel")};
                JOptionPane jOptionPane = new JOptionPane(jPanel, 0, -1, null, objectArray, objectArray[0]);
                JDialog jDialog = jOptionPane.createDialog(this, Messages.getString("Error.title.error"));
                jDialog.setDefaultCloseOperation(0);
                jDialog.setVisible(true);
                jDialog.dispose();
                Object object2 = jOptionPane.getValue();
                if (objectArray[0].equals(object2) || objectArray[1].equals(object2)) {
                    this.forceOpen = objectArray[1].equals(object2);
                    this.changeEncoding(valueMap.getValue(TextFile.ENCODING));
                    this.refresh(this.skipBackup);
                } else {
                    this.closeTab();
                }
                return;
            }
            UIUtility.showErrorDialog((Component)this, (Exception)object);
            this.closeTab();
            return;
        }
        Document document = (Document)object;
        this.mainComponent.setVisible(true);
        this.textComponent.setEditable(true);
        this.textComponent.setDocument(document);
        this.textComponent.setCaretPosition(0);
        if (this.getFileEdit().areNewlinesMixed()) {
            UIUtility.showWarningDialog(this, Messages.format("Editor.Text.mixed_new_line", this.getFileEdit().getValue(TextFile.NEWLINE)));
        }
        this.refreshSyntax();
        this.refreshWhitespaceVisibility();
    }

    @Override
    protected void loadResource() {
        super.loadResource();
        if (this.getFileEdit() != null) {
            this.getFileEdit().addEventHandler(this);
        }
        if (this.propertyView != null) {
            this.propertyView.refreshContent();
        }
    }

    @Override
    protected void unloadResource() {
        super.unloadResource();
        if (this.getFileEdit() != null) {
            this.getFileEdit().removeEventHandler(this);
        }
        if (this.settingsListener != null) {
            Rflow.settings().removeEventHandler(this.settingsListener);
        }
    }

    @Override
    protected void reloaded() {
        this.refresh(true);
    }

    @Override
    protected boolean doSave(boolean bl) throws IOException {
        EventListener eventListener;
        Object object;
        File file = this.getFile();
        TextFile textFile = this.getFileEdit();
        while (true) {
            if (bl) {
                object = new SaveAs(textFile);
                eventListener = PagesViewFactory.createOkCancelView((Page)object);
                ((PagesView)eventListener).showDialog(Rflow.mainFrame(), Messages.getString("Action.save_as"), true, new Dimension(600, 200));
                if (((PagesView)eventListener).getResult() != 1) {
                    return false;
                }
                TextFile textFile2 = ((SaveAs)object).getSaveAsSettings();
                if (!textFile2.getFile().equals(textFile.getFile()) && TextFile.get(textFile2.getFile()).isDirty()) {
                    String string = Messages.format("Error.editing_cannot_save", textFile2.getFile().getName());
                    JOptionPane.showMessageDialog(Rflow.mainFrame(), string, Messages.getString("Error.title.error"), 0);
                    continue;
                }
                textFile = textFile2;
                textFile.setDocument(this.getFileEdit().getDocument());
            }
            if (bl && !file.equals(textFile.getFile())) break;
            object = this.checkExternalEdit();
            if (object == null) {
                return false;
            }
            if (((Boolean)object).booleanValue()) break;
            bl = true;
        }
        textFile.safeSave(WorkingDirectory.toAbsolutePath(textFile.getFile()).toPath(), Rflow.project().getTempDir().toPath());
        if (bl) {
            if (this.getFileEdit().getFile().equals(textFile.getFile())) {
                this.getFileEdit().putValue(TextFile.ENCODING, textFile.getValue(TextFile.ENCODING));
                this.getFileEdit().putValue(TextFile.NEWLINE, textFile.getValue(TextFile.NEWLINE));
                this.getFileEdit().setDirty(false);
            } else {
                object = TextFile.get(textFile.getFile());
                ((TextFile)object).copyValuesFrom(textFile);
                eventListener = this.getFileEdit();
                Rflow.mainView().getViews((FileEdit)object).forEach(fileEditView -> {
                    if (!fileEditView.equals(this)) {
                        fileEditView.closeTab();
                    }
                });
                this.setFileEdit((FileEdit)object);
                ((TextFile)eventListener).clearEdit();
                eventListener.dispatchFileEditEvent(4);
            }
        }
        this.getFileEdit().dispatchFileEditEvent(3);
        return true;
    }

    @Override
    public SessionEntry getSessionEntry(boolean bl) {
        TextFile textFile = this.getFileEdit();
        if (textFile == null) {
            return null;
        }
        return FileSessionEntry.create(Rflow.project(), textFile.getFile(), this.getIcon(), true, this.getViewPosition(), this.isShowing(), textFile.getValue(TextFile.ENCODING), textFile.getValue(TextFile.NEWLINE), textFile.getValue(TextFile.SYNTAX));
    }

    @Override
    public void loadSessionEntry(SessionEntry sessionEntry) {
        if (sessionEntry instanceof FileSessionEntry) {
            FileSessionEntry fileSessionEntry = (FileSessionEntry)sessionEntry;
            TextFile textFile = this.getFileEdit();
            if (textFile == null) {
                return;
            }
            if (fileSessionEntry.getEncoding() != null) {
                textFile.putValue(TextFile.ENCODING, fileSessionEntry.getEncoding());
            }
            if (fileSessionEntry.getNewline() != null) {
                textFile.putValue(TextFile.NEWLINE, fileSessionEntry.getNewline());
            }
            if (fileSessionEntry.getSyntax() != null) {
                textFile.putValue(TextFile.SYNTAX, fileSessionEntry.getSyntax());
            }
        }
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        TextFile textFile = this.getFileEdit();
        if (textFile == null) {
            return;
        }
        if (TextFile.SYNTAX.equals(valueChangeEvent.getKey())) {
            this.refreshSyntax();
            Rflow.mainView().projectSessionChanged();
        } else if (TextFile.WHITESPACE.equals(valueChangeEvent.getKey())) {
            this.refreshWhitespaceVisibility();
            Rflow.settings().putValue(this.getWhitespaceKey(), textFile.getValue(TextFile.WHITESPACE));
        } else if (TextFile.NEWLINE.equals(valueChangeEvent.getKey())) {
            this.refreshWhitespaceVisibility();
            textFile.setDirty(true);
            Rflow.mainView().projectSessionChanged();
        }
    }

    @Override
    public Action getAction(String string) {
        Action action = super.getAction(string);
        if (action != null) {
            return action;
        }
        switch (string) {
            case "MENU_ACTION_COPY": {
                if (this.textComponent.getSelectionStart() == this.textComponent.getSelectionEnd()) break;
                return this.textComponent.getActionMap().get("copy-to-clipboard");
            }
            case "MENU_ACTION_CUT": {
                if (this.textComponent.getSelectionStart() == this.textComponent.getSelectionEnd()) break;
                return this.textComponent.getActionMap().get("cut-to-clipboard");
            }
            case "MENU_ACTION_PASTE": {
                return this.textComponent.getActionMap().get("paste-from-clipboard");
            }
            case "MENU_ACTION_UNDO": {
                if (!(this.textComponent instanceof CodingTextArea) || !((CodingTextArea)((Object)this.textComponent)).canUndo()) break;
                return this.textComponent.getActionMap().get("RTA.UndoAction");
            }
            case "MENU_ACTION_REDO": {
                if (!(this.textComponent instanceof CodingTextArea) || !((CodingTextArea)((Object)this.textComponent)).canRedo()) break;
                return this.textComponent.getActionMap().get("RTA.RedoAction");
            }
            case "MENU_ACTION_FIND": {
                return this.textComponent.getActionMap().get("CodingSearchBar.FIND_ACTION");
            }
        }
        return null;
    }

    private class TextFilePropertyView
    extends LazyLoadView {
        public TextFilePropertyView() {
            this.setTitle(Messages.getString("Action.property"));
            this.setIcon(Icons.getIcon("16/cog.png"));
            this.setIconOnly(true);
        }

        @Override
        protected void loadContent() {
            TextFile textFile = TextFileEditView.this.getFileEdit();
            if (textFile != null) {
                this.add(WidgetFactory.getInstance().create(textFile, TextFileEditView.this.getPropertyWidgetNode()));
            }
        }

        public void refreshContent() {
            if (!this.isContentLoaded()) {
                return;
            }
            this.removeAll();
            this.loadContent();
            this.revalidate();
            this.repaint();
        }
    }

    protected class TextComponentPanel
    extends JPanel
    implements TextComponentContainer {
        private JTextComponent textComponent;

        public TextComponentPanel() {
            super(new BorderLayout());
        }

        public void setTextComponent(JTextComponent jTextComponent) {
            this.textComponent = jTextComponent;
        }

        @Override
        public JTextComponent getTextComponent() {
            return this.textComponent;
        }
    }

    private class SettingsListener
    implements ValueChangeEventHandler {
        private SettingsListener() {
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            if ((Settings.CODE_FONT_FAMILY.equals(valueChangeEvent.getKey()) || Settings.CODE_FONT_SIZE.equals(valueChangeEvent.getKey())) && TextFileEditView.this.textComponent != null) {
                TextFileEditView.this.textComponent.setFont(FontSupport.getCodeFont());
            }
        }
    }

    private static class SaveAs
    extends Page
    implements ValueChangeEventHandler {
        private TextFile saveAsSettings = new TextFile();
        private Component c;

        public SaveAs(TextFile textFile) {
            this.saveAsSettings.copyValues(textFile);
            this.saveAsSettings.putValue(TextFile.FILE, WorkingDirectory.toAbstractPath(this.saveAsSettings.getFile()).getPath());
            this.c = WidgetFactory.getInstance().create(this.saveAsSettings, new PanelWidgetNode().addKeys(TextFile.FILE, TextFile.ENCODING, TextFile.NEWLINE));
            this.add(this.c, "Center");
            this.saveAsSettings.addEventHandler(this);
        }

        public TextFile getSaveAsSettings() {
            this.saveAsSettings.putValue(TextFile.FILE, WorkingDirectory.toAbsolutePath(this.saveAsSettings.getValue(TextFile.FILE)));
            return this.saveAsSettings;
        }

        @Override
        public boolean canGoNext() {
            return !this.saveAsSettings.getValue(TextFile.FILE).isEmpty();
        }

        @Override
        public boolean viewWillClose(int n) {
            if (n == 1) {
                return UIUtility.confirmOverwrite(this.saveAsSettings.getFile(), Rflow.mainFrame());
            }
            return super.viewWillClose(n);
        }

        @Override
        protected void viewShown() {
            super.viewShown();
            if (this.c instanceof Widget) {
                ((Widget)this.c).startEditing();
            }
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            if (TextFile.FILE.equals(valueChangeEvent.getKey())) {
                this.dispatchPageEvent(0);
            }
        }
    }
}

