/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.file;

import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.core.app.file.FileInfos;
import com.ef_prime.rflow.core.app.file.TextFile;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.file.DataTextView;
import com.ef_prime.rflow.ui.app.file.FileView;
import com.ef_prime.rflow.ui.app.file.FileViewMap;
import com.ef_prime.rflow.ui.app.file.RScriptFileView;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.view.FileExplorer;
import java.awt.Component;
import java.util.List;

public class TextSettingsView
extends FileView {
    public TextSettingsView(FileExplorer fileExplorer) {
        super(fileExplorer);
    }

    public static boolean isViewable(FileInfo fileInfo) {
        return fileInfo.isText();
    }

    public static String[] extensions() {
        return FileViewMap.EXT_ALL_ARRAY;
    }

    @Override
    public String getTitle() {
        return Messages.getString("File.TextSettings.title");
    }

    private TextFile getTextFile() {
        return TextFile.get(this.getFile());
    }

    @Override
    protected void loadContent() {
    }

    @Override
    protected Object refreshWork() {
        return null;
    }

    @Override
    protected void refreshWorkDone(Object object) {
        TextFile textFile = this.getTextFile();
        FileInfo fileInfo = FileInfos.getInstance().getFileInfo(this.getFile());
        List<Class<? extends FileView>> list = FileViewMap.getInstance().get(fileInfo);
        Key[] keyArray = list.contains(DataTextView.class) ? new Key[]{TextFile.ENCODING, TextFile.SEP, TextFile.HEADER, TextFile.SYNTAX, TextFile.WHITESPACE} : (list.contains(RScriptFileView.class) ? new Key[]{TextFile.ENCODING, TextFile.WHITESPACE} : new Key[]{TextFile.ENCODING, TextFile.SYNTAX, TextFile.WHITESPACE});
        Component component = WidgetFactory.getInstance().create(textFile, new PanelWidgetNode().addKeys(keyArray));
        this.add(component, "Center");
    }
}

