/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.file;

import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.core.app.file.FileInfos;
import com.ef_prime.rflow.core.app.file.ZipFileUtility;
import com.ef_prime.rflow.core.app.file.ZipInfo;
import com.ef_prime.rflow.core.base.FileManager;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.ui.app.file.FileViewMap;
import com.ef_prime.rflow.ui.app.file.FolderView;
import com.ef_prime.rflow.ui.common.item.ItemEvent;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.view.FileExplorer;
import java.awt.Component;
import java.io.File;
import java.util.Optional;

public class ZipFolderView
extends FolderView
implements ValueChangeEventHandler {
    public ZipFolderView(FileExplorer fileExplorer) {
        super(fileExplorer);
        this.setTitle("Zip");
    }

    public static boolean isViewable(FileInfo fileInfo) {
        return fileInfo.is(FileInfo.ZIP) || fileInfo.isZipDirectory();
    }

    public static String[] extensions() {
        return FileViewMap.EXT_ALL_ARRAY;
    }

    @Override
    protected void refreshWorkDone(Object object) {
        super.refreshWorkDone(object);
        this.getZipInfo().ifPresent(zipInfo -> {
            Component component = WidgetFactory.getInstance().create((ValueMap)zipInfo);
            this.add(component, "South");
            if (!zipInfo.containsEventHandler(this)) {
                zipInfo.addEventHandler(this);
            }
        });
    }

    private Optional<ZipInfo> getZipInfo() {
        File file = this.getFile();
        if (file == null) {
            return Optional.empty();
        }
        FileInfo fileInfo = FileInfos.getInstance().getFileInfo(file);
        if (fileInfo.isContainer(FileInfo.ZIP)) {
            file = ZipFileUtility.getParentZipFile(file);
        }
        return Optional.ofNullable(ZipInfo.get(file));
    }

    @Override
    public void unloadFileView() {
        super.unloadFileView();
        this.getZipInfo().ifPresent(zipInfo -> zipInfo.removeEventHandler(this));
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        if (valueChangeEvent.getKey() == ZipInfo.ENCODING) {
            File file = this.getFile();
            if (file == null) {
                return;
            }
            this.getFileNode().resetChildrenReady();
            this.refresh();
            FileManager.getInstance().dispatchItemEvent(new ItemEvent(FileManager.getInstance(), 1, FileManager.fileToString(file)));
        }
    }
}

