/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.console.BasicCommand;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.util.ThreadUtility;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.JOptionPane;

public class RActions
extends Actions {
    private static RActions instance = new RActions();

    private RActions() {
    }

    public static RActions getInstance() {
        return instance;
    }

    public void askInstallMissingPackages(RPackage[] rPackageArray) {
        double d;
        boolean bl;
        if (rPackageArray == null || rPackageArray.length == 0) {
            return;
        }
        final List<String> list = R.client().getMissingPackages(RPackage.toNames(rPackageArray));
        if (list.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Messages.getString("Message.confirm_install_packages"));
        stringBuilder.append("\n\n");
        for (String string : list) {
            stringBuilder.append("    ");
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        stringBuilder.append("\n");
        String string = R.client().getUserLibraryPath();
        boolean bl2 = bl = string != null;
        if (bl) {
            stringBuilder.append(Messages.getString("Message.create_user_lib_dir") + ":\n" + new File(string).getAbsolutePath());
            stringBuilder.append("\n\n");
        }
        if (list.contains("rJava") && (d = Double.parseDouble(System.getProperty("java.vm.specification.version"))) >= 9.0) {
            stringBuilder.append("(" + Messages.getString("Message.may_restart_r_after_install") + ")");
            stringBuilder.append("\n\n");
        }
        FutureTask<Integer> futureTask = new FutureTask<Integer>(() -> JOptionPane.showConfirmDialog(Rflow.getInstance().getMainFrame(), stringBuilder, Messages.getString("Message.confirm"), 0, 1));
        UIUtility.invokeLater(futureTask);
        int n = 1;
        try {
            n = futureTask.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
        if (n != 0) {
            return;
        }
        ThreadUtility.execute(new Runnable(){

            @Override
            public void run() {
                Object object = bl ? ".createUserLibrary();" : "";
                object = (String)object + "install.packages(" + RUtility.combineCharacters(list) + ")";
                BasicCommand basicCommand = new BasicCommand((String)object);
                Boolean bl2 = Rflow.settings().getValue(Settings.USE_CONSOLE_BUFFER);
                if (bl2.booleanValue()) {
                    Rflow.settings().putValue(Settings.USE_CONSOLE_BUFFER, Boolean.FALSE);
                }
                R.receiver().passCommand(basicCommand);
                basicCommand.waitForCommand();
                R.client().updateInstalledPackages(false);
                if (bl2.booleanValue()) {
                    Rflow.settings().putValue(Settings.USE_CONSOLE_BUFFER, Boolean.TRUE);
                }
                if (list.contains("JavaGD")) {
                    R.client().eval("if(\"JavaGD\" %in% .packages(all.available = TRUE)) {options(device = RflowGD)}");
                }
                if (list.contains("rJava")) {
                    R.client().initRJava(false);
                }
            }
        });
    }

    public void attachPackagesIfNeeded(RPackage[] rPackageArray) {
        if (rPackageArray == null) {
            return;
        }
        for (RPackage rPackage : rPackageArray) {
            if (!rPackage.isAttach()) continue;
            R.receiver().passCommand("library(" + rPackage.getName() + ")");
        }
    }
}

