/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r;

import com.ef_prime.rflow.core.app.r.base.ArgEntry;
import com.ef_prime.rflow.core.app.r.base.ArgList;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RObjectSet;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceProvider;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.TableKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.table.RowBasedTableModel;
import com.ef_prime.rflow.ui.app.r.script.AbstractRCodingTextArea;
import com.ef_prime.rflow.ui.app.r.script.RCompletion;
import com.ef_prime.rflow.ui.app.r.script.RCompletionAddOn;
import com.ef_prime.rflow.ui.app.r.script.RCompletionProvider;
import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DescriptionListener;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.rosuda.REngine.REXP;

public abstract class RChoiceProvider
implements ChoiceProvider {
    private static final Logger LOGGER = Logger.getLogger(RChoiceProvider.class.getName());
    private boolean exclusive;

    public static RChoiceProvider args(String string, boolean bl, Predicate<String> predicate) {
        return new Args(string, bl, predicate);
    }

    public static RChoiceProvider columns(Key<?> key, boolean bl) {
        return new Columns(key, bl);
    }

    public static RChoiceProvider columns(String string, boolean bl) {
        return new Columns(string, bl);
    }

    public static RChoiceProvider factorLikeColumns(String string, boolean bl) {
        return new FactorLikeColumns(string, bl);
    }

    public static RChoiceProvider names(String string, boolean bl, String string2) {
        return new Names(string, bl, string2);
    }

    public static RChoiceProvider globalObjects() {
        return RChoiceProvider.globalObjects(true);
    }

    public static RChoiceProvider globalObjects(boolean bl) {
        return new GlobalObjects(bl, 0);
    }

    public static RChoiceProvider objects(Predicate<RObject> predicate, int n) {
        return new GlobalObjects(predicate, n);
    }

    public static RChoiceProvider globalDataFrames() {
        return RChoiceProvider.inherits("data.frame");
    }

    public static RChoiceProvider inherits(String ... stringArray) {
        return RChoiceProvider.inherits(0, stringArray);
    }

    public static RChoiceProvider inherits(int n, String ... stringArray) {
        return new Inherits(stringArray, n);
    }

    public static RChoiceProvider matrices(String ... stringArray) {
        return new Matrices(stringArray);
    }

    public static RChoiceProvider inheritsOrMatrices(String[] stringArray, String[] stringArray2) {
        return new InheritsOrMatrices(stringArray, stringArray2);
    }

    public static RChoiceProvider levels(String string, String string2) {
        return new Levels(string, string2);
    }

    public static RChoiceProvider packages() {
        return new Packages();
    }

    public static RChoiceProvider datasetPackages() {
        return new DatasetPackages();
    }

    public static RChoiceProvider datasets(String string) {
        return new Datasets(string);
    }

    public static RChoiceProvider arbitraryFunction(String string, String string2) {
        return new ArbitraryFunction(string, string2);
    }

    public static List<Choice> rQueryToChoices(String string) {
        return ChoiceProvider.strArrayToChoices(RClient.rexpToStrings(R.client().silentIdleEvalGet(string), null, null));
    }

    protected String getTarget(Object object, ValueMap valueMap) {
        if (object instanceof StrKey) {
            return valueMap.getValue((StrKey)object);
        }
        return object.toString();
    }

    protected String getValue(String string, ValueMap valueMap) {
        Key<?> key = valueMap.getKey(string);
        if (!(key instanceof StrKey)) {
            return null;
        }
        return valueMap.getValue((StrKey)key);
    }

    @Override
    public abstract List<Choice> getChoices(ValueMap var1);

    @Override
    public boolean isLabel() {
        return false;
    }

    @Override
    public boolean isDescription() {
        return false;
    }

    @Override
    public boolean isExclusive() {
        return this.exclusive;
    }

    public RChoiceProvider setExclusive(boolean bl) {
        this.exclusive = bl;
        return this;
    }

    public Predicate<RObject> getFilter() {
        return null;
    }

    public abstract Object toYaml();

    public static void install(ChoiceProvider choiceProvider, AbstractRCodingTextArea abstractRCodingTextArea, ValueMap valueMap) {
        RCompletionProvider rCompletionProvider = new RCompletionProvider();
        rCompletionProvider.setPriorityList(new AddOn(choiceProvider, valueMap));
        abstractRCodingTextArea.getAutoCompletion().setCompletionProvider((CompletionProvider)rCompletionProvider);
    }

    public static String getHelp(RClient rClient, String string) {
        String string2 = rClient.getHtmlHelp(string, false);
        if (string2 == null || string2.isEmpty()) {
            return "";
        }
        Document document = Jsoup.parse((String)string2);
        RChoiceProvider.enableHtml(document);
        return document.outerHtml();
    }

    public static Document getFunctionHelp(RClient rClient, String string, Map<String, Integer> map) {
        try {
            String string2 = rClient.getHtmlHelp(string, false);
            Document document = Jsoup.parse((String)string2);
            RChoiceProvider.enableHtml(document);
            Elements elements = document.select("html>body>table[summary=R argblock]>tbody>tr");
            for (int i = 0; i < elements.size(); ++i) {
                org.jsoup.nodes.Element element;
                org.jsoup.nodes.Element element2 = elements.get(i);
                org.jsoup.nodes.Element element3 = element2.child(0);
                if (element3 == null || (element = element3.child(0)) == null) continue;
                String string3 = element.text();
                String[] stringArray = string3.split(",");
                for (int j = 0; j < stringArray.length; ++j) {
                    map.put(stringArray[j].trim(), i);
                }
                element2.attr("id", "arg" + i);
            }
            return document;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void scrollToArg(JEditorPane jEditorPane, String string, Map<String, Integer> map) {
        String string2;
        String string3 = string2 = map == null ? null : "arg" + String.valueOf(map.get(string));
        if (string2 == null) {
            return;
        }
        javax.swing.text.Document document = jEditorPane.getDocument();
        if (document instanceof HTMLDocument) {
            HTMLDocument hTMLDocument = (HTMLDocument)document;
            Element element = hTMLDocument.getDefaultRootElement();
            Element element2 = RChoiceProvider.findFirstElement(element, "body");
            if (element2 == null) {
                return;
            }
            Element element3 = RChoiceProvider.findFirstElementWithAttr(element2, "table", "summary", "R argblock");
            if (element3 == null) {
                return;
            }
            Element element4 = RChoiceProvider.findFirstElementWithAttr(element3, "tr", HTML.Attribute.ID, string2);
            if (element4 == null) {
                return;
            }
            jEditorPane.setCaretPosition(element4.getStartOffset());
            try {
                Rectangle rectangle = jEditorPane.modelToView(element4.getStartOffset());
                if (rectangle != null) {
                    rectangle.height = jEditorPane.getVisibleRect().height;
                    rectangle.y -= 5;
                    jEditorPane.scrollRectToVisible(rectangle);
                }
            }
            catch (BadLocationException badLocationException) {
                LOGGER.log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
            }
        }
    }

    private static void enableHtml(Document document) {
        for (org.jsoup.nodes.Element element : document.head().children()) {
            if (!element.tagName().equals("meta")) continue;
            element.remove();
        }
    }

    private static Element findFirstElement(Element element, String string) {
        for (int i = 0; i < element.getElementCount(); ++i) {
            if (!element.getElement(i).getName().equals(string)) continue;
            return element.getElement(i);
        }
        return null;
    }

    private static Element findFirstElementWithAttr(Element element, String string, Object object, Object object2) {
        for (int i = 0; i < element.getElementCount(); ++i) {
            Object object3;
            if (!element.getElement(i).getName().equals(string) || (object3 = element.getElement(i).getAttributes().getAttribute(object)) == null || !object3.equals(object2)) continue;
            return element.getElement(i);
        }
        return null;
    }

    private static class Args
    extends RChoiceProvider {
        private Object key;
        private boolean sort;
        private Predicate<String> predicate;
        private String targetFunction;
        private String helpHtmlString;
        private Map<String, Integer> argsMap;

        public Args(Object object, boolean bl, Predicate<String> predicate) {
            this.key = object;
            this.sort = bl;
            this.predicate = predicate;
            if (this.predicate == null) {
                this.predicate = string -> true;
            }
        }

        @Override
        public boolean isDescription() {
            return true;
        }

        @Override
        public List<Choice> getChoices(ValueMap valueMap) {
            this.targetFunction = this.getTarget(this.key, valueMap);
            ArgList argList = R.client().argList(this.targetFunction);
            if (argList == null) {
                return EMPTY;
            }
            ArrayList<Choice> arrayList = new ArrayList<Choice>(argList.size());
            for (int i = 0; i < argList.size(); ++i) {
                ArgEntry argEntry = (ArgEntry)argList.get(i);
                if (!argEntry.isParam() || argEntry.getParam().equals("...") || valueMap.getKey(argEntry.getParam()) != null || !this.predicate.test(argEntry.getParam())) continue;
                arrayList.add(new ChoiceWithDescription(argEntry.getParam()));
            }
            if (this.sort) {
                arrayList.sort(Choice.valueSorter());
            }
            return arrayList;
        }

        @Override
        public Object toYaml() {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            linkedHashMap.put("type", "args");
            if (this.key instanceof StrKey) {
                linkedHashMap.put("key", ((StrKey)this.key).getId());
            } else {
                linkedHashMap.put("function", this.key);
            }
            return linkedHashMap;
        }

        private class ChoiceWithDescription
        extends Choice
        implements DescriptionListener {
            public ChoiceWithDescription(String string) {
                super(string, null, null);
            }

            @Override
            public String getDescription() {
                if (Args.this.helpHtmlString == null) {
                    Args.this.argsMap = new HashMap<String, Integer>();
                    Document document = RChoiceProvider.getFunctionHelp(R.client(), Args.this.targetFunction, Args.this.argsMap);
                    Args.this.helpHtmlString = document == null ? null : document.outerHtml();
                }
                return Args.this.helpHtmlString;
            }

            public void descriptionDidSet(JEditorPane jEditorPane) {
                RChoiceProvider.scrollToArg(jEditorPane, this.getValue(), Args.this.argsMap);
            }
        }
    }

    private static class Columns
    extends RChoiceProvider {
        private Object key;
        private boolean checkNames;

        public Columns(Object object, boolean bl) {
            this.key = object;
            this.checkNames = bl;
        }

        @Override
        public List<Choice> getChoices(ValueMap valueMap) {
            StrKey strKey = null;
            if (this.key instanceof String) {
                this.key = valueMap.getKey((String)this.key);
            }
            if (this.key instanceof StrKey) {
                strKey = (StrKey)this.key;
            }
            if (strKey == null) {
                return EMPTY;
            }
            String[] stringArray = R.client().names(valueMap.getValue(strKey), this.checkNames, null);
            return ChoiceProvider.strArrayToChoices(stringArray);
        }

        @Override
        public Object toYaml() {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            linkedHashMap.put("type", "columns");
            if (this.key instanceof StrKey) {
                linkedHashMap.put("key", ((StrKey)this.key).getId());
            } else {
                linkedHashMap.put("parent", this.key);
            }
            return linkedHashMap;
        }
    }

    private static class FactorLikeColumns
    extends RChoiceProvider {
        private String key;
        private boolean checkNames;

        public FactorLikeColumns(String string, boolean bl) {
            this.key = string;
            this.checkNames = bl;
        }

        @Override
        public List<Choice> getChoices(ValueMap valueMap) {
            String string = this.getValue(this.key, valueMap);
            if (string == null) {
                return EMPTY;
            }
            String[] stringArray = R.client().factorLikeColumns(string, this.checkNames, null);
            return ChoiceProvider.strArrayToChoices(stringArray);
        }

        @Override
        public Object toYaml() {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("key", this.key);
            return linkedHashMap;
        }
    }

    private static class Names
    extends RChoiceProvider {
        private String key;
        private boolean checkNames;
        private String filterFunc;

        public Names(String string, boolean bl, String string2) {
            this.key = string;
            this.checkNames = bl;
            this.filterFunc = string2;
        }

        @Override
        public List<Choice> getChoices(ValueMap valueMap) {
            String string = this.getValue(this.key, valueMap);
            if (string == null) {
                return EMPTY;
            }
            String[] stringArray = R.client().getNames(string, this.checkNames, this.filterFunc, null);
            return ChoiceProvider.strArrayToChoices(stringArray);
        }

        @Override
        public Object toYaml() {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("key", this.key);
            return linkedHashMap;
        }
    }

    private static class GlobalObjects
    extends RChoiceProvider {
        protected Predicate<RObject> filter;
        private int depth;

        public GlobalObjects() {
            this(true, 0);
        }

        public GlobalObjects(int n) {
            this(true, n);
        }

        public GlobalObjects(boolean bl, int n) {
            this.depth = n;
            this.filter = bl ? new Predicate<RObject>(){

                @Override
                public boolean test(RObject rObject) {
                    return true;
                }
            } : new Predicate<RObject>(){

                @Override
                public boolean test(RObject rObject) {
                    return !rObject.getName(false).startsWith(".");
                }
            };
        }

        public GlobalObjects(Predicate<RObject> predicate, int n) {
            this.filter = predicate;
            this.depth = n;
        }

        @Override
        public List<Choice> getChoices(ValueMap valueMap) {
            RObjectSet rObjectSet = R.client().getObjects(null, true, 500, 0, this.depth);
            if (rObjectSet == null) {
                return EMPTY;
            }
            ArrayList<Choice> arrayList = new ArrayList<Choice>(rObjectSet.getObjects().size());
            rObjectSet.treeIterator().forEachRemaining(rObject -> {
                if (this.filter.test((RObject)rObject)) {
                    this.add((List<Choice>)arrayList, (RObject)rObject);
                }
            });
            return arrayList;
        }

        protected void add(List<Choice> list, RObject rObject) {
            String string = this.depth > 0 ? rObject.getFullName(false) : rObject.getName(true);
            list.add(new Choice(string));
        }

        @Override
        public Predicate<RObject> getFilter() {
            return this.filter;
        }

        @Override
        public Map<String, Object> toYaml() {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            return linkedHashMap;
        }
    }

    private static class Inherits
    extends GlobalObjects {
        private String[] classes;

        public Inherits(String[] stringArray, int n) {
            super(n);
            this.classes = stringArray;
            final HashSet<String> hashSet = new HashSet<String>(stringArray.length);
            for (String string : stringArray) {
                hashSet.add(string);
            }
            this.filter = new Predicate<RObject>(){

                @Override
                public boolean test(RObject rObject) {
                    return rObject.inherits(hashSet);
                }
            };
        }

        @Override
        public Map<String, Object> toYaml() {
            Object object = super.toYaml();
            object.put("class", this.classes);
            return object;
        }
    }

    private static class Matrices
    extends GlobalObjects {
        private String[] types;

        public Matrices(String[] stringArray) {
            this.types = stringArray;
            final HashSet<String> hashSet = new HashSet<String>(stringArray.length);
            for (String string : stringArray) {
                hashSet.add(string);
            }
            this.filter = new Predicate<RObject>(){

                @Override
                public boolean test(RObject rObject) {
                    return rObject.isFlag(2) && hashSet.contains(rObject.getType());
                }
            };
        }

        @Override
        public Map<String, Object> toYaml() {
            Object object = super.toYaml();
            object.put("types", this.types);
            return object;
        }
    }

    private static class InheritsOrMatrices
    extends GlobalObjects {
        private Inherits inherits;
        private Matrices matrices;

        public InheritsOrMatrices(String[] stringArray, String[] stringArray2) {
            this.inherits = new Inherits(stringArray, 0);
            this.matrices = new Matrices(stringArray2);
            this.filter = new Predicate<RObject>(){

                @Override
                public boolean test(RObject rObject) {
                    return inherits.filter.test(rObject) || matrices.filter.test(rObject);
                }
            };
        }

        @Override
        public Map<String, Object> toYaml() {
            Object object = super.toYaml();
            return object;
        }
    }

    private static class Levels
    extends RChoiceProvider {
        private String dataKey;
        private String columnKey;

        public Levels(String string, String string2) {
            this.dataKey = string;
            this.columnKey = string2;
        }

        @Override
        public List<Choice> getChoices(ValueMap valueMap) {
            Object object;
            long l = 2000L;
            StrKey strKey = (StrKey)valueMap.getKey(this.dataKey);
            Key<?> key = valueMap.getKey(this.columnKey);
            if (strKey == null || key == null) {
                return EMPTY;
            }
            String string = "";
            if (key instanceof TableKey) {
                object = valueMap.getValue((TableKey)key);
                if (((RowBasedTableModel)object).getRowCount() > 0) {
                    string = (String)((RowBasedTableModel)object).getValueAt(0, 0);
                }
            } else {
                string = valueMap.getValue((StrKey)key);
            }
            object = valueMap.getValue(strKey) + "$" + string;
            REXP rEXP = R.client().silentTimeoutEvalGet(".rflowLevels(" + (String)object + ")", l);
            String[] stringArray = RClient.rexpToStrings(rEXP, ArrayUtils.EMPTY_STRING_ARRAY, null);
            return ChoiceProvider.strArrayToChoices(stringArray);
        }

        @Override
        public Object toYaml() {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            return linkedHashMap;
        }
    }

    private static class Packages
    extends RChoiceProvider {
        @Override
        public List<Choice> getChoices(ValueMap valueMap) {
            String[] stringArray = R.client().getInstalledPackages();
            Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
            return ChoiceProvider.strArrayToChoices(stringArray);
        }

        @Override
        public Object toYaml() {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            return linkedHashMap;
        }
    }

    private static class DatasetPackages
    extends RChoiceProvider {
        private DatasetPackages() {
        }

        @Override
        public List<Choice> getChoices(ValueMap valueMap) {
            String[] stringArray = R.client().getDatasets(".packages(all.available = TRUE)");
            if (stringArray == null) {
                return EMPTY;
            }
            int n = stringArray.length / 4;
            HashSet<String> hashSet = new HashSet<String>(n / 4);
            for (int i = 0; i < n; ++i) {
                hashSet.add(stringArray[i]);
            }
            String[] stringArray2 = hashSet.toArray(new String[hashSet.size()]);
            Arrays.sort(stringArray2, String.CASE_INSENSITIVE_ORDER);
            return ChoiceProvider.strArrayToChoices(stringArray2);
        }

        @Override
        public Object toYaml() {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            return linkedHashMap;
        }
    }

    private static class Datasets
    extends RChoiceProvider {
        private String packageKey;

        public Datasets(String string) {
            this.packageKey = string;
        }

        @Override
        public List<Choice> getChoices(ValueMap valueMap) {
            String[] stringArray;
            String string = null;
            if (this.packageKey != null) {
                string = valueMap.getValue((StrKey)valueMap.getKey(this.packageKey));
            }
            if ((stringArray = R.client().getDatasets(StringUtils.isEmpty(string) ? "" : RUtility.quote(string))) == null) {
                return EMPTY;
            }
            int n = stringArray.length / 4;
            ArrayList<Choice> arrayList = new ArrayList<Choice>(n);
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[n * 2 + i];
                int n2 = string2.indexOf(32);
                if (n2 > 0) {
                    string2 = string2.substring(0, n2);
                }
                arrayList.add(new DatasetChoice(string, string2));
            }
            return arrayList;
        }

        @Override
        public Object toYaml() {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            return linkedHashMap;
        }

        @Override
        public boolean isDescription() {
            return true;
        }

        private static class DatasetChoice
        extends Choice {
            private String pack;

            public DatasetChoice(String string, String string2) {
                super(string2);
                this.pack = string;
            }

            @Override
            public String getDescription() {
                Object object = this.getValue();
                if (this.pack != null && !this.pack.isEmpty()) {
                    object = this.pack + "::" + (String)object;
                }
                return RChoiceProvider.getHelp(R.client(), (String)object);
            }
        }
    }

    private static class ArbitraryFunction
    extends RChoiceProvider {
        private String functionKey;
        private String dataKey;

        public ArbitraryFunction(String string, String string2) {
            this.functionKey = string;
            this.dataKey = string2;
        }

        @Override
        public List<Choice> getChoices(ValueMap valueMap) {
            String string = valueMap.getStrValue(this.functionKey);
            String string2 = valueMap.getStrValue(this.dataKey);
            if (string == null || string2 == null) {
                return EMPTY;
            }
            String[] stringArray = RClient.rexpToStrings(R.client().silentIdleEvalGet(string + "(" + string2 + ")"), null, null);
            return ChoiceProvider.strArrayToChoices(stringArray);
        }

        @Override
        public Object toYaml() {
            return null;
        }
    }

    private static class AddOn
    implements RCompletionAddOn {
        private ChoiceProvider provider;
        private ValueMap valueMap;

        public AddOn(ChoiceProvider choiceProvider, ValueMap valueMap) {
            this.provider = choiceProvider;
            this.valueMap = valueMap;
        }

        @Override
        public List<RCompletion> getCompletions(CompletionProvider completionProvider) {
            ArrayList arrayList = Lists.newArrayList();
            List<Choice> list = this.provider.getChoices(this.valueMap);
            if (list == null || list.isEmpty()) {
                return arrayList;
            }
            for (Choice choice : list) {
                arrayList.add(new ChoiceCompletion(completionProvider, choice));
            }
            return arrayList;
        }

        @Override
        public boolean isExclusive() {
            return this.provider.isExclusive();
        }
    }

    private static class ChoiceCompletion
    extends RCompletion
    implements DescriptionListener {
        private Choice choice;

        public ChoiceCompletion(CompletionProvider completionProvider, Choice choice) {
            super(completionProvider, choice.getValue());
            this.choice = choice;
        }

        public String getSummary() {
            return this.choice.getDescription();
        }

        public void descriptionDidSet(JEditorPane jEditorPane) {
            if (this.choice instanceof DescriptionListener) {
                ((DescriptionListener)this.choice).descriptionDidSet(jEditorPane);
            }
        }
    }
}

