/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r;

import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.object.RDataObjectView;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.event.Event;
import com.ef_prime.rflow.ui.common.event.EventHandler;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;

public class RColumnSelectionTableView
extends RDataObjectView {
    private boolean include;
    private List<String> selection = new ArrayList<String>();
    private boolean[] selectionArray = new boolean[0];
    private CheckBoxTableHeaderRenderer renderer;
    private SelectionActions actions = new SelectionActions();
    private EventSupport<ColumnSelectionEvent, ColumnSelectionHandler> observable = new EventSupport();

    public RColumnSelectionTableView() {
        super(R.getInterface(), null);
    }

    @Override
    protected void loadContent() {
        super.loadContent();
        this.renderer = new CheckBoxTableHeaderRenderer();
        this.getTable().getTableHeader().setDefaultRenderer(this.renderer);
        UIUtility.insertMouseListener(this.getTable().getTableHeader(), new CheckBoxHeaderMouseHandler());
        this.getTable().setDefaultRenderer(String.class, (TableCellRenderer)((Object)new CellRenderer()));
        this.getTable().setShowGrid(true);
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        jToolBar.setBorder(BorderFactory.createEmptyBorder());
        jToolBar.add(this.actions.createToolBarButton("SELECT_ALL"));
        jToolBar.add(this.actions.createToolBarButton("DESELECT_ALL"));
        jToolBar.add(this.actions.createToolBarButton("INVERT_SELECTION"));
        this.add((Component)jToolBar, "West");
    }

    public void setSelection(boolean bl, List<String> list) {
        this.include = bl;
        this.selection = list;
        this.refreshSelection();
    }

    private int getAndRefreshColumnCount() {
        int n = this.getTable().getColumnCount();
        if (this.selectionArray.length != n) {
            this.selectionArray = new boolean[n];
        }
        return n;
    }

    private void refreshSelection() {
        int n = this.getAndRefreshColumnCount();
        for (int i = 0; i < n; ++i) {
            String string = this.getTable().getColumnName(i);
            this.selectionArray[i] = this.selection.contains(string);
        }
        this.getTable().getTableHeader().repaint();
        this.getTable().repaint();
    }

    @Override
    protected void refreshWorkDone(Object object) {
        super.refreshWorkDone(object);
        this.refreshSelection();
    }

    public void addObserver(ColumnSelectionHandler columnSelectionHandler) {
        this.observable.addEventHandler(columnSelectionHandler);
    }

    public void removeObserver(ColumnSelectionHandler columnSelectionHandler) {
        this.observable.removeEventHandler(columnSelectionHandler);
    }

    private void dispatchEvent(ColumnSelectionEvent columnSelectionEvent) {
        this.observable.dispatchEvent(columnSelectionEvent);
    }

    private class SelectionActions
    extends Actions {
        static final String SELECT_ALL = "SELECT_ALL";
        static final String DESELECT_ALL = "DESELECT_ALL";
        static final String INVERT_SELECTION = "INVERT_SELECTION";

        public SelectionActions() {
            this.put(SELECT_ALL, new SelectAll());
            this.put(DESELECT_ALL, new DeselectAll());
            this.put(INVERT_SELECTION, new InvertSelection());
        }

        private JButton createToolBarButton(String string) {
            Action action = this.get(string);
            JButton jButton = new JButton(action);
            jButton.setHideActionText(true);
            jButton.setToolTipText((String)action.getValue("Name"));
            return jButton;
        }

        private void selectAll(boolean bl) {
            int n = RColumnSelectionTableView.this.getAndRefreshColumnCount();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < n; ++i) {
                if (!(bl ^ RColumnSelectionTableView.this.selectionArray[i])) continue;
                arrayList.add(RColumnSelectionTableView.this.getTable().getColumnName(i));
                RColumnSelectionTableView.this.selectionArray[i] = bl;
            }
            if (!arrayList.isEmpty()) {
                RColumnSelectionTableView.this.getTable().getTableHeader().repaint();
                RColumnSelectionTableView.this.getTable().repaint();
                RColumnSelectionTableView.this.dispatchEvent(new ColumnSelectionEvent(bl, arrayList));
            }
        }

        private class SelectAll
        extends LoggableAction {
            public SelectAll() {
                this.putValue("Name", Messages.getString("Action.select_all"));
                this.putValue("SwingLargeIconKey", Icons.getIcon("16/tick.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                SelectionActions.this.selectAll(true);
            }
        }

        private class DeselectAll
        extends LoggableAction {
            public DeselectAll() {
                this.putValue("Name", Messages.getString("Action.deselect_all"));
                this.putValue("SwingLargeIconKey", Icons.getIcon("16/cross.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                SelectionActions.this.selectAll(false);
            }
        }

        private class InvertSelection
        extends LoggableAction {
            public InvertSelection() {
                this.putValue("Name", Messages.getString("Action.invert_selection"));
                this.putValue("SwingLargeIconKey", Icons.getIcon("16/select_invert.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                int n = RColumnSelectionTableView.this.getAndRefreshColumnCount();
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (int i = 0; i < n; ++i) {
                    boolean bl = RColumnSelectionTableView.this.selectionArray[i] = !RColumnSelectionTableView.this.selectionArray[i];
                    if (RColumnSelectionTableView.this.selectionArray[i]) {
                        arrayList.add(RColumnSelectionTableView.this.getTable().getColumnName(i));
                        continue;
                    }
                    arrayList2.add(RColumnSelectionTableView.this.getTable().getColumnName(i));
                }
                RColumnSelectionTableView.this.getTable().getTableHeader().repaint();
                RColumnSelectionTableView.this.getTable().repaint();
                if (!arrayList2.isEmpty()) {
                    RColumnSelectionTableView.this.dispatchEvent(new ColumnSelectionEvent(false, arrayList2));
                }
                if (!arrayList.isEmpty()) {
                    RColumnSelectionTableView.this.dispatchEvent(new ColumnSelectionEvent(true, arrayList));
                }
            }
        }
    }

    private class CheckBoxTableHeaderRenderer
    extends JPanel
    implements TableCellRenderer {
        private JCheckBox checkBox;
        private JLabel label;

        public CheckBoxTableHeaderRenderer() {
            this.setBackground(new Color(220, 220, 220));
            this.checkBox = new JCheckBox();
            this.label = new JLabel("", 0);
            this.label.setFont(RColumnSelectionTableView.this.getCodeFont());
            this.setLayout((LayoutManager)new MigLayout("insets 0, fill"));
            this.add((Component)this.checkBox, "alignx 50%, wrap");
            this.add((Component)this.label, "wmin 0, growx");
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.label.setText(object.toString());
            boolean bl3 = false;
            if (n2 < RColumnSelectionTableView.this.selectionArray.length) {
                bl3 = RColumnSelectionTableView.this.selectionArray[n2];
            }
            this.checkBox.setSelected(bl3);
            return this;
        }
    }

    private class CheckBoxHeaderMouseHandler
    extends MouseAdapter {
        private CheckBoxHeaderMouseHandler() {
        }

        private int getColumn(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.getY() > RColumnSelectionTableView.this.renderer.checkBox.getHeight()) {
                return -1;
            }
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            JTable jTable = jTableHeader.getTable();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            int n2 = mouseEvent.getX();
            int n3 = -1;
            if (n2 < 0) {
                return -1;
            }
            for (n = 0; n < tableColumnModel.getColumnCount(); ++n) {
                int n4 = tableColumnModel.getColumn(n).getWidth();
                if ((n2 -= n4) >= 0) continue;
                if (n2 >= -3 || n4 + n2 <= 3) break;
                n3 = n;
                break;
            }
            if ((n = jTable.convertColumnIndexToModel(n3)) < RColumnSelectionTableView.this.selectionArray.length) {
                return n;
            }
            return -1;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (UIUtility.isLeftMouseButton(mouseEvent)) {
                int n = this.getColumn(mouseEvent);
                if (n < 0) {
                    return;
                }
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                JTable jTable = jTableHeader.getTable();
                RColumnSelectionTableView.this.selectionArray[n] = !RColumnSelectionTableView.this.selectionArray[n];
                jTableHeader.repaint();
                jTable.repaint();
                mouseEvent.consume();
                boolean bl = RColumnSelectionTableView.this.selectionArray[n];
                ArrayList arrayList = Lists.newArrayList((Object[])new String[]{jTable.getColumnName(n)});
                RColumnSelectionTableView.this.dispatchEvent(new ColumnSelectionEvent(bl, arrayList));
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (UIUtility.isLeftMouseButton(mouseEvent)) {
                int n = this.getColumn(mouseEvent);
                if (n < 0) {
                    return;
                }
                mouseEvent.consume();
            }
        }
    }

    private class CellRenderer
    extends RDataObjectView.StringCellRenderer {
        private final Color disabledForeground = new Color(150, 150, 150);
        private final Color disabledBackground = new Color(240, 240, 240);

        CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!bl) {
                boolean bl3 = false;
                if (n2 < RColumnSelectionTableView.this.selectionArray.length) {
                    bl3 = RColumnSelectionTableView.this.selectionArray[n2];
                }
                if (!RColumnSelectionTableView.this.include) {
                    bl3 = !bl3;
                }
                this.setForeground(bl3 ? Color.BLACK : this.disabledForeground);
                this.setBackground(bl3 ? Color.WHITE : this.disabledBackground);
            }
            return this;
        }
    }

    public static class ColumnSelectionEvent
    extends Event<ColumnSelectionHandler> {
        private boolean added;
        private List<String> columns;

        public ColumnSelectionEvent(boolean bl, List<String> list) {
            this.added = bl;
            this.columns = list;
        }

        public boolean isAdded() {
            return this.added;
        }

        public boolean isRemoved() {
            return !this.added;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        @Override
        public void dispatch(ColumnSelectionHandler columnSelectionHandler) {
            columnSelectionHandler.columnSelectionChanged(this);
        }
    }

    public static interface ColumnSelectionHandler
    extends EventHandler {
        public void columnSelectionChanged(ColumnSelectionEvent var1);
    }
}

