/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.console.ConsoleEntry;
import com.ef_prime.rflow.core.app.r.console.ElementType;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.node.OpExecutor;
import com.ef_prime.rflow.core.task.NodeModelTask;
import com.ef_prime.rflow.core.task.RCommandTask;
import com.ef_prime.rflow.core.task.Task;
import com.ef_prime.rflow.core.task.TaskEvent;
import com.ef_prime.rflow.core.task.TaskEventHandler;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.ui.UINodeModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.console.RConsoleInput;
import com.ef_prime.rflow.ui.app.r.console.RConsoleOutput;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.view.View;
import java.awt.Color;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public class RConsoleResultView
extends View
implements TaskEventHandler,
HierarchyListener {
    public static final String PROPERTY_CONSOLE_RESULT = "PROPERTY_CONSOLE_RESULT";
    private RConsoleOutput output;
    private Task task;
    private OpExecutor executor;

    public RConsoleResultView(ValueMap valueMap, WidgetNode widgetNode) {
        this.setIconOnly(true);
        this.setIcon(Icons.getIcon("16/application_xp_terminal.png"));
        this.setTitle(Messages.getString("View.console"));
        this.output = new RConsoleOutput(){

            @Override
            protected void submitCommand(String string) {
            }

            @Override
            protected RConsoleInput getInput() {
                return null;
            }
        };
        JScrollPane jScrollPane = new JScrollPane(this.output, 22, 30);
        jScrollPane.setBorder(null);
        jScrollPane.getViewport().setBackground(Color.WHITE);
        this.add(jScrollPane);
        this.addHierarchyListener(this);
        this.executor = (OpExecutor)widgetNode.getRoot().getProperty(OpExecutor.PROPERTY_EXECUTOR);
        if (this.executor != null) {
            this.executor.addTaskEventHandler(this);
        }
    }

    public void setTask(Task task) {
        this.task = task;
        task.addTaskEventHandler(this);
    }

    @Override
    protected void refreshWorkDone(Object object) {
        List<ConsoleEntry> list;
        if (!(this.task instanceof NodeModelTask)) {
            return;
        }
        if (this.task instanceof RCommandTask) {
            list = ((RCommandTask)this.task).getConsoleEntries();
        } else {
            NodeModelTask nodeModelTask = (NodeModelTask)this.task;
            NodeModel object2 = nodeModelTask.getModel();
            if (!(object2 instanceof UINodeModel)) {
                return;
            }
            UINodeModel uINodeModel = (UINodeModel)object2;
            if (!(uINodeModel.getModel() instanceof ROperation)) {
                return;
            }
            ROperation rOperation = (ROperation)uINodeModel.getModel();
            list = rOperation.getConsoleEntries();
        }
        this.output.clear();
        if (list != null) {
            for (ConsoleEntry consoleEntry : list) {
                this.output.append(consoleEntry.getText(), consoleEntry.getType());
            }
        }
        this.output.append("(Elapsed time: " + this.task.getElapsedTimeString() + ")", ElementType.COMMENT_EOL);
    }

    @Override
    public void taskStateChanged(TaskEvent taskEvent) {
        this.task = taskEvent.getTask();
        if (taskEvent.isDone()) {
            this.task.removeTaskEventHandler(this);
            this.refresh();
        }
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        Container container = this;
        while (container.getParent() != null) {
            if (!((container = container.getParent()) instanceof Window)) continue;
            this.removeHierarchyListener(this);
            return;
        }
        if (container instanceof JComponent) {
            ((JComponent)container).putClientProperty(PROPERTY_CONSOLE_RESULT, this);
        }
    }
}

