/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.file.FileInfos;
import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandListener;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.task.NodeModelTask;
import com.ef_prime.rflow.core.task.Task;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.app.file.FileViewer;
import com.ef_prime.rflow.ui.app.r.RPreviewView;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Component;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;

public class RFilePreviewView
extends RPreviewView
implements CommandListener {
    private static final String PREVIEW_FILE = "preview.preview";
    private File previewDir;

    public RFilePreviewView(ValueMap valueMap, WidgetNode widgetNode) {
        super((ROperation)valueMap, widgetNode);
        this.add((Component)this.toolBar, "East");
    }

    @Override
    protected JToolBar createToolBar() {
        return new JToolBar(1);
    }

    private void refreshPreview() {
        final File file = this.getValidFile();
        UIUtility.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (file != null) {
                    FileInfos.getInstance().refreshFileInfo(file);
                    FileViewer fileViewer = new FileViewer();
                    fileViewer.setFile(file);
                    fileViewer.setActionButton(false);
                    RFilePreviewView.this.setPreview(fileViewer);
                } else {
                    RFilePreviewView.this.setPreview(null);
                }
            }
        });
    }

    private File getValidFile() {
        StrKey strKey = this.getModel().getFileExportKey();
        File file = new File(this.previewDir, PREVIEW_FILE);
        if (strKey == null) {
            return null;
        }
        if (!file.exists()) {
            File[] fileArray = this.previewDir.listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    if (!file2.isFile()) continue;
                    return file2;
                }
            }
            return null;
        }
        return file;
    }

    @Override
    protected Command createCommand(String string2, PreviewOption previewOption) throws Exception {
        if (this.previewDir == null) {
            this.previewDir = Rflow.project().createTempDir();
        } else {
            FileUtils.forceDelete((File)this.previewDir);
            FileUtils.forceMkdir((File)this.previewDir);
        }
        File file = new File(this.previewDir, PREVIEW_FILE);
        ROperation rOperation = (ROperation)this.getModel().copy();
        StrKey strKey = rOperation.getFileExportKey();
        String string3 = RUtility.quotedPath(file.getPath());
        rOperation.putValue(strKey, string3);
        rOperation.setPreviewOption(previewOption);
        Command command = rOperation.getRCommand(false, false, true, previewOption);
        if (command == null) {
            throw new Exception();
        }
        command.setCommandFunction(string -> R.client().noDebug((String)string));
        command.addCommandListener(this);
        return command;
    }

    @Override
    protected String getResultName(Task task) {
        String string = super.getResultName(task);
        if (string != null && string.length() > 0) {
            try {
                Path path = WorkingDirectory.getWorkingDirectory().toPath();
                Path path2 = path.relativize(Paths.get(string, new String[0]));
                string = path2.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    @Override
    protected void runTaskFinished(NodeModelTask nodeModelTask) {
        super.runTaskFinished(nodeModelTask);
        StrKey strKey = this.getModel().getFileExportKey();
        String string = this.getModel().getValueOrDefault(strKey);
        File file = new File(RUtility.unquote(string));
        String string2 = WorkingDirectory.toAbsolutePath(file.getPath());
        File file2 = new File(string2);
        if (!file2.exists()) {
            SwingUtilities.invokeLater(() -> this.setPreview(null));
        } else {
            SwingUtilities.invokeLater(() -> {
                FileViewer fileViewer = new FileViewer();
                fileViewer.setFile(file);
                fileViewer.setActionButton(false);
                this.setPreview(fileViewer);
            });
        }
    }

    @Override
    public boolean canUndo() {
        return false;
    }

    @Override
    public void undo() {
    }

    @Override
    protected void doApplyLastRun() {
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        if (this.previewDir != null) {
            FileUtils.deleteQuietly((File)this.previewDir);
        }
    }

    @Override
    public void commandStart(Command command) {
    }

    @Override
    public void commandFinished(Command command) {
        this.refreshPreview();
    }

    @Override
    public void commandCanceled(Command command) {
    }

    @Override
    public void errorOccurred(Command command) {
    }

    @Override
    public void commandDiscarded(Command command) {
    }
}

