/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandUtility;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.task.RCommandTask;
import com.ef_prime.rflow.core.task.TaskQueue;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.RBrowser;
import com.ef_prime.rflow.ui.app.r.RJavaUI;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.JTextFieldEx;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.view.ViewTabbedPane;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.FXBrowserView;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javafx.application.Platform;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javax.swing.Box;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.events.MouseEvent;
import org.w3c.dom.html.HTMLAnchorElement;

public class RHelpView
extends FXBrowserView
implements HierarchyListener,
ActionListener,
RBrowser {
    private RBrowser rBrowser;
    private ViewTabbedPane parentPane;

    public RHelpView() {
        this.setTitle(Messages.getString("R.Help.title"));
        this.setIcon(Icons.getIcon("16/help.png"));
        new RHelpActions().installActions(this, false, 1);
        this.setRBrowser(this);
    }

    @Override
    protected void configureToolBar(JToolBar jToolBar) {
        JTextFieldEx jTextFieldEx = new JTextFieldEx();
        jTextFieldEx.setPreferredSize(new Dimension(200, jTextFieldEx.getPreferredSize().height));
        jTextFieldEx.setMaximumSize(jTextFieldEx.getPreferredSize());
        jTextFieldEx.addActionListener(this);
        jTextFieldEx.setEmptyMessage(Messages.getString("R.Help.help_search"));
        jTextFieldEx.setClearButtonEnabled(true);
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar.add(jTextFieldEx);
    }

    @Override
    protected boolean handleLinkClick(MouseEvent mouseEvent) {
        boolean bl = super.handleLinkClick(mouseEvent);
        if (bl || !(mouseEvent.getCurrentTarget() instanceof HTMLAnchorElement)) {
            return bl;
        }
        HTMLAnchorElement hTMLAnchorElement = (HTMLAnchorElement)((Object)mouseEvent.getCurrentTarget());
        String string = hTMLAnchorElement.getHref();
        String string2 = hTMLAnchorElement.getAttribute("href");
        if (string2 != null && string2.startsWith("http")) {
            R.client().silentIdleEval("browseURL(url=" + RUtility.quote(string) + ")");
            mouseEvent.preventDefault();
            return true;
        }
        return false;
    }

    @Override
    protected ContextMenu createContextMenu(String string) {
        ContextMenu contextMenu = super.createContextMenu(string);
        if (string != null) {
            MenuItem menuItem = new MenuItem(Messages.getString("Action.run"));
            menuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.R, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
            menuItem.setOnAction(actionEvent -> this.runSelectedRScript(string));
            contextMenu.getItems().add((Object)menuItem);
        }
        return contextMenu;
    }

    private void runSelectedRScript(final String string) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String string2 = string;
                if (string2 == null && (string2 = RHelpView.this.getSelectedText()) == null) {
                    return;
                }
                string2 = string2.replaceAll("\r\n", "\n");
                string2 = string2.replaceAll("\r", "\n");
                Command command = CommandUtility.getLineSeparatedCommand(R.client(), string2);
                if (command == null) {
                    return;
                }
                command.addCommandListener(CommandUtility.objectUpdateListener(R.client()));
                RCommandTask rCommandTask = new RCommandTask(FlowRunOption.createRunImmediatelyOption(), command);
                TaskQueue.getInstance().addTask(rCommandTask);
            }
        });
    }

    public void setSavePosition(boolean bl) {
        this.removeHierarchyListener(this);
        if (bl) {
            this.addHierarchyListener(this);
        }
    }

    public void setRBrowser(RBrowser rBrowser) {
        this.rBrowser = rBrowser;
    }

    @Override
    protected String createTitle(String string, String string2, boolean bl) {
        Object object;
        int n;
        if (string == null) {
            string = "";
        }
        String string3 = "";
        if (string2 != null && (n = string2.lastIndexOf(47)) >= 0 && n + 1 < string2.length()) {
            string3 = string2.substring(n + 1, string2.length());
            if ((string3 = FilenameUtils.removeExtension((String)string3)).equals("00Index")) {
                string3 = "";
            }
        }
        if (((String)(object = string3)).isEmpty()) {
            if (string.startsWith("R: ")) {
                string = string.substring("R: ".length());
            }
            object = (String)object + string;
        }
        if (!bl) {
            object = Messages.getString("R.Help.title") + ": " + (String)object;
        }
        return object;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JTextField jTextField = (JTextField)actionEvent.getSource();
        final String string = jTextField.getText();
        if (string.isEmpty()) {
            return;
        }
        R.queryQueue().addQuery(new Runnable(){

            @Override
            public void run() {
                String string2 = "print(.rflowHelp(pattern = " + RUtility.quote(string) + "))";
                if (RHelpView.this.rBrowser == null) {
                    R.client().silentTimeoutEval(string2);
                } else {
                    RJavaUI.addBrowser(RHelpView.this.rBrowser);
                    try {
                        R.client().silentTimeoutEval(string2);
                    }
                    finally {
                        RJavaUI.removeBrowser(RHelpView.this.rBrowser);
                    }
                }
            }
        });
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        ViewTabbedPane viewTabbedPane = this.getParentTabbedPane();
        if (viewTabbedPane == null) {
            return;
        }
        if (this.parentPane != viewTabbedPane) {
            this.parentPane = viewTabbedPane;
            int n = Rflow.mainView().getSettingsTabPanePosition(this.parentPane);
            boolean bl = n == 1;
            this.setIconOnly(bl);
            this.setCloseButtonHidden(bl);
            this.updateTab();
            Rflow.settings().putValue(Settings.POSITION_HELP, n);
        }
    }

    @Override
    public void open(String string, boolean bl) {
        if (!bl) {
            return;
        }
        this.load(string);
    }

    private class RHelpActions
    extends Actions {
        public RHelpActions() {
            this.put(new Run());
        }

        private class Run
        extends LoggableAction {
            public Run() {
                this.putValue("Name", Messages.getString("Action.run"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                RHelpView.this.runSelectedRScript(null);
            }
        }
    }
}

