/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RInterface;
import com.ef_prime.rflow.core.app.r.base.RJavaInterface;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.console.RConsole;
import com.ef_prime.rflow.ui.app.r.RBrowser;
import com.ef_prime.rflow.ui.app.r.RPagerView;
import com.ef_prime.rflow.ui.app.r.object.RObjectViewer;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.common.view.ViewTabbedPane;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class RJavaUI
implements RJavaInterface {
    private static final Logger LOGGER = Logger.getLogger(RJavaUI.class.getName());
    private static List<RBrowser> browsers = new ArrayList<RBrowser>();
    private static int frame;
    private static int selectedFrame;

    public static void addBrowser(RBrowser rBrowser) {
        browsers.add(rBrowser);
    }

    public static void removeBrowser(RBrowser rBrowser) {
        browsers.remove(rBrowser);
    }

    public static void setSelectedFrame(int n) {
        selectedFrame = n;
    }

    public static int getFrame() {
        return frame;
    }

    @Override
    public int canBrowse() {
        if (R.console() != null) {
            return R.console().canBrowse() ? 1 : 0;
        }
        return 0;
    }

    @Override
    public void setFrame(int n) {
        frame = n;
    }

    @Override
    public int selectFrame() {
        return selectedFrame;
    }

    @Override
    public void pager(final String string, final String string2, final String string3, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RPagerView rPagerView = new RPagerView(string, string2, string3, bl);
                Rflow.mainView().openViewAtDefaultObjectPane(rPagerView, ViewOpenType.OPEN_NEW, true);
            }
        });
    }

    @Override
    public void browser(final String string, final boolean bl) {
        if (browsers.size() > 0) {
            browsers.get(browsers.size() - 1).open(string, bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Rflow.mainView().openBrowser(string, bl, true);
                }
            });
        }
    }

    @Override
    public void flushConsole() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RConsole rConsole = R.console();
                if (rConsole != null) {
                    rConsole.flushBuffer();
                }
            }
        });
    }

    @Override
    public void packageStatus(String string, boolean bl) {
        R.packageManager().packageStatus(string, bl);
    }

    @Override
    public void view(final String string, final String string2) {
        R.queryQueue().addQuery(new Runnable(){

            @Override
            public void run() {
                RObject rObject = RObject.environment(".RflowEnv").build();
                RObject rObject2 = RObject.environment(".VIEW_ENV").setParent(rObject).build();
                final RObject rObject3 = R.client().getObject(rObject2, string2);
                if (rObject3 == null) {
                    LOGGER.log(Level.WARNING, "Failed to get R object information for View()");
                    return;
                }
                rObject3.setDisplayName(string);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ViewObjectViewer viewObjectViewer = new ViewObjectViewer(R.getInterface(), rObject3);
                        View view2 = Rflow.mainView().getView(((View)viewObjectViewer).getKey());
                        if (view2 == null) {
                            Rflow.mainView().openViewAtDefaultObjectPane(viewObjectViewer, ViewOpenType.OPEN_NEW, true);
                        } else {
                            ViewTabbedPane viewTabbedPane = view2.getParentTabbedPane();
                            int n = viewTabbedPane.getIndexOfView(view2);
                            viewTabbedPane.closeTabAt(n);
                            viewTabbedPane.openView(viewObjectViewer, ViewOpenType.OPEN_NEW, true, n);
                        }
                    }
                });
            }
        });
    }

    private static class ViewObjectViewer
    extends RObjectViewer {
        private ViewRObject viewRObject;

        public ViewObjectViewer(RInterface rInterface, RObject rObject) {
            super(rInterface, rObject);
            this.viewRObject = new ViewRObject(rObject);
        }

        @Override
        public Object getKey() {
            return this.viewRObject;
        }

        @Override
        protected void viewDidBecomeUndisplayable() {
            super.viewDidBecomeUndisplayable();
            R.queryQueue().addQuery(new Runnable(){

                @Override
                public void run() {
                    RObject rObject = viewRObject.getViewRObject();
                    R.client().silentEval("rm(" + rObject.getName(true) + ", envir = " + rObject.getParent().getFullName() + ")");
                }
            });
        }

        private static class ViewRObject {
            private RObject viewRObject;

            public ViewRObject(RObject rObject) {
                this.viewRObject = rObject;
            }

            public RObject getViewRObject() {
                return this.viewRObject;
            }

            public boolean equals(Object object) {
                if (!(object instanceof ViewRObject)) {
                    return false;
                }
                RObject rObject = ((ViewRObject)object).viewRObject;
                return this.viewRObject.getDisplayName().equals(rObject.getDisplayName());
            }
        }
    }
}

