/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r;

import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.feature.search.TableTextSearchResult;
import com.ef_prime.rflow.ui.app.r.RMinimizedTableKey;
import com.ef_prime.rflow.ui.app.r.keyvalue.RTableKeyWidget;
import com.ef_prime.rflow.ui.app.r.script.RCodingTextArea;
import com.ef_prime.rflow.ui.common.keyvalue.LabeledWidget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.common.view.Page;
import com.ef_prime.rflow.ui.common.view.PagesView;
import com.ef_prime.rflow.ui.common.view.PagesViewFactory;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;

public class RMinimizedTableKeyWidget
extends LabeledWidget
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(RMinimizedTableKeyWidget.class.getName());
    private RCodingTextArea textArea;

    public RMinimizedTableKeyWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
    }

    public RMinimizedTableKey getKey() {
        return (RMinimizedTableKey)super.getKey();
    }

    @Override
    protected void loadContent() {
        KeysTableModel keysTableModel = (KeysTableModel)this.getKeyValue();
        this.textArea = new RCodingTextArea(this.getKey().getSummary(keysTableModel)){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension dimension = this.getPreferredSize();
                if (RMinimizedTableKeyWidget.this.getKey().getMaxRows() > 0) {
                    Insets insets = this.getInsets();
                    int n = this.getRowHeight() * RMinimizedTableKeyWidget.this.getKey().getMaxRows() + insets.bottom + insets.top;
                    dimension.height = Math.min(n, dimension.height);
                }
                return dimension;
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                if (this.getDocument().getLength() == 0) {
                    int n;
                    dimension.height = n = this.getLineHeight() + this.getInsets().top + this.getInsets().bottom;
                    return dimension;
                }
                Dimension dimension2 = this.getPreferredScrollableViewportSize();
                dimension.height = dimension2.height;
                return dimension;
            }
        };
        this.textArea.setEditable(false);
        this.textArea.setUneditableBackgroundColor();
        this.textArea.setHighlightCurrentLine(false);
        this.textArea.setMarkOccurrenceAfterFocus(false);
        this.textArea.setCaretTrace(false);
        this.textArea.setBracketMatchingEnabled(false);
        this.textArea.setBorder(new EmptyBorder(2, 4, 2, 4));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.textArea), 20, 31){

            @Override
            public Dimension getMinimumSize() {
                int n = this.getPreferredSize().height;
                return new Dimension(4, n);
            }
        };
        JButton jButton = new JButton("...");
        UIUtility.setPreferredWidth(30, jButton);
        jButton.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.add(this.createLayer(jScrollPane), "Center");
        this.add((Component)jButton, "East");
    }

    @Override
    protected Object getValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateWidget() {
        if (this.textArea == null) {
            return;
        }
        KeysTableModel keysTableModel = (KeysTableModel)this.getKeyValue();
        this.textArea.setText(this.getKey().getSummary(keysTableModel));
    }

    @Override
    public void select(SearchResult searchResult) {
        if (this.textArea == null || !(searchResult instanceof TableTextSearchResult)) {
            return;
        }
        TableTextSearchResult tableTextSearchResult = (TableTextSearchResult)searchResult;
        int n = this.getKey().getStringFunction().tableIndexToStringOffset((KeysTableModel)this.getKeyValue(), tableTextSearchResult.getRow(), tableTextSearchResult.getColumn());
        this.textArea.select(n + tableTextSearchResult.getOffset(), n + tableTextSearchResult.getEnd());
        try {
            this.textArea.scrollRectToVisible(this.textArea.modelToView(n + tableTextSearchResult.getEnd()));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.textArea.requestFocusInWindow();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Component component = WidgetFactory.getInstance().createWidget(RTableKeyWidget.class, this.getValueMap(), this.getWidgetNode());
            View view2 = new View();
            view2.add(component);
            Page page = new Page(view2);
            PagesView pagesView = PagesViewFactory.createCloseOnlyView(page);
            Dimension dimension = null;
            int[] nArray = this.getKey().getDialogSize();
            if (nArray != null) {
                dimension = new Dimension(nArray[0], nArray[1]);
            }
            pagesView.showDialog(this, this.getKey().getTitle(), false, dimension);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to create table widget.", exception);
        }
    }
}

