/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.feature.search.TextSearchResult;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.flow.FlowSegment;
import com.ef_prime.rflow.core.flow.RScriptExporter;
import com.ef_prime.rflow.core.flow.task.NodeTaskEntry;
import com.ef_prime.rflow.core.util.OperationFailedException;
import com.ef_prime.rflow.node.NodeModelChangeListener;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.script.RCodingScrollPane;
import com.ef_prime.rflow.ui.app.r.script.RCodingTextAreaEx;
import com.ef_prime.rflow.ui.app.r.script.RScriptUtility;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.MenuActionProvider;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.CodingSearchBar;
import com.ef_prime.rflow.ui.common.component.CodingStatusBar;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import org.fife.ui.rsyntaxtextarea.ErrorStrip;

public class RMultiNodesScriptView
extends View
implements NodeModelChangeListener,
MenuActionProvider {
    private static final Logger LOGGER = Logger.getLogger(RMultiNodesScriptView.class.getName());
    private Set<FlowNode> nodes;
    private FlowSegment segment;
    private RCodingTextAreaEx textArea;

    public RMultiNodesScriptView(Set<FlowNode> set, FlowSegment flowSegment, boolean bl) {
        this.nodes = set;
        this.segment = flowSegment;
        this.setIcon(Icons.getIcon("16/script.png"));
        this.setIconOnly(true);
        this.setTitle(Messages.getString("Widget.R.script"));
        this.textArea = new RCodingTextAreaEx("");
        this.textArea.setEditable(false);
        this.textArea.setCodeFoldingEnabled(true);
        this.textArea.setUneditableBackgroundColor();
        this.textArea.setHighlightCurrentLine(false);
        this.textArea.setHighlightCurrentLineOnFocus(true);
        RCodingScrollPane rCodingScrollPane = new RCodingScrollPane(this.textArea, null);
        rCodingScrollPane.setPreferredSize(new Dimension(500, 300));
        ErrorStrip errorStrip = RScriptUtility.createErrorStrip(this.textArea);
        CodingStatusBar codingStatusBar = new CodingStatusBar(this.textArea);
        CodingSearchBar codingSearchBar = new CodingSearchBar(this.textArea);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)((Object)rCodingScrollPane), "Center");
        jPanel.add((Component)codingSearchBar, "South");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)errorStrip, "East");
        jPanel2.add((Component)codingStatusBar, "South");
        this.add((Component)jPanel2, "Center");
        if (bl) {
            NodesActions nodesActions = new NodesActions();
            JToolBar jToolBar = new JToolBar();
            jToolBar.setFloatable(false);
            jToolBar.add(this.createToolBarButton(nodesActions.get(NodesActions.Run.class)));
            this.add((Component)jToolBar, "North");
        }
        this.refresh();
    }

    private JButton createToolBarButton(Action action) {
        JButton jButton = new JButton(action);
        String string = (String)action.getValue("Name");
        if (string == null) {
            jButton.setHideActionText(true);
        }
        jButton.setFocusable(false);
        return jButton;
    }

    @Override
    public void select(SearchResult searchResult) {
        if (!(searchResult instanceof TextSearchResult) && this.textArea != null) {
            return;
        }
        final TextSearchResult textSearchResult = (TextSearchResult)searchResult;
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                return null;
            }

            @Override
            protected void done() {
                RMultiNodesScriptView.this.textArea.select(textSearchResult.getOffset(), textSearchResult.getEnd());
                RMultiNodesScriptView.this.textArea.requestFocusInWindow();
            }
        };
        this.getExecutor().submit(swingWorker);
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        super.viewDidBecomeDisplayable();
        FlowNode.addNodeModelChangeListener(this);
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        FlowNode.removeNodeModelChangeListener(this);
    }

    @Override
    protected Object refreshWork() throws Exception {
        Optional<FlowModel> optional = this.nodes.iterator().next().getFlowModel();
        if (optional.isPresent()) {
            return RScriptExporter.buildScript(optional.get().getExecutor(), new NodeTaskEntry(this.segment.getEnd(), this.segment.getStart()));
        }
        return "";
    }

    @Override
    protected void refreshWorkDone(Object object) {
        String string = "";
        if (object instanceof String) {
            string = (String)object;
        }
        this.textArea.setText(string);
        this.textArea.setCaretPosition(0);
    }

    @Override
    public void nodeModelChanged(FlowNode flowNode) {
        if (this.nodes.contains(flowNode)) {
            this.refresh();
        }
    }

    @Override
    public void subflowNodeModelChanged(FlowNode flowNode) {
        if (this.nodes.contains(flowNode)) {
            this.refresh();
        }
    }

    @Override
    public Action getAction(String string) {
        if (this.textArea != null) {
            return this.textArea.getAction(string);
        }
        return null;
    }

    private class NodesActions
    extends Actions {
        public NodesActions() {
            this.put(new Run());
        }

        private class Run
        extends LoggableAction {
            public Run() {
                this.putValue("Name", Messages.getString("Action.run"));
                this.putValue("SmallIcon", Icons.getIcon("16/resultset_next.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                try {
                    Optional<FlowModel> optional = RMultiNodesScriptView.this.nodes.iterator().next().getFlowModel();
                    if (optional.isPresent()) {
                        optional.get().getExecutor().runNode(RMultiNodesScriptView.this.segment.getEnd(), RMultiNodesScriptView.this.segment.getStart(), FlowRunOption.createRunSelectedNodeOption(false));
                    }
                }
                catch (OperationFailedException operationFailedException) {
                    LOGGER.log(Level.SEVERE, "Failed to run node.", operationFailedException);
                    UIUtility.showErrorDialog((Component)Rflow.mainFrame(), operationFailedException.getMessage());
                }
            }
        }
    }
}

