/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RObjectSet;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandListener;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.task.NodeModelTask;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.RPreviewView;
import com.ef_prime.rflow.ui.app.r.object.RObjectBrowser;
import com.ef_prime.rflow.ui.app.r.object.RObjectView;
import com.ef_prime.rflow.ui.app.r.object.RObjectViewer;
import com.ef_prime.rflow.ui.common.component.FlatSplitPane;
import com.ef_prime.rflow.ui.common.item.ItemEvent;
import com.ef_prime.rflow.ui.common.item.ItemName;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.apache.commons.lang3.ArrayUtils;

public class RObjectPreviewView
extends RPreviewView
implements CommandListener {
    private String previewEnv;
    private String undoEnv;
    private RObjectViewer objectView;
    private RObjectBrowserView objectBrowser;

    public RObjectPreviewView(ValueMap valueMap, WidgetNode widgetNode) {
        this((ROperation)valueMap, widgetNode);
    }

    public RObjectPreviewView(ROperation rOperation, WidgetNode widgetNode) {
        super(rOperation, widgetNode);
        if (this.isPreviewRunEnabled()) {
            this.add((Component)this.toolBar, "East");
        }
    }

    @Override
    protected JToolBar createToolBar() {
        return new JToolBar(1);
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        if (this.previewEnv != null) {
            R.client().clearPreviewEnv(this.previewEnv);
            this.previewEnv = null;
        }
    }

    @Override
    protected void doApplyLastRun() {
        if (this.previewEnv == null) {
            return;
        }
        String string = R.client().getPreviewEnv(this.previewEnv);
        String string2 = "invisible(lapply(ls(" + string + "), function(x){assign(x, " + string + "[[x]], envir = .GlobalEnv)}))";
        R.client().silentIdleEval(string2);
        R.client().fireItemStructureChanged();
    }

    private void preparePreviewEnv() {
        if (this.previewEnv == null) {
            this.previewEnv = R.client().createNewPreviewEnv();
        } else {
            R.client().recreatePreviewEnv(this.previewEnv);
        }
    }

    private void prepareUndoEnv() {
        if (this.undoEnv == null) {
            this.undoEnv = R.client().createNewPreviewEnv();
        } else {
            R.client().recreatePreviewEnv(this.undoEnv);
        }
    }

    @Override
    protected Command createCommand(String string2, PreviewOption previewOption) throws Exception {
        this.preparePreviewEnv();
        previewOption.setProperty("PREVIEW_PROPERTY_ENV", R.client().getPreviewEnv(this.previewEnv));
        Operation operation = this.getModel().copy();
        operation.setPreviewOption(previewOption);
        Command command = operation.getRCommand(false, false, true, previewOption);
        if (command == null) {
            throw new Exception();
        }
        command.setCommandFunction(string -> R.client().noDebug("evalq({" + string + "}, envir=" + R.client().getPreviewEnv(this.previewEnv) + ")"));
        command.addCommandListener(this);
        return command;
    }

    @Override
    protected void prepareUndo() {
        this.prepareUndoEnv();
        Object[] objectArray = this.getModel().getNewItemNames();
        if (ArrayUtils.isEmpty((Object[])objectArray)) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : objectArray) {
            arrayList.add(((ItemName)object).getName());
        }
        String string = RUtility.combineCharacters(arrayList);
        String string2 = R.client().getPreviewEnv(this.undoEnv);
        ScriptBuilder scriptBuilder = new ScriptBuilder("\n");
        scriptBuilder.appendLn("evalq({");
        scriptBuilder.appendLn("exists <- new.env()");
        scriptBuilder.appendLn("nonexists <- new.env()");
        scriptBuilder.appendLn("invisible(lapply(" + string + ", function(x){");
        scriptBuilder.appendLn("\tif (exists(x, envir = .GlobalEnv, inherits = FALSE)) {");
        scriptBuilder.appendLn("\t\tassign(x, .GlobalEnv[[x]], envir = exists)");
        scriptBuilder.appendLn("\t} else {");
        scriptBuilder.appendLn("\t\tassign(x, NULL, envir = nonexists)");
        scriptBuilder.appendLn("\t}");
        scriptBuilder.appendLn("\t}))");
        scriptBuilder.appendLn("}, envir = " + string2 + ")");
        R.client().silentIdleEval(scriptBuilder.toString());
    }

    @Override
    public boolean canUndo() {
        return this.undoEnv != null;
    }

    @Override
    public void undo() {
        if (!this.canUndo()) {
            return;
        }
        if (this.undoEnv != null) {
            String string = R.client().getPreviewEnv(this.undoEnv);
            R.client().silentIdleEval("invisible(lapply(ls(" + string + "$exists), function(x){assign(x, " + string + "$exists[[x]], envir = .GlobalEnv)}))");
            R.client().silentIdleEval("rm(list = ls(" + string + "$nonexists), envir = .GlobalEnv)");
            R.client().fireItemStructureChanged();
        }
        R.client().clearPreviewEnv(this.undoEnv);
        this.undoEnv = null;
        if (this.autoRefresh.isSelected()) {
            this.refresh();
        } else {
            this.setChanged(true);
        }
    }

    protected void setPreview(RObject rObject, boolean bl) {
        UIUtility.invokeLater(() -> {
            Component component = null;
            if (bl) {
                component = this.getPreviewRObjectView(rObject);
            }
            if (component == null) {
                component = this.getRObjectView(rObject);
            }
            if (component instanceof RObjectViewer) {
                RObjectViewer rObjectViewer = (RObjectViewer)component;
                if (rObject == null) {
                    rObjectViewer.clearView();
                } else {
                    rObjectViewer.setRObject(rObject);
                }
            } else if (component instanceof RObjectView) {
                ((RObjectView)component).setRObject(rObject);
            }
            this.setPreview(component);
        });
    }

    private RObjectViewer getRObjectView(RObject rObject) {
        if (this.objectView == null) {
            this.objectView = new RObjectViewer(R.getInterface(), rObject);
            this.objectView.setActionButton(false);
        }
        return this.objectView;
    }

    protected Component getPreviewRObjectView(RObject rObject) {
        return null;
    }

    @Override
    protected void runTaskFinished(NodeModelTask nodeModelTask) {
        super.runTaskFinished(nodeModelTask);
        ItemEvent itemEvent = this.getModel().getItemEvent();
        if (itemEvent != null && itemEvent.getType() == 1) {
            this.showRObjectBrowser(null, null, null);
            return;
        }
        List<ItemName> list = nodeModelTask.getResults();
        if (list.isEmpty()) {
            return;
        }
        if (list.size() > 1 || this.getModel().showPreviewInBrowser()) {
            this.showRObjectBrowser(list, null, null);
            return;
        }
        ItemName itemName = list.get(0);
        RObject rObject = R.client().getObject(itemName.getName());
        this.setPreview(rObject, false);
    }

    private void showRObjectBrowser(List<ItemName> list, RObjectSet rObjectSet, String string) {
        SwingUtilities.invokeLater(() -> {
            List list2;
            if (this.objectBrowser == null) {
                this.objectBrowser = new RObjectBrowserView();
            }
            if ((list2 = list) != null && list2.isEmpty()) {
                list2 = null;
            }
            this.objectBrowser.setResults(list2, rObjectSet, string, this.getModel().showPreviewInBrowser());
            this.setPreview(this.objectBrowser);
        });
    }

    protected void refreshPreview() {
        RObject rObject = R.client().getPreviewEnvObject(this.previewEnv);
        RObjectSet rObjectSet = R.client().getObjects(rObject, true, 100);
        if (rObjectSet == null || rObjectSet.getSize() == 0) {
            this.setPreview(null, true);
            return;
        }
        if (rObjectSet.getSize() == 1 && !this.getModel().showPreviewInBrowser()) {
            this.setPreview(rObjectSet.getObjects().get(0), true);
        } else {
            Object[] objectArray = this.getModel().getNewItemNames();
            List list = objectArray == null ? Collections.EMPTY_LIST : Lists.newArrayList((Object[])objectArray);
            this.showRObjectBrowser(list, rObjectSet, this.previewEnv);
        }
    }

    @Override
    public void commandStart(Command command) {
    }

    @Override
    public void commandFinished(Command command) {
        this.refreshPreview();
    }

    @Override
    public void commandCanceled(Command command) {
    }

    @Override
    public void errorOccurred(Command command) {
    }

    @Override
    public void commandDiscarded(Command command) {
    }

    private static class RObjectBrowserView
    extends JPanel
    implements TreeSelectionListener,
    Supplier<RObjectSet> {
        private RObjectBrowser browser = new RObjectBrowser(Messages.getString("Explorer.objects.root"), null, false){

            @Override
            protected void updateFinished() {
                this.selectionChanged();
            }
        };
        private RObjectViewer preview;
        private List<ItemName> results;
        private RObjectSet resultSet;

        public RObjectBrowserView() {
            this.browser.addTreeSelectionListener(this);
            this.preview = new RObjectViewer(R.getInterface(), null);
            this.preview.setBrowser(this.browser);
            this.preview.setActionButton(false);
            this.preview.setAutoRefresh(false);
            FlatSplitPane flatSplitPane = new FlatSplitPane(this.browser, (Component)this.preview, 250);
            this.setLayout(new BorderLayout());
            this.add(flatSplitPane);
        }

        private void setResults(List<ItemName> list, RObjectSet rObjectSet, String string, boolean bl) {
            this.results = list;
            this.resultSet = rObjectSet;
            if (this.results != null) {
                this.results.sort(Comparator.comparing(ItemName::getName));
            }
            if (list != null || rObjectSet != null) {
                this.browser.setObjectSetSupplier(this);
                this.browser.setPresention(0);
                this.browser.update(true);
                SwingUtilities.invokeLater(() -> {
                    if (this.browser.getTree().isSelectionEmpty()) {
                        Object object;
                        if (list != null) {
                            object = ((ItemName)list.get(list.size() - 1)).getName();
                            if (string != null) {
                                object = R.client().getPreviewEnv(string) + "$" + (String)object;
                            }
                        } else {
                            object = rObjectSet.getObjects().get(rObjectSet.getObjects().size() - 1).getFullName(false);
                        }
                        this.browser.select((String)object, false, bl);
                    }
                });
            } else {
                this.browser.setObjectSetSupplier(null);
                String string2 = Rflow.settings().getValue(Settings.ROBJECT_TREE_PRESENTATION);
                this.browser.setPresention(string2.equals("hierarchical") ? 1 : 0);
                this.browser.update(true);
            }
            this.preview.refreshView();
        }

        @Override
        public RObjectSet get() {
            if (this.results == null && this.resultSet == null) {
                return null;
            }
            if (this.resultSet != null) {
                return this.resultSet;
            }
            ArrayList<RObject> arrayList = new ArrayList<RObject>(this.results.size());
            for (ItemName itemName : this.results) {
                RObject rObject = R.client().getObject(itemName.getName());
                if (rObject == null) continue;
                arrayList.add(rObject);
            }
            return new RObjectSet(arrayList, 0, 0, arrayList.size());
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            this.selectionChanged();
        }

        private void selectionChanged() {
            if (!this.browser.isRefreshing() && !this.browser.isWeakSelection()) {
                RObject rObject;
                ArrayList arrayList = this.browser.getSelectedObjects(true);
                if (arrayList.isEmpty() && (rObject = this.browser.getWeakSelection()) != null) {
                    arrayList = Lists.newArrayList((Object[])new RObject[]{rObject});
                }
                if (arrayList.isEmpty()) {
                    this.preview.clearView();
                } else {
                    this.preview.setRObject(RObjectViewer.convertObject(arrayList));
                }
            }
        }
    }
}

