/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RInterface;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.console.BasicCommand;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandListener;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.feature.history.HistoryManager;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.task.NodeModelTask;
import com.ef_prime.rflow.core.task.Task;
import com.ef_prime.rflow.core.util.ArgsList;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.node.ui.UINodeModel;
import com.ef_prime.rflow.ui.app.base.AbstractPreviewView;
import com.ef_prime.rflow.ui.app.base.Preview;
import com.ef_prime.rflow.ui.app.r.RPreviewView;
import com.ef_prime.rflow.ui.app.r.RflowGDView;
import com.ef_prime.rflow.ui.app.r.gd.GD;
import com.ef_prime.rflow.ui.app.r.gd.GDHandler;
import com.ef_prime.rflow.ui.app.r.gd.GDView;
import com.ef_prime.rflow.ui.common.component.Refreshable;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class RPlotPreviewView
extends RPreviewView {
    private PreviewHandler previewHandler = new PreviewHandler();

    public RPlotPreviewView(ValueMap valueMap, WidgetNode widgetNode) {
        this((ROperation)valueMap, widgetNode);
    }

    public RPlotPreviewView(ROperation rOperation, WidgetNode widgetNode) {
        super(rOperation, widgetNode);
        this.setRefreshDelay(100L);
    }

    @Override
    protected JToolBar createToolBar() {
        return new JToolBar(1);
    }

    @Override
    protected void configureToolBar() {
        this.autoRefresh = this.createAutoRefreshButton();
        this.toolBar.setFloatable(false);
        if (this.getWidgetNode().getProperty(Preview.REFRESH_BUTTON).booleanValue()) {
            this.toolBar.add(new JButton(this.getActionMap().get("ACTION_REFRESH")));
        }
        this.toolBar.add(this.autoRefresh);
        this.toolBar.add(new AbstractPreviewView.PreviewSettingsPanel());
    }

    @Override
    public void run() {
        this.prepareRun();
        this.runInPreview();
        NodeModelTask nodeModelTask = new NodeModelTask(new FlowRunOption(), new UINodeModel(this.getModel().copy()));
        if (Rflow.isDevel()) {
            HistoryManager.getInstance().add(nodeModelTask);
        }
    }

    @Override
    public boolean supportsRunResultView() {
        return true;
    }

    @Override
    protected void doApplyLastRun() {
    }

    @Override
    public boolean canUndo() {
        return false;
    }

    @Override
    public void undo() {
    }

    @Override
    protected Command createCommand(String string, PreviewOption previewOption) throws Exception {
        Object object;
        Operation operation = this.getModel().copy();
        operation.setPreviewOption(previewOption);
        String string2 = operation.getRScript(false, true, previewOption);
        if (string2 == null) {
            throw new Exception();
        }
        ArgsList argsList = new ArgsList();
        argsList.add("", "{" + string2 + "}");
        if (previewOption.getNumber() > 0L) {
            argsList.add("sample", Long.toString(previewOption.getNumber()));
        }
        if (this.previewHandler.gdView != null) {
            object = this.previewHandler.gdView.getCanvasSize();
            argsList.add("width", Integer.toString(((Dimension)object).width));
            argsList.add("height", Integer.toString(((Dimension)object).height));
        }
        object = RUtility.function(".backgroundPlot", argsList);
        if (previewOption.isEnabled()) {
            object = R.client().noDebug((String)object);
        }
        BasicCommand basicCommand = new BasicCommand((String)object);
        basicCommand.addCommandListener(this.previewHandler);
        return basicCommand;
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        this.previewHandler.unloadGDView();
    }

    private class PreviewHandler
    implements CommandListener,
    GDHandler,
    Refreshable {
        private JPanel panel = new JPanel(new BorderLayout());
        private GDView gdView;

        public PreviewHandler() {
            this.panel.add((Component)RPlotPreviewView.this.toolBar, "East");
            RPlotPreviewView.this.setPreview(this.panel);
        }

        private void unloadGDView() {
            if (this.gdView != null) {
                this.gdView.unloadView();
            }
        }

        @Override
        public GDView openGraphicDevice(RInterface rInterface, int n, int n2) {
            if (this.gdView == null) {
                this.gdView = new RflowGDView(rInterface, new Dimension(n, n2), true);
                this.gdView.setRefreshable(this);
                this.gdView.setCloseParentView(false);
                this.gdView.setResizeTest(gDView -> RPlotPreviewView.this.getErrorMessage() == null);
                this.panel.add((Component)this.gdView, "Center");
                this.panel.revalidate();
            }
            this.gdView.loadView();
            return this.gdView;
        }

        @Override
        public void commandStart(Command command) {
            GD.addGDHandler(this);
        }

        @Override
        public void commandFinished(Command command) {
            GD.removeGDHandler(this);
            UIUtility.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PreviewHandler.this.unloadGDView();
                }
            });
        }

        @Override
        public void commandCanceled(Command command) {
        }

        @Override
        public void errorOccurred(Command command) {
        }

        @Override
        public void commandDiscarded(Command command) {
        }

        @Override
        public void refresh() {
            Task task = RPlotPreviewView.this.getResultTask();
            if (task == null || task.isPreview()) {
                RPlotPreviewView.this.refresh();
            } else {
                RPlotPreviewView.this.run();
            }
        }
    }
}

